/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an ML input channel in a collaboration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollaborationMLInputChannelSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CollaborationMLInputChannelSummary.Builder, CollaborationMLInputChannelSummary> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(CollaborationMLInputChannelSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(CollaborationMLInputChannelSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CollaborationMLInputChannelSummary::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(CollaborationMLInputChannelSummary::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CollaborationMLInputChannelSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("configuredModelAlgorithmAssociations")
            .getter(getter(CollaborationMLInputChannelSummary::configuredModelAlgorithmAssociations))
            .setter(setter(Builder::configuredModelAlgorithmAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlInputChannelArn").getter(getter(CollaborationMLInputChannelSummary::mlInputChannelArn))
            .setter(setter(Builder::mlInputChannelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CollaborationMLInputChannelSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorAccountId").getter(getter(CollaborationMLInputChannelSummary::creatorAccountId))
            .setter(setter(Builder::creatorAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CollaborationMLInputChannelSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, NAME_FIELD,
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, STATUS_FIELD, CREATOR_ACCOUNT_ID_FIELD,
            DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createTime;

    private final Instant updateTime;

    private final String membershipIdentifier;

    private final String collaborationIdentifier;

    private final String name;

    private final List<String> configuredModelAlgorithmAssociations;

    private final String mlInputChannelArn;

    private final String status;

    private final String creatorAccountId;

    private final String description;

    private CollaborationMLInputChannelSummary(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.status = builder.status;
        this.creatorAccountId = builder.creatorAccountId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The time at which the ML input channel was created.
     * </p>
     * 
     * @return The time at which the ML input channel was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the ML input channel was updated.
     * </p>
     * 
     * @return The most recent time at which the ML input channel was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the ML input channel.
     * </p>
     * 
     * @return The membership ID of the membership that contains the ML input channel.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the ML input channel.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the ML input channel.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The name of the ML input channel.
     * </p>
     * 
     * @return The name of the ML input channel.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfiguredModelAlgorithmAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations != null
                && !(configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associated configured model algorithms used to create the ML input channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguredModelAlgorithmAssociations}
     * method.
     * </p>
     * 
     * @return The associated configured model algorithms used to create the ML input channel.
     */
    public final List<String> configuredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML input channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML input channel.
     */
    public final String mlInputChannelArn() {
        return mlInputChannelArn;
    }

    /**
     * <p>
     * The status of the ML input channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MLInputChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML input channel.
     * @see MLInputChannelStatus
     */
    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the ML input channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MLInputChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the ML input channel.
     * @see MLInputChannelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The account ID of the member who created the ML input channel.
     * </p>
     * 
     * @return The account ID of the member who created the ML input channel.
     */
    public final String creatorAccountId() {
        return creatorAccountId;
    }

    /**
     * <p>
     * The description of the ML input channel.
     * </p>
     * 
     * @return The description of the ML input channel.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creatorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaborationMLInputChannelSummary)) {
            return false;
        }
        CollaborationMLInputChannelSummary other = (CollaborationMLInputChannelSummary) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(name(), other.name())
                && hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations()
                && Objects.equals(configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations())
                && Objects.equals(mlInputChannelArn(), other.mlInputChannelArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creatorAccountId(), other.creatorAccountId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CollaborationMLInputChannelSummary")
                .add("CreateTime", createTime())
                .add("UpdateTime", updateTime())
                .add("MembershipIdentifier", membershipIdentifier())
                .add("CollaborationIdentifier", collaborationIdentifier())
                .add("Name", name())
                .add("ConfiguredModelAlgorithmAssociations",
                        hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null)
                .add("MlInputChannelArn", mlInputChannelArn()).add("Status", statusAsString())
                .add("CreatorAccountId", creatorAccountId()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configuredModelAlgorithmAssociations":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociations()));
        case "mlInputChannelArn":
            return Optional.ofNullable(clazz.cast(mlInputChannelArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creatorAccountId":
            return Optional.ofNullable(clazz.cast(creatorAccountId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaborationMLInputChannelSummary, T> g) {
        return obj -> g.apply((CollaborationMLInputChannelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollaborationMLInputChannelSummary> {
        /**
         * <p>
         * The time at which the ML input channel was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the ML input channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the ML input channel was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the ML input channel was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The membership ID of the membership that contains the ML input channel.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the ML input channel.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The name of the ML input channel.
         * </p>
         * 
         * @param name
         *        The name of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The associated configured model algorithms used to create the ML input channel.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The associated configured model algorithms used to create the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The associated configured model algorithms used to create the ML input channel.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The associated configured model algorithms used to create the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(String... configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML input channel.
         * </p>
         * 
         * @param mlInputChannelArn
         *        The Amazon Resource Name (ARN) of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlInputChannelArn(String mlInputChannelArn);

        /**
         * <p>
         * The status of the ML input channel.
         * </p>
         * 
         * @param status
         *        The status of the ML input channel.
         * @see MLInputChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLInputChannelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the ML input channel.
         * </p>
         * 
         * @param status
         *        The status of the ML input channel.
         * @see MLInputChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MLInputChannelStatus
         */
        Builder status(MLInputChannelStatus status);

        /**
         * <p>
         * The account ID of the member who created the ML input channel.
         * </p>
         * 
         * @param creatorAccountId
         *        The account ID of the member who created the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorAccountId(String creatorAccountId);

        /**
         * <p>
         * The description of the ML input channel.
         * </p>
         * 
         * @param description
         *        The description of the ML input channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String membershipIdentifier;

        private String collaborationIdentifier;

        private String name;

        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();

        private String mlInputChannelArn;

        private String status;

        private String creatorAccountId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaborationMLInputChannelSummary model) {
            createTime(model.createTime);
            updateTime(model.updateTime);
            membershipIdentifier(model.membershipIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            name(model.name);
            configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            mlInputChannelArn(model.mlInputChannelArn);
            status(model.status);
            creatorAccountId(model.creatorAccountId);
            description(model.description);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CollaborationMLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier
                    .copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = CollaborationMLInputChannelSummaryConfiguredModelAlgorithmAssociationsListCopier
                    .copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String... configuredModelAlgorithmAssociations) {
            configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getMlInputChannelArn() {
            return mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatorAccountId() {
            return creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public CollaborationMLInputChannelSummary build() {
            return new CollaborationMLInputChannelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
