/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAudienceGenerationJobResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetAudienceGenerationJobResponse.Builder, GetAudienceGenerationJobResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetAudienceGenerationJobResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetAudienceGenerationJobResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> AUDIENCE_GENERATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audienceGenerationJobArn").getter(getter(GetAudienceGenerationJobResponse::audienceGenerationJobArn))
            .setter(setter(Builder::audienceGenerationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audienceGenerationJobArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAudienceGenerationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetAudienceGenerationJobResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAudienceGenerationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField
            .<StatusDetails> builder(MarshallingType.SDK_POJO).memberName("statusDetails")
            .getter(getter(GetAudienceGenerationJobResponse::statusDetails)).setter(setter(Builder::statusDetails))
            .constructor(StatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()).build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(GetAudienceGenerationJobResponse::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<AudienceGenerationJobDataSource> SEED_AUDIENCE_FIELD = SdkField
            .<AudienceGenerationJobDataSource> builder(MarshallingType.SDK_POJO).memberName("seedAudience")
            .getter(getter(GetAudienceGenerationJobResponse::seedAudience)).setter(setter(Builder::seedAudience))
            .constructor(AudienceGenerationJobDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seedAudience").build()).build();

    private static final SdkField<Boolean> INCLUDE_SEED_IN_OUTPUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeSeedInOutput").getter(getter(GetAudienceGenerationJobResponse::includeSeedInOutput))
            .setter(setter(Builder::includeSeedInOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeSeedInOutput").build())
            .build();

    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(GetAudienceGenerationJobResponse::collaborationId))
            .setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<AudienceQualityMetrics> METRICS_FIELD = SdkField
            .<AudienceQualityMetrics> builder(MarshallingType.SDK_POJO).memberName("metrics")
            .getter(getter(GetAudienceGenerationJobResponse::metrics)).setter(setter(Builder::metrics))
            .constructor(AudienceQualityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(GetAudienceGenerationJobResponse::startedBy))
            .setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetAudienceGenerationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PROTECTED_QUERY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protectedQueryIdentifier").getter(getter(GetAudienceGenerationJobResponse::protectedQueryIdentifier))
            .setter(setter(Builder::protectedQueryIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedQueryIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, AUDIENCE_GENERATION_JOB_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD,
            STATUS_DETAILS_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, SEED_AUDIENCE_FIELD, INCLUDE_SEED_IN_OUTPUT_FIELD,
            COLLABORATION_ID_FIELD, METRICS_FIELD, STARTED_BY_FIELD, TAGS_FIELD, PROTECTED_QUERY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final String audienceGenerationJobArn;

    private final String name;

    private final String description;

    private final String status;

    private final StatusDetails statusDetails;

    private final String configuredAudienceModelArn;

    private final AudienceGenerationJobDataSource seedAudience;

    private final Boolean includeSeedInOutput;

    private final String collaborationId;

    private final AudienceQualityMetrics metrics;

    private final String startedBy;

    private final Map<String, String> tags;

    private final String protectedQueryIdentifier;

    private GetAudienceGenerationJobResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.audienceGenerationJobArn = builder.audienceGenerationJobArn;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.seedAudience = builder.seedAudience;
        this.includeSeedInOutput = builder.includeSeedInOutput;
        this.collaborationId = builder.collaborationId;
        this.metrics = builder.metrics;
        this.startedBy = builder.startedBy;
        this.tags = builder.tags;
        this.protectedQueryIdentifier = builder.protectedQueryIdentifier;
    }

    /**
     * <p>
     * The time at which the audience generation job was created.
     * </p>
     * 
     * @return The time at which the audience generation job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the audience generation job was updated.
     * </p>
     * 
     * @return The most recent time at which the audience generation job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the audience generation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the audience generation job.
     */
    public final String audienceGenerationJobArn() {
        return audienceGenerationJobArn;
    }

    /**
     * <p>
     * The name of the audience generation job.
     * </p>
     * 
     * @return The name of the audience generation job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the audience generation job.
     * </p>
     * 
     * @return The description of the audience generation job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the audience generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience generation job.
     * @see AudienceGenerationJobStatus
     */
    public final AudienceGenerationJobStatus status() {
        return AudienceGenerationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the audience generation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AudienceGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the audience generation job.
     * @see AudienceGenerationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Details about the status of the audience generation job.
     * </p>
     * 
     * @return Details about the status of the audience generation job.
     */
    public final StatusDetails statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The seed audience that was used for this audience generation job. This field will be null if the account calling
     * the API is the account that started this audience generation job.
     * </p>
     * 
     * @return The seed audience that was used for this audience generation job. This field will be null if the account
     *         calling the API is the account that started this audience generation job.
     */
    public final AudienceGenerationJobDataSource seedAudience() {
        return seedAudience;
    }

    /**
     * <p>
     * Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes seed
     * users from the output audience. If you specify <code>TRUE</code>, the seed users will appear first in the output.
     * Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the recipient of the audience will
     * know that the first <code>minimumSeedSize</code> count of users are from the seed.
     * </p>
     * 
     * @return Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes
     *         seed users from the output audience. If you specify <code>TRUE</code>, the seed users will appear first
     *         in the output. Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the
     *         recipient of the audience will know that the first <code>minimumSeedSize</code> count of users are from
     *         the seed.
     */
    public final Boolean includeSeedInOutput() {
        return includeSeedInOutput;
    }

    /**
     * <p>
     * The identifier of the collaboration that this audience generation job is associated with.
     * </p>
     * 
     * @return The identifier of the collaboration that this audience generation job is associated with.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The relevance scores for different audience sizes and the recall score of the generated audience.
     * </p>
     * 
     * @return The relevance scores for different audience sizes and the recall score of the generated audience.
     */
    public final AudienceQualityMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * The AWS account that started this audience generation job.
     * </p>
     * 
     * @return The AWS account that started this audience generation job.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that are associated to this audience generation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that are associated to this audience generation job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The unique identifier of the protected query for this audience generation job.
     * </p>
     * 
     * @return The unique identifier of the protected query for this audience generation job.
     */
    public final String protectedQueryIdentifier() {
        return protectedQueryIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(audienceGenerationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(seedAudience());
        hashCode = 31 * hashCode + Objects.hashCode(includeSeedInOutput());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protectedQueryIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAudienceGenerationJobResponse)) {
            return false;
        }
        GetAudienceGenerationJobResponse other = (GetAudienceGenerationJobResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(audienceGenerationJobArn(), other.audienceGenerationJobArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(seedAudience(), other.seedAudience())
                && Objects.equals(includeSeedInOutput(), other.includeSeedInOutput())
                && Objects.equals(collaborationId(), other.collaborationId()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(startedBy(), other.startedBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(protectedQueryIdentifier(), other.protectedQueryIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAudienceGenerationJobResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("AudienceGenerationJobArn", audienceGenerationJobArn()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("StatusDetails", statusDetails())
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn()).add("SeedAudience", seedAudience())
                .add("IncludeSeedInOutput", includeSeedInOutput()).add("CollaborationId", collaborationId())
                .add("Metrics", metrics()).add("StartedBy", startedBy()).add("Tags", hasTags() ? tags() : null)
                .add("ProtectedQueryIdentifier", protectedQueryIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "audienceGenerationJobArn":
            return Optional.ofNullable(clazz.cast(audienceGenerationJobArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "seedAudience":
            return Optional.ofNullable(clazz.cast(seedAudience()));
        case "includeSeedInOutput":
            return Optional.ofNullable(clazz.cast(includeSeedInOutput()));
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "protectedQueryIdentifier":
            return Optional.ofNullable(clazz.cast(protectedQueryIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("audienceGenerationJobArn", AUDIENCE_GENERATION_JOB_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
        map.put("seedAudience", SEED_AUDIENCE_FIELD);
        map.put("includeSeedInOutput", INCLUDE_SEED_IN_OUTPUT_FIELD);
        map.put("collaborationId", COLLABORATION_ID_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("startedBy", STARTED_BY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("protectedQueryIdentifier", PROTECTED_QUERY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAudienceGenerationJobResponse, T> g) {
        return obj -> g.apply((GetAudienceGenerationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAudienceGenerationJobResponse> {
        /**
         * <p>
         * The time at which the audience generation job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the audience generation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the audience generation job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the audience generation job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the audience generation job.
         * </p>
         * 
         * @param audienceGenerationJobArn
         *        The Amazon Resource Name (ARN) of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceGenerationJobArn(String audienceGenerationJobArn);

        /**
         * <p>
         * The name of the audience generation job.
         * </p>
         * 
         * @param name
         *        The name of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the audience generation job.
         * </p>
         * 
         * @param description
         *        The description of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the audience generation job.
         * </p>
         * 
         * @param status
         *        The status of the audience generation job.
         * @see AudienceGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceGenerationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the audience generation job.
         * </p>
         * 
         * @param status
         *        The status of the audience generation job.
         * @see AudienceGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudienceGenerationJobStatus
         */
        Builder status(AudienceGenerationJobStatus status);

        /**
         * <p>
         * Details about the status of the audience generation job.
         * </p>
         * 
         * @param statusDetails
         *        Details about the status of the audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(StatusDetails statusDetails);

        /**
         * <p>
         * Details about the status of the audience generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusDetails.Builder} avoiding the need
         * to create one manually via {@link StatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #statusDetails(StatusDetails)}.
         * 
         * @param statusDetails
         *        a consumer that will call methods on {@link StatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusDetails(StatusDetails)
         */
        default Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return statusDetails(StatusDetails.builder().applyMutation(statusDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model used for this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The seed audience that was used for this audience generation job. This field will be null if the account
         * calling the API is the account that started this audience generation job.
         * </p>
         * 
         * @param seedAudience
         *        The seed audience that was used for this audience generation job. This field will be null if the
         *        account calling the API is the account that started this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seedAudience(AudienceGenerationJobDataSource seedAudience);

        /**
         * <p>
         * The seed audience that was used for this audience generation job. This field will be null if the account
         * calling the API is the account that started this audience generation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceGenerationJobDataSource.Builder}
         * avoiding the need to create one manually via {@link AudienceGenerationJobDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceGenerationJobDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #seedAudience(AudienceGenerationJobDataSource)}.
         * 
         * @param seedAudience
         *        a consumer that will call methods on {@link AudienceGenerationJobDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #seedAudience(AudienceGenerationJobDataSource)
         */
        default Builder seedAudience(Consumer<AudienceGenerationJobDataSource.Builder> seedAudience) {
            return seedAudience(AudienceGenerationJobDataSource.builder().applyMutation(seedAudience).build());
        }

        /**
         * <p>
         * Configure whether the seed users are included in the output audience. By default, Clean Rooms ML removes seed
         * users from the output audience. If you specify <code>TRUE</code>, the seed users will appear first in the
         * output. Clean Rooms ML does not explicitly reveal whether a user was in the seed, but the recipient of the
         * audience will know that the first <code>minimumSeedSize</code> count of users are from the seed.
         * </p>
         * 
         * @param includeSeedInOutput
         *        Configure whether the seed users are included in the output audience. By default, Clean Rooms ML
         *        removes seed users from the output audience. If you specify <code>TRUE</code>, the seed users will
         *        appear first in the output. Clean Rooms ML does not explicitly reveal whether a user was in the seed,
         *        but the recipient of the audience will know that the first <code>minimumSeedSize</code> count of users
         *        are from the seed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSeedInOutput(Boolean includeSeedInOutput);

        /**
         * <p>
         * The identifier of the collaboration that this audience generation job is associated with.
         * </p>
         * 
         * @param collaborationId
         *        The identifier of the collaboration that this audience generation job is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The relevance scores for different audience sizes and the recall score of the generated audience.
         * </p>
         * 
         * @param metrics
         *        The relevance scores for different audience sizes and the recall score of the generated audience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(AudienceQualityMetrics metrics);

        /**
         * <p>
         * The relevance scores for different audience sizes and the recall score of the generated audience.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudienceQualityMetrics.Builder} avoiding
         * the need to create one manually via {@link AudienceQualityMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudienceQualityMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #metrics(AudienceQualityMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link AudienceQualityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(AudienceQualityMetrics)
         */
        default Builder metrics(Consumer<AudienceQualityMetrics.Builder> metrics) {
            return metrics(AudienceQualityMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * The AWS account that started this audience generation job.
         * </p>
         * 
         * @param startedBy
         *        The AWS account that started this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The tags that are associated to this audience generation job.
         * </p>
         * 
         * @param tags
         *        The tags that are associated to this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The unique identifier of the protected query for this audience generation job.
         * </p>
         * 
         * @param protectedQueryIdentifier
         *        The unique identifier of the protected query for this audience generation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedQueryIdentifier(String protectedQueryIdentifier);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String audienceGenerationJobArn;

        private String name;

        private String description;

        private String status;

        private StatusDetails statusDetails;

        private String configuredAudienceModelArn;

        private AudienceGenerationJobDataSource seedAudience;

        private Boolean includeSeedInOutput;

        private String collaborationId;

        private AudienceQualityMetrics metrics;

        private String startedBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String protectedQueryIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAudienceGenerationJobResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            audienceGenerationJobArn(model.audienceGenerationJobArn);
            name(model.name);
            description(model.description);
            status(model.status);
            statusDetails(model.statusDetails);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            seedAudience(model.seedAudience);
            includeSeedInOutput(model.includeSeedInOutput);
            collaborationId(model.collaborationId);
            metrics(model.metrics);
            startedBy(model.startedBy);
            tags(model.tags);
            protectedQueryIdentifier(model.protectedQueryIdentifier);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getAudienceGenerationJobArn() {
            return audienceGenerationJobArn;
        }

        public final void setAudienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
        }

        @Override
        public final Builder audienceGenerationJobArn(String audienceGenerationJobArn) {
            this.audienceGenerationJobArn = audienceGenerationJobArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AudienceGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return statusDetails != null ? statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final AudienceGenerationJobDataSource.Builder getSeedAudience() {
            return seedAudience != null ? seedAudience.toBuilder() : null;
        }

        public final void setSeedAudience(AudienceGenerationJobDataSource.BuilderImpl seedAudience) {
            this.seedAudience = seedAudience != null ? seedAudience.build() : null;
        }

        @Override
        public final Builder seedAudience(AudienceGenerationJobDataSource seedAudience) {
            this.seedAudience = seedAudience;
            return this;
        }

        public final Boolean getIncludeSeedInOutput() {
            return includeSeedInOutput;
        }

        public final void setIncludeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
        }

        @Override
        public final Builder includeSeedInOutput(Boolean includeSeedInOutput) {
            this.includeSeedInOutput = includeSeedInOutput;
            return this;
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final AudienceQualityMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(AudienceQualityMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(AudienceQualityMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getProtectedQueryIdentifier() {
            return protectedQueryIdentifier;
        }

        public final void setProtectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
        }

        @Override
        public final Builder protectedQueryIdentifier(String protectedQueryIdentifier) {
            this.protectedQueryIdentifier = protectedQueryIdentifier;
            return this;
        }

        @Override
        public GetAudienceGenerationJobResponse build() {
            return new GetAudienceGenerationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
