/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredAudienceModelPolicyResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetConfiguredAudienceModelPolicyResponse.Builder, GetConfiguredAudienceModelPolicyResponse> {
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelArn")
            .getter(getter(GetConfiguredAudienceModelPolicyResponse::configuredAudienceModelArn))
            .setter(setter(Builder::configuredAudienceModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build())
            .build();

    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredAudienceModelPolicy")
            .getter(getter(GetConfiguredAudienceModelPolicyResponse::configuredAudienceModelPolicy))
            .setter(setter(Builder::configuredAudienceModelPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelPolicy")
                    .build()).build();

    private static final SdkField<String> POLICY_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyHash").getter(getter(GetConfiguredAudienceModelPolicyResponse::policyHash))
            .setter(setter(Builder::policyHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyHash").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD, POLICY_HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configuredAudienceModelArn;

    private final String configuredAudienceModelPolicy;

    private final String policyHash;

    private GetConfiguredAudienceModelPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.configuredAudienceModelPolicy = builder.configuredAudienceModelPolicy;
        this.policyHash = builder.policyHash;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured audience model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured audience model.
     */
    public final String configuredAudienceModelArn() {
        return configuredAudienceModelArn;
    }

    /**
     * <p>
     * The configured audience model policy. This is a JSON IAM resource policy.
     * </p>
     * 
     * @return The configured audience model policy. This is a JSON IAM resource policy.
     */
    public final String configuredAudienceModelPolicy() {
        return configuredAudienceModelPolicy;
    }

    /**
     * <p>
     * A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the
     * policy.
     * </p>
     * 
     * @return A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of
     *         the policy.
     */
    public final String policyHash() {
        return policyHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(policyHash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredAudienceModelPolicyResponse)) {
            return false;
        }
        GetConfiguredAudienceModelPolicyResponse other = (GetConfiguredAudienceModelPolicyResponse) obj;
        return Objects.equals(configuredAudienceModelArn(), other.configuredAudienceModelArn())
                && Objects.equals(configuredAudienceModelPolicy(), other.configuredAudienceModelPolicy())
                && Objects.equals(policyHash(), other.policyHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredAudienceModelPolicyResponse")
                .add("ConfiguredAudienceModelArn", configuredAudienceModelArn())
                .add("ConfiguredAudienceModelPolicy", configuredAudienceModelPolicy()).add("PolicyHash", policyHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelArn":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelArn()));
        case "configuredAudienceModelPolicy":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelPolicy()));
        case "policyHash":
            return Optional.ofNullable(clazz.cast(policyHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
        map.put("configuredAudienceModelPolicy", CONFIGURED_AUDIENCE_MODEL_POLICY_FIELD);
        map.put("policyHash", POLICY_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredAudienceModelPolicyResponse, T> g) {
        return obj -> g.apply((GetConfiguredAudienceModelPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredAudienceModelPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured audience model.
         * </p>
         * 
         * @param configuredAudienceModelArn
         *        The Amazon Resource Name (ARN) of the configured audience model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelArn(String configuredAudienceModelArn);

        /**
         * <p>
         * The configured audience model policy. This is a JSON IAM resource policy.
         * </p>
         * 
         * @param configuredAudienceModelPolicy
         *        The configured audience model policy. This is a JSON IAM resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelPolicy(String configuredAudienceModelPolicy);

        /**
         * <p>
         * A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification of the
         * policy.
         * </p>
         * 
         * @param policyHash
         *        A cryptographic hash of the contents of the policy used to prevent unexpected concurrent modification
         *        of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyHash(String policyHash);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String configuredAudienceModelArn;

        private String configuredAudienceModelPolicy;

        private String policyHash;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredAudienceModelPolicyResponse model) {
            super(model);
            configuredAudienceModelArn(model.configuredAudienceModelArn);
            configuredAudienceModelPolicy(model.configuredAudienceModelPolicy);
            policyHash(model.policyHash);
        }

        public final String getConfiguredAudienceModelArn() {
            return configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelPolicy() {
            return configuredAudienceModelPolicy;
        }

        public final void setConfiguredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
        }

        @Override
        public final Builder configuredAudienceModelPolicy(String configuredAudienceModelPolicy) {
            this.configuredAudienceModelPolicy = configuredAudienceModelPolicy;
            return this;
        }

        public final String getPolicyHash() {
            return policyHash;
        }

        public final void setPolicyHash(String policyHash) {
            this.policyHash = policyHash;
        }

        @Override
        public final Builder policyHash(String policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        @Override
        public GetConfiguredAudienceModelPolicyResponse build() {
            return new GetConfiguredAudienceModelPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
