/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfiguredModelAlgorithmResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<GetConfiguredModelAlgorithmResponse.Builder, GetConfiguredModelAlgorithmResponse> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(GetConfiguredModelAlgorithmResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetConfiguredModelAlgorithmResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmArn")
            .getter(getter(GetConfiguredModelAlgorithmResponse::configuredModelAlgorithmArn))
            .setter(setter(Builder::configuredModelAlgorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmArn")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetConfiguredModelAlgorithmResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ContainerConfig> TRAINING_CONTAINER_CONFIG_FIELD = SdkField
            .<ContainerConfig> builder(MarshallingType.SDK_POJO).memberName("trainingContainerConfig")
            .getter(getter(GetConfiguredModelAlgorithmResponse::trainingContainerConfig))
            .setter(setter(Builder::trainingContainerConfig)).constructor(ContainerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingContainerConfig").build())
            .build();

    private static final SdkField<InferenceContainerConfig> INFERENCE_CONTAINER_CONFIG_FIELD = SdkField
            .<InferenceContainerConfig> builder(MarshallingType.SDK_POJO).memberName("inferenceContainerConfig")
            .getter(getter(GetConfiguredModelAlgorithmResponse::inferenceContainerConfig))
            .setter(setter(Builder::inferenceContainerConfig)).constructor(InferenceContainerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceContainerConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetConfiguredModelAlgorithmResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetConfiguredModelAlgorithmResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetConfiguredModelAlgorithmResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(GetConfiguredModelAlgorithmResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD,
            UPDATE_TIME_FIELD, CONFIGURED_MODEL_ALGORITHM_ARN_FIELD, NAME_FIELD, TRAINING_CONTAINER_CONFIG_FIELD,
            INFERENCE_CONTAINER_CONFIG_FIELD, ROLE_ARN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createTime;

    private final Instant updateTime;

    private final String configuredModelAlgorithmArn;

    private final String name;

    private final ContainerConfig trainingContainerConfig;

    private final InferenceContainerConfig inferenceContainerConfig;

    private final String roleArn;

    private final String description;

    private final Map<String, String> tags;

    private final String kmsKeyArn;

    private GetConfiguredModelAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.configuredModelAlgorithmArn = builder.configuredModelAlgorithmArn;
        this.name = builder.name;
        this.trainingContainerConfig = builder.trainingContainerConfig;
        this.inferenceContainerConfig = builder.inferenceContainerConfig;
        this.roleArn = builder.roleArn;
        this.description = builder.description;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The time at which the configured model algorithm was created.
     * </p>
     * 
     * @return The time at which the configured model algorithm was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the configured model algorithm was updated.
     * </p>
     * 
     * @return The most recent time at which the configured model algorithm was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm.
     */
    public final String configuredModelAlgorithmArn() {
        return configuredModelAlgorithmArn;
    }

    /**
     * <p>
     * The name of the configured model algorithm.
     * </p>
     * 
     * @return The name of the configured model algorithm.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration information of the training container for the configured model algorithm.
     * </p>
     * 
     * @return The configuration information of the training container for the configured model algorithm.
     */
    public final ContainerConfig trainingContainerConfig() {
        return trainingContainerConfig;
    }

    /**
     * <p>
     * Configuration information for the inference container.
     * </p>
     * 
     * @return Configuration information for the inference container.
     */
    public final InferenceContainerConfig inferenceContainerConfig() {
        return inferenceContainerConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role that was used to create the configured model algorithm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role that was used to create the configured model
     *         algorithm.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The description of the configured model algorithm.
     * </p>
     * 
     * @return The description of the configured model algorithm.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * configured ML model and associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the configured ML model and associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(trainingContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceContainerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfiguredModelAlgorithmResponse)) {
            return false;
        }
        GetConfiguredModelAlgorithmResponse other = (GetConfiguredModelAlgorithmResponse) obj;
        return Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime())
                && Objects.equals(configuredModelAlgorithmArn(), other.configuredModelAlgorithmArn())
                && Objects.equals(name(), other.name())
                && Objects.equals(trainingContainerConfig(), other.trainingContainerConfig())
                && Objects.equals(inferenceContainerConfig(), other.inferenceContainerConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfiguredModelAlgorithmResponse").add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).add("ConfiguredModelAlgorithmArn", configuredModelAlgorithmArn())
                .add("Name", name()).add("TrainingContainerConfig", trainingContainerConfig())
                .add("InferenceContainerConfig", inferenceContainerConfig()).add("RoleArn", roleArn())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "configuredModelAlgorithmArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "trainingContainerConfig":
            return Optional.ofNullable(clazz.cast(trainingContainerConfig()));
        case "inferenceContainerConfig":
            return Optional.ofNullable(clazz.cast(inferenceContainerConfig()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("configuredModelAlgorithmArn", CONFIGURED_MODEL_ALGORITHM_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("trainingContainerConfig", TRAINING_CONTAINER_CONFIG_FIELD);
        map.put("inferenceContainerConfig", INFERENCE_CONTAINER_CONFIG_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfiguredModelAlgorithmResponse, T> g) {
        return obj -> g.apply((GetConfiguredModelAlgorithmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfiguredModelAlgorithmResponse> {
        /**
         * <p>
         * The time at which the configured model algorithm was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the configured model algorithm was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the configured model algorithm was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the configured model algorithm was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm.
         * </p>
         * 
         * @param configuredModelAlgorithmArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn);

        /**
         * <p>
         * The name of the configured model algorithm.
         * </p>
         * 
         * @param name
         *        The name of the configured model algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration information of the training container for the configured model algorithm.
         * </p>
         * 
         * @param trainingContainerConfig
         *        The configuration information of the training container for the configured model algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingContainerConfig(ContainerConfig trainingContainerConfig);

        /**
         * <p>
         * The configuration information of the training container for the configured model algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerConfig.Builder} avoiding the
         * need to create one manually via {@link ContainerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingContainerConfig(ContainerConfig)}.
         * 
         * @param trainingContainerConfig
         *        a consumer that will call methods on {@link ContainerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingContainerConfig(ContainerConfig)
         */
        default Builder trainingContainerConfig(Consumer<ContainerConfig.Builder> trainingContainerConfig) {
            return trainingContainerConfig(ContainerConfig.builder().applyMutation(trainingContainerConfig).build());
        }

        /**
         * <p>
         * Configuration information for the inference container.
         * </p>
         * 
         * @param inferenceContainerConfig
         *        Configuration information for the inference container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceContainerConfig(InferenceContainerConfig inferenceContainerConfig);

        /**
         * <p>
         * Configuration information for the inference container.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceContainerConfig.Builder}
         * avoiding the need to create one manually via {@link InferenceContainerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceContainerConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceContainerConfig(InferenceContainerConfig)}.
         * 
         * @param inferenceContainerConfig
         *        a consumer that will call methods on {@link InferenceContainerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceContainerConfig(InferenceContainerConfig)
         */
        default Builder inferenceContainerConfig(Consumer<InferenceContainerConfig.Builder> inferenceContainerConfig) {
            return inferenceContainerConfig(InferenceContainerConfig.builder().applyMutation(inferenceContainerConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role that was used to create the configured model algorithm.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the service role that was used to create the configured model
         *        algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The description of the configured model algorithm.
         * </p>
         * 
         * @param description
         *        The description of the configured model algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The optional metadata that you applied to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you applied to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the configured ML model and associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the configured ML model and associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private Instant createTime;

        private Instant updateTime;

        private String configuredModelAlgorithmArn;

        private String name;

        private ContainerConfig trainingContainerConfig;

        private InferenceContainerConfig inferenceContainerConfig;

        private String roleArn;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfiguredModelAlgorithmResponse model) {
            super(model);
            createTime(model.createTime);
            updateTime(model.updateTime);
            configuredModelAlgorithmArn(model.configuredModelAlgorithmArn);
            name(model.name);
            trainingContainerConfig(model.trainingContainerConfig);
            inferenceContainerConfig(model.inferenceContainerConfig);
            roleArn(model.roleArn);
            description(model.description);
            tags(model.tags);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getConfiguredModelAlgorithmArn() {
            return configuredModelAlgorithmArn;
        }

        public final void setConfiguredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
        }

        @Override
        public final Builder configuredModelAlgorithmArn(String configuredModelAlgorithmArn) {
            this.configuredModelAlgorithmArn = configuredModelAlgorithmArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ContainerConfig.Builder getTrainingContainerConfig() {
            return trainingContainerConfig != null ? trainingContainerConfig.toBuilder() : null;
        }

        public final void setTrainingContainerConfig(ContainerConfig.BuilderImpl trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig != null ? trainingContainerConfig.build() : null;
        }

        @Override
        public final Builder trainingContainerConfig(ContainerConfig trainingContainerConfig) {
            this.trainingContainerConfig = trainingContainerConfig;
            return this;
        }

        public final InferenceContainerConfig.Builder getInferenceContainerConfig() {
            return inferenceContainerConfig != null ? inferenceContainerConfig.toBuilder() : null;
        }

        public final void setInferenceContainerConfig(InferenceContainerConfig.BuilderImpl inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig != null ? inferenceContainerConfig.build() : null;
        }

        @Override
        public final Builder inferenceContainerConfig(InferenceContainerConfig inferenceContainerConfig) {
            this.inferenceContainerConfig = inferenceContainerConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GetConfiguredModelAlgorithmResponse build() {
            return new GetConfiguredModelAlgorithmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
