/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfiguredModelAlgorithmAssociationsResponse extends CleanRoomsMlResponse
        implements
        ToCopyableBuilder<ListConfiguredModelAlgorithmAssociationsResponse.Builder, ListConfiguredModelAlgorithmAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListConfiguredModelAlgorithmAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ConfiguredModelAlgorithmAssociationSummary>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField
            .<List<ConfiguredModelAlgorithmAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("configuredModelAlgorithmAssociations")
            .getter(getter(ListConfiguredModelAlgorithmAssociationsResponse::configuredModelAlgorithmAssociations))
            .setter(setter(Builder::configuredModelAlgorithmAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfiguredModelAlgorithmAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfiguredModelAlgorithmAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations;

    private ListConfiguredModelAlgorithmAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
    }

    /**
     * <p>
     * The token value used to access the next page of results.
     * </p>
     * 
     * @return The token value used to access the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfiguredModelAlgorithmAssociations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations != null
                && !(configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of configured model algorithm associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguredModelAlgorithmAssociations}
     * method.
     * </p>
     * 
     * @return The list of configured model algorithm associations.
     */
    public final List<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations() {
        return configuredModelAlgorithmAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfiguredModelAlgorithmAssociationsResponse)) {
            return false;
        }
        ListConfiguredModelAlgorithmAssociationsResponse other = (ListConfiguredModelAlgorithmAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations()
                && Objects.equals(configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListConfiguredModelAlgorithmAssociationsResponse")
                .add("NextToken", nextToken())
                .add("ConfiguredModelAlgorithmAssociations",
                        hasConfiguredModelAlgorithmAssociations() ? configuredModelAlgorithmAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "configuredModelAlgorithmAssociations":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfiguredModelAlgorithmAssociationsResponse, T> g) {
        return obj -> g.apply((ListConfiguredModelAlgorithmAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfiguredModelAlgorithmAssociationsResponse> {
        /**
         * <p>
         * The token value used to access the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token value used to access the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of configured model algorithm associations.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The list of configured model algorithm associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(
                Collection<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The list of configured model algorithm associations.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociations
         *        The list of configured model algorithm associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociations(
                ConfiguredModelAlgorithmAssociationSummary... configuredModelAlgorithmAssociations);

        /**
         * <p>
         * The list of configured model algorithm associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #configuredModelAlgorithmAssociations(List<ConfiguredModelAlgorithmAssociationSummary>)}.
         * 
         * @param configuredModelAlgorithmAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.ConfiguredModelAlgorithmAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuredModelAlgorithmAssociations(java.util.Collection<ConfiguredModelAlgorithmAssociationSummary>)
         */
        Builder configuredModelAlgorithmAssociations(
                Consumer<ConfiguredModelAlgorithmAssociationSummary.Builder>... configuredModelAlgorithmAssociations);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfiguredModelAlgorithmAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfiguredModelAlgorithmAssociationSummary.Builder> getConfiguredModelAlgorithmAssociations() {
            List<ConfiguredModelAlgorithmAssociationSummary.Builder> result = ConfiguredModelAlgorithmAssociationListCopier
                    .copyToBuilder(this.configuredModelAlgorithmAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguredModelAlgorithmAssociations(
                Collection<ConfiguredModelAlgorithmAssociationSummary.BuilderImpl> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = ConfiguredModelAlgorithmAssociationListCopier
                    .copyFromBuilder(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(
                Collection<ConfiguredModelAlgorithmAssociationSummary> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = ConfiguredModelAlgorithmAssociationListCopier
                    .copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(
                ConfiguredModelAlgorithmAssociationSummary... configuredModelAlgorithmAssociations) {
            configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(
                Consumer<ConfiguredModelAlgorithmAssociationSummary.Builder>... configuredModelAlgorithmAssociations) {
            configuredModelAlgorithmAssociations(Stream.of(configuredModelAlgorithmAssociations)
                    .map(c -> ConfiguredModelAlgorithmAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfiguredModelAlgorithmAssociationsResponse build() {
            return new ListConfiguredModelAlgorithmAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
