/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainedModelVersionsResponse extends CleanRoomsMlResponse implements
        ToCopyableBuilder<ListTrainedModelVersionsResponse.Builder, ListTrainedModelVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTrainedModelVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TrainedModelSummary>> TRAINED_MODELS_FIELD = SdkField
            .<List<TrainedModelSummary>> builder(MarshallingType.LIST)
            .memberName("trainedModels")
            .getter(getter(ListTrainedModelVersionsResponse::trainedModels))
            .setter(setter(Builder::trainedModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainedModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainedModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TRAINED_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<TrainedModelSummary> trainedModels;

    private ListTrainedModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trainedModels = builder.trainedModels;
    }

    /**
     * <p>
     * The pagination token to use in a subsequent <code>ListTrainedModelVersions</code> request to retrieve the next
     * page of results. This value is null when there are no more results to return.
     * </p>
     * 
     * @return The pagination token to use in a subsequent <code>ListTrainedModelVersions</code> request to retrieve the
     *         next page of results. This value is null when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainedModels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainedModels() {
        return trainedModels != null && !(trainedModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of trained model versions that match the specified criteria. Each entry contains summary information about
     * a trained model version, including its version identifier, status, and creation details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainedModels} method.
     * </p>
     * 
     * @return A list of trained model versions that match the specified criteria. Each entry contains summary
     *         information about a trained model version, including its version identifier, status, and creation
     *         details.
     */
    public final List<TrainedModelSummary> trainedModels() {
        return trainedModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainedModels() ? trainedModels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainedModelVersionsResponse)) {
            return false;
        }
        ListTrainedModelVersionsResponse other = (ListTrainedModelVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTrainedModels() == other.hasTrainedModels()
                && Objects.equals(trainedModels(), other.trainedModels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrainedModelVersionsResponse").add("NextToken", nextToken())
                .add("TrainedModels", hasTrainedModels() ? trainedModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "trainedModels":
            return Optional.ofNullable(clazz.cast(trainedModels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trainedModels", TRAINED_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrainedModelVersionsResponse, T> g) {
        return obj -> g.apply((ListTrainedModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrainedModelVersionsResponse> {
        /**
         * <p>
         * The pagination token to use in a subsequent <code>ListTrainedModelVersions</code> request to retrieve the
         * next page of results. This value is null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use in a subsequent <code>ListTrainedModelVersions</code> request to retrieve
         *        the next page of results. This value is null when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of trained model versions that match the specified criteria. Each entry contains summary information
         * about a trained model version, including its version identifier, status, and creation details.
         * </p>
         * 
         * @param trainedModels
         *        A list of trained model versions that match the specified criteria. Each entry contains summary
         *        information about a trained model version, including its version identifier, status, and creation
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModels(Collection<TrainedModelSummary> trainedModels);

        /**
         * <p>
         * A list of trained model versions that match the specified criteria. Each entry contains summary information
         * about a trained model version, including its version identifier, status, and creation details.
         * </p>
         * 
         * @param trainedModels
         *        A list of trained model versions that match the specified criteria. Each entry contains summary
         *        information about a trained model version, including its version identifier, status, and creation
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModels(TrainedModelSummary... trainedModels);

        /**
         * <p>
         * A list of trained model versions that match the specified criteria. Each entry contains summary information
         * about a trained model version, including its version identifier, status, and creation details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #trainedModels(List<TrainedModelSummary>)}.
         * 
         * @param trainedModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.TrainedModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModels(java.util.Collection<TrainedModelSummary>)
         */
        Builder trainedModels(Consumer<TrainedModelSummary.Builder>... trainedModels);
    }

    static final class BuilderImpl extends CleanRoomsMlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TrainedModelSummary> trainedModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainedModelVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            trainedModels(model.trainedModels);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrainedModelSummary.Builder> getTrainedModels() {
            List<TrainedModelSummary.Builder> result = TrainedModelListCopier.copyToBuilder(this.trainedModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainedModels(Collection<TrainedModelSummary.BuilderImpl> trainedModels) {
            this.trainedModels = TrainedModelListCopier.copyFromBuilder(trainedModels);
        }

        @Override
        public final Builder trainedModels(Collection<TrainedModelSummary> trainedModels) {
            this.trainedModels = TrainedModelListCopier.copy(trainedModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModels(TrainedModelSummary... trainedModels) {
            trainedModels(Arrays.asList(trainedModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainedModels(Consumer<TrainedModelSummary.Builder>... trainedModels) {
            trainedModels(Stream.of(trainedModels).map(c -> TrainedModelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrainedModelVersionsResponse build() {
            return new ListTrainedModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
