/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the information necessary for a user to access the logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsConfigurationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<LogsConfigurationPolicy.Builder, LogsConfigurationPolicy> {
    private static final SdkField<List<String>> ALLOWED_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedAccountIds")
            .getter(getter(LogsConfigurationPolicy::allowedAccountIds))
            .setter(setter(Builder::allowedAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterPattern").getter(getter(LogsConfigurationPolicy::filterPattern))
            .setter(setter(Builder::filterPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()).build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logType").getter(getter(LogsConfigurationPolicy::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logType").build()).build();

    private static final SdkField<LogRedactionConfiguration> LOG_REDACTION_CONFIGURATION_FIELD = SdkField
            .<LogRedactionConfiguration> builder(MarshallingType.SDK_POJO).memberName("logRedactionConfiguration")
            .getter(getter(LogsConfigurationPolicy::logRedactionConfiguration))
            .setter(setter(Builder::logRedactionConfiguration)).constructor(LogRedactionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logRedactionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ACCOUNT_IDS_FIELD,
            FILTER_PATTERN_FIELD, LOG_TYPE_FIELD, LOG_REDACTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> allowedAccountIds;

    private final String filterPattern;

    private final String logType;

    private final LogRedactionConfiguration logRedactionConfiguration;

    private LogsConfigurationPolicy(BuilderImpl builder) {
        this.allowedAccountIds = builder.allowedAccountIds;
        this.filterPattern = builder.filterPattern;
        this.logType = builder.logType;
        this.logRedactionConfiguration = builder.logRedactionConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedAccountIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedAccountIds() {
        return allowedAccountIds != null && !(allowedAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of account IDs that are allowed to access the logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedAccountIds} method.
     * </p>
     * 
     * @return A list of account IDs that are allowed to access the logs.
     */
    public final List<String> allowedAccountIds() {
        return allowedAccountIds;
    }

    /**
     * <p>
     * A regular expression pattern that is used to parse the logs and return information that matches the pattern.
     * </p>
     * 
     * @return A regular expression pattern that is used to parse the logs and return information that matches the
     *         pattern.
     */
    public final String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * Specifies the type of log this policy applies to. The currently supported policies are ALL or ERROR_SUMMARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of log this policy applies to. The currently supported policies are ALL or
     *         ERROR_SUMMARY.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Specifies the type of log this policy applies to. The currently supported policies are ALL or ERROR_SUMMARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of log this policy applies to. The currently supported policies are ALL or
     *         ERROR_SUMMARY.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Specifies the log redaction configuration for this policy.
     * </p>
     * 
     * @return Specifies the log redaction configuration for this policy.
     */
    public final LogRedactionConfiguration logRedactionConfiguration() {
        return logRedactionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedAccountIds() ? allowedAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logRedactionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsConfigurationPolicy)) {
            return false;
        }
        LogsConfigurationPolicy other = (LogsConfigurationPolicy) obj;
        return hasAllowedAccountIds() == other.hasAllowedAccountIds()
                && Objects.equals(allowedAccountIds(), other.allowedAccountIds())
                && Objects.equals(filterPattern(), other.filterPattern())
                && Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(logRedactionConfiguration(), other.logRedactionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsConfigurationPolicy")
                .add("AllowedAccountIds", hasAllowedAccountIds() ? allowedAccountIds() : null)
                .add("FilterPattern", filterPattern()).add("LogType", logTypeAsString())
                .add("LogRedactionConfiguration", logRedactionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowedAccountIds":
            return Optional.ofNullable(clazz.cast(allowedAccountIds()));
        case "filterPattern":
            return Optional.ofNullable(clazz.cast(filterPattern()));
        case "logType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "logRedactionConfiguration":
            return Optional.ofNullable(clazz.cast(logRedactionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowedAccountIds", ALLOWED_ACCOUNT_IDS_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("logType", LOG_TYPE_FIELD);
        map.put("logRedactionConfiguration", LOG_REDACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsConfigurationPolicy, T> g) {
        return obj -> g.apply((LogsConfigurationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsConfigurationPolicy> {
        /**
         * <p>
         * A list of account IDs that are allowed to access the logs.
         * </p>
         * 
         * @param allowedAccountIds
         *        A list of account IDs that are allowed to access the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccountIds(Collection<String> allowedAccountIds);

        /**
         * <p>
         * A list of account IDs that are allowed to access the logs.
         * </p>
         * 
         * @param allowedAccountIds
         *        A list of account IDs that are allowed to access the logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedAccountIds(String... allowedAccountIds);

        /**
         * <p>
         * A regular expression pattern that is used to parse the logs and return information that matches the pattern.
         * </p>
         * 
         * @param filterPattern
         *        A regular expression pattern that is used to parse the logs and return information that matches the
         *        pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * Specifies the type of log this policy applies to. The currently supported policies are ALL or ERROR_SUMMARY.
         * </p>
         * 
         * @param logType
         *        Specifies the type of log this policy applies to. The currently supported policies are ALL or
         *        ERROR_SUMMARY.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Specifies the type of log this policy applies to. The currently supported policies are ALL or ERROR_SUMMARY.
         * </p>
         * 
         * @param logType
         *        Specifies the type of log this policy applies to. The currently supported policies are ALL or
         *        ERROR_SUMMARY.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Specifies the log redaction configuration for this policy.
         * </p>
         * 
         * @param logRedactionConfiguration
         *        Specifies the log redaction configuration for this policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logRedactionConfiguration(LogRedactionConfiguration logRedactionConfiguration);

        /**
         * <p>
         * Specifies the log redaction configuration for this policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogRedactionConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogRedactionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogRedactionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logRedactionConfiguration(LogRedactionConfiguration)}.
         * 
         * @param logRedactionConfiguration
         *        a consumer that will call methods on {@link LogRedactionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logRedactionConfiguration(LogRedactionConfiguration)
         */
        default Builder logRedactionConfiguration(Consumer<LogRedactionConfiguration.Builder> logRedactionConfiguration) {
            return logRedactionConfiguration(LogRedactionConfiguration.builder().applyMutation(logRedactionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowedAccountIds = DefaultSdkAutoConstructList.getInstance();

        private String filterPattern;

        private String logType;

        private LogRedactionConfiguration logRedactionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsConfigurationPolicy model) {
            allowedAccountIds(model.allowedAccountIds);
            filterPattern(model.filterPattern);
            logType(model.logType);
            logRedactionConfiguration(model.logRedactionConfiguration);
        }

        public final Collection<String> getAllowedAccountIds() {
            if (allowedAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedAccountIds;
        }

        public final void setAllowedAccountIds(Collection<String> allowedAccountIds) {
            this.allowedAccountIds = AccountIdListCopier.copy(allowedAccountIds);
        }

        @Override
        public final Builder allowedAccountIds(Collection<String> allowedAccountIds) {
            this.allowedAccountIds = AccountIdListCopier.copy(allowedAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAccountIds(String... allowedAccountIds) {
            allowedAccountIds(Arrays.asList(allowedAccountIds));
            return this;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final LogRedactionConfiguration.Builder getLogRedactionConfiguration() {
            return logRedactionConfiguration != null ? logRedactionConfiguration.toBuilder() : null;
        }

        public final void setLogRedactionConfiguration(LogRedactionConfiguration.BuilderImpl logRedactionConfiguration) {
            this.logRedactionConfiguration = logRedactionConfiguration != null ? logRedactionConfiguration.build() : null;
        }

        @Override
        public final Builder logRedactionConfiguration(LogRedactionConfiguration logRedactionConfiguration) {
            this.logRedactionConfiguration = logRedactionConfiguration;
            return this;
        }

        @Override
        public LogsConfigurationPolicy build() {
            return new LogsConfigurationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
