/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration policy for the trained models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelsConfigurationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelsConfigurationPolicy.Builder, TrainedModelsConfigurationPolicy> {
    private static final SdkField<List<LogsConfigurationPolicy>> CONTAINER_LOGS_FIELD = SdkField
            .<List<LogsConfigurationPolicy>> builder(MarshallingType.LIST)
            .memberName("containerLogs")
            .getter(getter(TrainedModelsConfigurationPolicy::containerLogs))
            .setter(setter(Builder::containerLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerLogs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogsConfigurationPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogsConfigurationPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MetricsConfigurationPolicy> CONTAINER_METRICS_FIELD = SdkField
            .<MetricsConfigurationPolicy> builder(MarshallingType.SDK_POJO).memberName("containerMetrics")
            .getter(getter(TrainedModelsConfigurationPolicy::containerMetrics)).setter(setter(Builder::containerMetrics))
            .constructor(MetricsConfigurationPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerMetrics").build()).build();

    private static final SdkField<TrainedModelArtifactMaxSize> MAX_ARTIFACT_SIZE_FIELD = SdkField
            .<TrainedModelArtifactMaxSize> builder(MarshallingType.SDK_POJO).memberName("maxArtifactSize")
            .getter(getter(TrainedModelsConfigurationPolicy::maxArtifactSize)).setter(setter(Builder::maxArtifactSize))
            .constructor(TrainedModelArtifactMaxSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxArtifactSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_LOGS_FIELD,
            CONTAINER_METRICS_FIELD, MAX_ARTIFACT_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<LogsConfigurationPolicy> containerLogs;

    private final MetricsConfigurationPolicy containerMetrics;

    private final TrainedModelArtifactMaxSize maxArtifactSize;

    private TrainedModelsConfigurationPolicy(BuilderImpl builder) {
        this.containerLogs = builder.containerLogs;
        this.containerMetrics = builder.containerMetrics;
        this.maxArtifactSize = builder.maxArtifactSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerLogs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerLogs() {
        return containerLogs != null && !(containerLogs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container for the logs of the trained model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerLogs} method.
     * </p>
     * 
     * @return The container for the logs of the trained model.
     */
    public final List<LogsConfigurationPolicy> containerLogs() {
        return containerLogs;
    }

    /**
     * <p>
     * The container for the metrics of the trained model.
     * </p>
     * 
     * @return The container for the metrics of the trained model.
     */
    public final MetricsConfigurationPolicy containerMetrics() {
        return containerMetrics;
    }

    /**
     * <p>
     * The maximum size limit for trained model artifacts as defined in the configuration policy. This setting helps
     * enforce consistent size limits across trained models in the collaboration.
     * </p>
     * 
     * @return The maximum size limit for trained model artifacts as defined in the configuration policy. This setting
     *         helps enforce consistent size limits across trained models in the collaboration.
     */
    public final TrainedModelArtifactMaxSize maxArtifactSize() {
        return maxArtifactSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerLogs() ? containerLogs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containerMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(maxArtifactSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelsConfigurationPolicy)) {
            return false;
        }
        TrainedModelsConfigurationPolicy other = (TrainedModelsConfigurationPolicy) obj;
        return hasContainerLogs() == other.hasContainerLogs() && Objects.equals(containerLogs(), other.containerLogs())
                && Objects.equals(containerMetrics(), other.containerMetrics())
                && Objects.equals(maxArtifactSize(), other.maxArtifactSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelsConfigurationPolicy")
                .add("ContainerLogs", hasContainerLogs() ? containerLogs() : null).add("ContainerMetrics", containerMetrics())
                .add("MaxArtifactSize", maxArtifactSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerLogs":
            return Optional.ofNullable(clazz.cast(containerLogs()));
        case "containerMetrics":
            return Optional.ofNullable(clazz.cast(containerMetrics()));
        case "maxArtifactSize":
            return Optional.ofNullable(clazz.cast(maxArtifactSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("containerLogs", CONTAINER_LOGS_FIELD);
        map.put("containerMetrics", CONTAINER_METRICS_FIELD);
        map.put("maxArtifactSize", MAX_ARTIFACT_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelsConfigurationPolicy, T> g) {
        return obj -> g.apply((TrainedModelsConfigurationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelsConfigurationPolicy> {
        /**
         * <p>
         * The container for the logs of the trained model.
         * </p>
         * 
         * @param containerLogs
         *        The container for the logs of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerLogs(Collection<LogsConfigurationPolicy> containerLogs);

        /**
         * <p>
         * The container for the logs of the trained model.
         * </p>
         * 
         * @param containerLogs
         *        The container for the logs of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerLogs(LogsConfigurationPolicy... containerLogs);

        /**
         * <p>
         * The container for the logs of the trained model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #containerLogs(List<LogsConfigurationPolicy>)}.
         * 
         * @param containerLogs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.LogsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerLogs(java.util.Collection<LogsConfigurationPolicy>)
         */
        Builder containerLogs(Consumer<LogsConfigurationPolicy.Builder>... containerLogs);

        /**
         * <p>
         * The container for the metrics of the trained model.
         * </p>
         * 
         * @param containerMetrics
         *        The container for the metrics of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerMetrics(MetricsConfigurationPolicy containerMetrics);

        /**
         * <p>
         * The container for the metrics of the trained model.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsConfigurationPolicy.Builder}
         * avoiding the need to create one manually via {@link MetricsConfigurationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricsConfigurationPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #containerMetrics(MetricsConfigurationPolicy)}.
         * 
         * @param containerMetrics
         *        a consumer that will call methods on {@link MetricsConfigurationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerMetrics(MetricsConfigurationPolicy)
         */
        default Builder containerMetrics(Consumer<MetricsConfigurationPolicy.Builder> containerMetrics) {
            return containerMetrics(MetricsConfigurationPolicy.builder().applyMutation(containerMetrics).build());
        }

        /**
         * <p>
         * The maximum size limit for trained model artifacts as defined in the configuration policy. This setting helps
         * enforce consistent size limits across trained models in the collaboration.
         * </p>
         * 
         * @param maxArtifactSize
         *        The maximum size limit for trained model artifacts as defined in the configuration policy. This
         *        setting helps enforce consistent size limits across trained models in the collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxArtifactSize(TrainedModelArtifactMaxSize maxArtifactSize);

        /**
         * <p>
         * The maximum size limit for trained model artifacts as defined in the configuration policy. This setting helps
         * enforce consistent size limits across trained models in the collaboration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainedModelArtifactMaxSize.Builder}
         * avoiding the need to create one manually via {@link TrainedModelArtifactMaxSize#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainedModelArtifactMaxSize.Builder#build()} is called
         * immediately and its result is passed to {@link #maxArtifactSize(TrainedModelArtifactMaxSize)}.
         * 
         * @param maxArtifactSize
         *        a consumer that will call methods on {@link TrainedModelArtifactMaxSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxArtifactSize(TrainedModelArtifactMaxSize)
         */
        default Builder maxArtifactSize(Consumer<TrainedModelArtifactMaxSize.Builder> maxArtifactSize) {
            return maxArtifactSize(TrainedModelArtifactMaxSize.builder().applyMutation(maxArtifactSize).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<LogsConfigurationPolicy> containerLogs = DefaultSdkAutoConstructList.getInstance();

        private MetricsConfigurationPolicy containerMetrics;

        private TrainedModelArtifactMaxSize maxArtifactSize;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelsConfigurationPolicy model) {
            containerLogs(model.containerLogs);
            containerMetrics(model.containerMetrics);
            maxArtifactSize(model.maxArtifactSize);
        }

        public final List<LogsConfigurationPolicy.Builder> getContainerLogs() {
            List<LogsConfigurationPolicy.Builder> result = LogsConfigurationPolicyListCopier.copyToBuilder(this.containerLogs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerLogs(Collection<LogsConfigurationPolicy.BuilderImpl> containerLogs) {
            this.containerLogs = LogsConfigurationPolicyListCopier.copyFromBuilder(containerLogs);
        }

        @Override
        public final Builder containerLogs(Collection<LogsConfigurationPolicy> containerLogs) {
            this.containerLogs = LogsConfigurationPolicyListCopier.copy(containerLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerLogs(LogsConfigurationPolicy... containerLogs) {
            containerLogs(Arrays.asList(containerLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerLogs(Consumer<LogsConfigurationPolicy.Builder>... containerLogs) {
            containerLogs(Stream.of(containerLogs).map(c -> LogsConfigurationPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MetricsConfigurationPolicy.Builder getContainerMetrics() {
            return containerMetrics != null ? containerMetrics.toBuilder() : null;
        }

        public final void setContainerMetrics(MetricsConfigurationPolicy.BuilderImpl containerMetrics) {
            this.containerMetrics = containerMetrics != null ? containerMetrics.build() : null;
        }

        @Override
        public final Builder containerMetrics(MetricsConfigurationPolicy containerMetrics) {
            this.containerMetrics = containerMetrics;
            return this;
        }

        public final TrainedModelArtifactMaxSize.Builder getMaxArtifactSize() {
            return maxArtifactSize != null ? maxArtifactSize.toBuilder() : null;
        }

        public final void setMaxArtifactSize(TrainedModelArtifactMaxSize.BuilderImpl maxArtifactSize) {
            this.maxArtifactSize = maxArtifactSize != null ? maxArtifactSize.build() : null;
        }

        @Override
        public final Builder maxArtifactSize(TrainedModelArtifactMaxSize maxArtifactSize) {
            this.maxArtifactSize = maxArtifactSize;
            return this;
        }

        @Override
        public TrainedModelsConfigurationPolicy build() {
            return new TrainedModelsConfigurationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
