/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetCollaborationMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier;
import software.amazon.awssdk.services.cleanroomsml.model.MLInputChannelStatus;
import software.amazon.awssdk.services.cleanroomsml.model.StatusDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationMlInputChannelResponse
extends CleanRoomsMlResponse
implements ToCopyableBuilder<Builder, GetCollaborationMlInputChannelResponse> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::membershipIdentifier)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::collaborationIdentifier)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> ML_INPUT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mlInputChannelArn").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::mlInputChannelArn)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::mlInputChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlInputChannelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::name)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configuredModelAlgorithmAssociations").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::configuredModelAlgorithmAssociations)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::configuredModelAlgorithmAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredModelAlgorithmAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::statusAsString)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusDetails> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusDetails").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::statusDetails)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::statusDetails)).constructor(StatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build()}).build();
    private static final SdkField<Integer> RETENTION_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("retentionInDays").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::retentionInDays)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::retentionInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionInDays").build()}).build();
    private static final SdkField<Long> NUMBER_OF_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfRecords").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::numberOfRecords)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::numberOfRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRecords").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::description)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::createTime)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::updateTime)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creatorAccountId").getter(GetCollaborationMlInputChannelResponse.getter(GetCollaborationMlInputChannelResponse::creatorAccountId)).setter(GetCollaborationMlInputChannelResponse.setter(Builder::creatorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, ML_INPUT_CHANNEL_ARN_FIELD, NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, RETENTION_IN_DAYS_FIELD, NUMBER_OF_RECORDS_FIELD, DESCRIPTION_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, CREATOR_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCollaborationMlInputChannelResponse.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final String collaborationIdentifier;
    private final String mlInputChannelArn;
    private final String name;
    private final List<String> configuredModelAlgorithmAssociations;
    private final String status;
    private final StatusDetails statusDetails;
    private final Integer retentionInDays;
    private final Long numberOfRecords;
    private final String description;
    private final Instant createTime;
    private final Instant updateTime;
    private final String creatorAccountId;

    private GetCollaborationMlInputChannelResponse(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.mlInputChannelArn = builder.mlInputChannelArn;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociations = builder.configuredModelAlgorithmAssociations;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.retentionInDays = builder.retentionInDays;
        this.numberOfRecords = builder.numberOfRecords;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.creatorAccountId = builder.creatorAccountId;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String mlInputChannelArn() {
        return this.mlInputChannelArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations != null && !(this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList);
    }

    public final List<String> configuredModelAlgorithmAssociations() {
        return this.configuredModelAlgorithmAssociations;
    }

    public final MLInputChannelStatus status() {
        return MLInputChannelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StatusDetails statusDetails() {
        return this.statusDetails;
    }

    public final Integer retentionInDays() {
        return this.retentionInDays;
    }

    public final Long numberOfRecords() {
        return this.numberOfRecords;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String creatorAccountId() {
        return this.creatorAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlInputChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationMlInputChannelResponse)) {
            return false;
        }
        GetCollaborationMlInputChannelResponse other = (GetCollaborationMlInputChannelResponse)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.mlInputChannelArn(), other.mlInputChannelArn()) && Objects.equals(this.name(), other.name()) && this.hasConfiguredModelAlgorithmAssociations() == other.hasConfiguredModelAlgorithmAssociations() && Objects.equals(this.configuredModelAlgorithmAssociations(), other.configuredModelAlgorithmAssociations()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.retentionInDays(), other.retentionInDays()) && Objects.equals(this.numberOfRecords(), other.numberOfRecords()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.creatorAccountId(), other.creatorAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationMlInputChannelResponse").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("MlInputChannelArn", (Object)this.mlInputChannelArn()).add("Name", (Object)this.name()).add("ConfiguredModelAlgorithmAssociations", this.hasConfiguredModelAlgorithmAssociations() ? this.configuredModelAlgorithmAssociations() : null).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("RetentionInDays", (Object)this.retentionInDays()).add("NumberOfRecords", (Object)this.numberOfRecords()).add("Description", (Object)this.description()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("CreatorAccountId", (Object)this.creatorAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "mlInputChannelArn": {
                return Optional.ofNullable(clazz.cast(this.mlInputChannelArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuredModelAlgorithmAssociations": {
                return Optional.ofNullable(clazz.cast(this.configuredModelAlgorithmAssociations()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "retentionInDays": {
                return Optional.ofNullable(clazz.cast(this.retentionInDays()));
            }
            case "numberOfRecords": {
                return Optional.ofNullable(clazz.cast(this.numberOfRecords()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "creatorAccountId": {
                return Optional.ofNullable(clazz.cast(this.creatorAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("mlInputChannelArn", ML_INPUT_CHANNEL_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociations", CONFIGURED_MODEL_ALGORITHM_ASSOCIATIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusDetails", STATUS_DETAILS_FIELD);
        map.put("retentionInDays", RETENTION_IN_DAYS_FIELD);
        map.put("numberOfRecords", NUMBER_OF_RECORDS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("creatorAccountId", CREATOR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationMlInputChannelResponse, T> g) {
        return obj -> g.apply((GetCollaborationMlInputChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlResponse.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String collaborationIdentifier;
        private String mlInputChannelArn;
        private String name;
        private List<String> configuredModelAlgorithmAssociations = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private StatusDetails statusDetails;
        private Integer retentionInDays;
        private Long numberOfRecords;
        private String description;
        private Instant createTime;
        private Instant updateTime;
        private String creatorAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationMlInputChannelResponse model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.mlInputChannelArn(model.mlInputChannelArn);
            this.name(model.name);
            this.configuredModelAlgorithmAssociations(model.configuredModelAlgorithmAssociations);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.retentionInDays(model.retentionInDays);
            this.numberOfRecords(model.numberOfRecords);
            this.description(model.description);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.creatorAccountId(model.creatorAccountId);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getMlInputChannelArn() {
            return this.mlInputChannelArn;
        }

        public final void setMlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
        }

        @Override
        public final Builder mlInputChannelArn(String mlInputChannelArn) {
            this.mlInputChannelArn = mlInputChannelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getConfiguredModelAlgorithmAssociations() {
            if (this.configuredModelAlgorithmAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configuredModelAlgorithmAssociations;
        }

        public final void setConfiguredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetCollaborationMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
        }

        @Override
        public final Builder configuredModelAlgorithmAssociations(Collection<String> configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations = GetCollaborationMLInputChannelResponseConfiguredModelAlgorithmAssociationsListCopier.copy(configuredModelAlgorithmAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuredModelAlgorithmAssociations(String ... configuredModelAlgorithmAssociations) {
            this.configuredModelAlgorithmAssociations(Arrays.asList(configuredModelAlgorithmAssociations));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MLInputChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StatusDetails.Builder getStatusDetails() {
            return this.statusDetails != null ? this.statusDetails.toBuilder() : null;
        }

        public final void setStatusDetails(StatusDetails.BuilderImpl statusDetails) {
            this.statusDetails = statusDetails != null ? statusDetails.build() : null;
        }

        @Override
        public final Builder statusDetails(StatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Integer getRetentionInDays() {
            return this.retentionInDays;
        }

        public final void setRetentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public final Builder retentionInDays(Integer retentionInDays) {
            this.retentionInDays = retentionInDays;
            return this;
        }

        public final Long getNumberOfRecords() {
            return this.numberOfRecords;
        }

        public final void setNumberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
        }

        @Override
        public final Builder numberOfRecords(Long numberOfRecords) {
            this.numberOfRecords = numberOfRecords;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getCreatorAccountId() {
            return this.creatorAccountId;
        }

        public final void setCreatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
        }

        @Override
        public final Builder creatorAccountId(String creatorAccountId) {
            this.creatorAccountId = creatorAccountId;
            return this;
        }

        @Override
        public GetCollaborationMlInputChannelResponse build() {
            return new GetCollaborationMlInputChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationMlInputChannelResponse> {
        public Builder membershipIdentifier(String var1);

        public Builder collaborationIdentifier(String var1);

        public Builder mlInputChannelArn(String var1);

        public Builder name(String var1);

        public Builder configuredModelAlgorithmAssociations(Collection<String> var1);

        public Builder configuredModelAlgorithmAssociations(String ... var1);

        public Builder status(String var1);

        public Builder status(MLInputChannelStatus var1);

        public Builder statusDetails(StatusDetails var1);

        default public Builder statusDetails(Consumer<StatusDetails.Builder> statusDetails) {
            return this.statusDetails((StatusDetails)((StatusDetails.Builder)StatusDetails.builder().applyMutation(statusDetails)).build());
        }

        public Builder retentionInDays(Integer var1);

        public Builder numberOfRecords(Long var1);

        public Builder description(String var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder creatorAccountId(String var1);
    }
}

