/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlRequest;
import software.amazon.awssdk.services.cleanroomsml.model.MLOutputConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMlConfigurationRequest
extends CleanRoomsMlRequest
implements ToCopyableBuilder<Builder, PutMlConfigurationRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(PutMlConfigurationRequest.getter(PutMlConfigurationRequest::membershipIdentifier)).setter(PutMlConfigurationRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<MLOutputConfiguration> DEFAULT_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("defaultOutputLocation").getter(PutMlConfigurationRequest.getter(PutMlConfigurationRequest::defaultOutputLocation)).setter(PutMlConfigurationRequest.setter(Builder::defaultOutputLocation)).constructor(MLOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultOutputLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, DEFAULT_OUTPUT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutMlConfigurationRequest.memberNameToFieldInitializer();
    private final String membershipIdentifier;
    private final MLOutputConfiguration defaultOutputLocation;

    private PutMlConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.defaultOutputLocation = builder.defaultOutputLocation;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final MLOutputConfiguration defaultOutputLocation() {
        return this.defaultOutputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOutputLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMlConfigurationRequest)) {
            return false;
        }
        PutMlConfigurationRequest other = (PutMlConfigurationRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.defaultOutputLocation(), other.defaultOutputLocation());
    }

    public final String toString() {
        return ToString.builder((String)"PutMlConfigurationRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("DefaultOutputLocation", (Object)this.defaultOutputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "defaultOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.defaultOutputLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("defaultOutputLocation", DEFAULT_OUTPUT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMlConfigurationRequest, T> g) {
        return obj -> g.apply((PutMlConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsMlRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private MLOutputConfiguration defaultOutputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMlConfigurationRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.defaultOutputLocation(model.defaultOutputLocation);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final MLOutputConfiguration.Builder getDefaultOutputLocation() {
            return this.defaultOutputLocation != null ? this.defaultOutputLocation.toBuilder() : null;
        }

        public final void setDefaultOutputLocation(MLOutputConfiguration.BuilderImpl defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation != null ? defaultOutputLocation.build() : null;
        }

        @Override
        public final Builder defaultOutputLocation(MLOutputConfiguration defaultOutputLocation) {
            this.defaultOutputLocation = defaultOutputLocation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMlConfigurationRequest build() {
            return new PutMlConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsMlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMlConfigurationRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder defaultOutputLocation(MLOutputConfiguration var1);

        default public Builder defaultOutputLocation(Consumer<MLOutputConfiguration.Builder> defaultOutputLocation) {
            return this.defaultOutputLocation((MLOutputConfiguration)((MLOutputConfiguration.Builder)MLOutputConfiguration.builder().applyMutation(defaultOutputLocation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

