/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanroomsml.model.CustomEntityConfig;
import software.amazon.awssdk.services.cleanroomsml.model.EntityType;
import software.amazon.awssdk.services.cleanroomsml.model.EntityTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogRedactionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogRedactionConfiguration> {
    private static final SdkField<List<String>> ENTITIES_TO_REDACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entitiesToRedact").getter(LogRedactionConfiguration.getter(LogRedactionConfiguration::entitiesToRedactAsStrings)).setter(LogRedactionConfiguration.setter(Builder::entitiesToRedactWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitiesToRedact").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomEntityConfig> CUSTOM_ENTITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customEntityConfig").getter(LogRedactionConfiguration.getter(LogRedactionConfiguration::customEntityConfig)).setter(LogRedactionConfiguration.setter(Builder::customEntityConfig)).constructor(CustomEntityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customEntityConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_TO_REDACT_FIELD, CUSTOM_ENTITY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogRedactionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> entitiesToRedact;
    private final CustomEntityConfig customEntityConfig;

    private LogRedactionConfiguration(BuilderImpl builder) {
        this.entitiesToRedact = builder.entitiesToRedact;
        this.customEntityConfig = builder.customEntityConfig;
    }

    public final List<EntityType> entitiesToRedact() {
        return EntityTypeListCopier.copyStringToEnum(this.entitiesToRedact);
    }

    public final boolean hasEntitiesToRedact() {
        return this.entitiesToRedact != null && !(this.entitiesToRedact instanceof SdkAutoConstructList);
    }

    public final List<String> entitiesToRedactAsStrings() {
        return this.entitiesToRedact;
    }

    public final CustomEntityConfig customEntityConfig() {
        return this.customEntityConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitiesToRedact() ? this.entitiesToRedactAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customEntityConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogRedactionConfiguration)) {
            return false;
        }
        LogRedactionConfiguration other = (LogRedactionConfiguration)obj;
        return this.hasEntitiesToRedact() == other.hasEntitiesToRedact() && Objects.equals(this.entitiesToRedactAsStrings(), other.entitiesToRedactAsStrings()) && Objects.equals(this.customEntityConfig(), other.customEntityConfig());
    }

    public final String toString() {
        return ToString.builder((String)"LogRedactionConfiguration").add("EntitiesToRedact", this.hasEntitiesToRedact() ? this.entitiesToRedactAsStrings() : null).add("CustomEntityConfig", (Object)this.customEntityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entitiesToRedact": {
                return Optional.ofNullable(clazz.cast(this.entitiesToRedactAsStrings()));
            }
            case "customEntityConfig": {
                return Optional.ofNullable(clazz.cast(this.customEntityConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entitiesToRedact", ENTITIES_TO_REDACT_FIELD);
        map.put("customEntityConfig", CUSTOM_ENTITY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogRedactionConfiguration, T> g) {
        return obj -> g.apply((LogRedactionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> entitiesToRedact = DefaultSdkAutoConstructList.getInstance();
        private CustomEntityConfig customEntityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LogRedactionConfiguration model) {
            this.entitiesToRedactWithStrings(model.entitiesToRedact);
            this.customEntityConfig(model.customEntityConfig);
        }

        public final Collection<String> getEntitiesToRedact() {
            if (this.entitiesToRedact instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entitiesToRedact;
        }

        public final void setEntitiesToRedact(Collection<String> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copy(entitiesToRedact);
        }

        @Override
        public final Builder entitiesToRedactWithStrings(Collection<String> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copy(entitiesToRedact);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesToRedactWithStrings(String ... entitiesToRedact) {
            this.entitiesToRedactWithStrings(Arrays.asList(entitiesToRedact));
            return this;
        }

        @Override
        public final Builder entitiesToRedact(Collection<EntityType> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copyEnumToString(entitiesToRedact);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesToRedact(EntityType ... entitiesToRedact) {
            this.entitiesToRedact(Arrays.asList(entitiesToRedact));
            return this;
        }

        public final CustomEntityConfig.Builder getCustomEntityConfig() {
            return this.customEntityConfig != null ? this.customEntityConfig.toBuilder() : null;
        }

        public final void setCustomEntityConfig(CustomEntityConfig.BuilderImpl customEntityConfig) {
            this.customEntityConfig = customEntityConfig != null ? customEntityConfig.build() : null;
        }

        @Override
        public final Builder customEntityConfig(CustomEntityConfig customEntityConfig) {
            this.customEntityConfig = customEntityConfig;
            return this;
        }

        public LogRedactionConfiguration build() {
            return new LogRedactionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogRedactionConfiguration> {
        public Builder entitiesToRedactWithStrings(Collection<String> var1);

        public Builder entitiesToRedactWithStrings(String ... var1);

        public Builder entitiesToRedact(Collection<EntityType> var1);

        public Builder entitiesToRedact(EntityType ... var1);

        public Builder customEntityConfig(CustomEntityConfig var1);

        default public Builder customEntityConfig(Consumer<CustomEntityConfig.Builder> customEntityConfig) {
            return this.customEntityConfig((CustomEntityConfig)((CustomEntityConfig.Builder)CustomEntityConfig.builder().applyMutation(customEntityConfig)).build());
        }
    }
}

