/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainedModelStatus {
    CREATE_PENDING("CREATE_PENDING"),
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    CREATE_FAILED("CREATE_FAILED"),
    ACTIVE("ACTIVE"),
    DELETE_PENDING("DELETE_PENDING"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_FAILED("DELETE_FAILED"),
    INACTIVE("INACTIVE"),
    CANCEL_PENDING("CANCEL_PENDING"),
    CANCEL_IN_PROGRESS("CANCEL_IN_PROGRESS"),
    CANCEL_FAILED("CANCEL_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainedModelStatus> VALUE_MAP;
    private final String value;

    private TrainedModelStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainedModelStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainedModelStatus> knownValues() {
        EnumSet<TrainedModelStatus> knownValues = EnumSet.allOf(TrainedModelStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainedModelStatus.class, TrainedModelStatus::toString);
    }
}

