/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainedModelRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<CreateTrainedModelRequest.Builder, CreateTrainedModelRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CreateTrainedModelRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateTrainedModelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(CreateTrainedModelRequest::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<Map<String, String>> HYPERPARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperparameters")
            .getter(getter(CreateTrainedModelRequest::hyperparameters))
            .setter(setter(Builder::hyperparameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperparameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environment")
            .getter(getter(CreateTrainedModelRequest::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("resourceConfig")
            .getter(getter(CreateTrainedModelRequest::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("stoppingCondition")
            .getter(getter(CreateTrainedModelRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()).build();

    private static final SdkField<List<IncrementalTrainingDataChannel>> INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD = SdkField
            .<List<IncrementalTrainingDataChannel>> builder(MarshallingType.LIST)
            .memberName("incrementalTrainingDataChannels")
            .getter(getter(CreateTrainedModelRequest::incrementalTrainingDataChannels))
            .setter(setter(Builder::incrementalTrainingDataChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incrementalTrainingDataChannels")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncrementalTrainingDataChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncrementalTrainingDataChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ModelTrainingDataChannel>> DATA_CHANNELS_FIELD = SdkField
            .<List<ModelTrainingDataChannel>> builder(MarshallingType.LIST)
            .memberName("dataChannels")
            .getter(getter(CreateTrainedModelRequest::dataChannels))
            .setter(setter(Builder::dataChannels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataChannels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelTrainingDataChannel> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelTrainingDataChannel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingInputMode").getter(getter(CreateTrainedModelRequest::trainingInputModeAsString))
            .setter(setter(Builder::trainingInputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingInputMode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateTrainedModelRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(CreateTrainedModelRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateTrainedModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD,
            NAME_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, HYPERPARAMETERS_FIELD, ENVIRONMENT_FIELD,
            RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD, INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD, DATA_CHANNELS_FIELD,
            TRAINING_INPUT_MODE_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String membershipIdentifier;

    private final String name;

    private final String configuredModelAlgorithmAssociationArn;

    private final Map<String, String> hyperparameters;

    private final Map<String, String> environment;

    private final ResourceConfig resourceConfig;

    private final StoppingCondition stoppingCondition;

    private final List<IncrementalTrainingDataChannel> incrementalTrainingDataChannels;

    private final List<ModelTrainingDataChannel> dataChannels;

    private final String trainingInputMode;

    private final String description;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private CreateTrainedModelRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.hyperparameters = builder.hyperparameters;
        this.environment = builder.environment;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.incrementalTrainingDataChannels = builder.incrementalTrainingDataChannels;
        this.dataChannels = builder.dataChannels;
        this.trainingInputMode = builder.trainingInputMode;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The membership ID of the member that is creating the trained model.
     * </p>
     * 
     * @return The membership ID of the member that is creating the trained model.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The name of the trained model.
     * </p>
     * 
     * @return The name of the trained model.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The associated configured model algorithm used to train this model.
     * </p>
     * 
     * @return The associated configured model algorithm used to train this model.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hyperparameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperparameters() {
        return hyperparameters != null && !(hyperparameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start
     * the learning process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperparameters} method.
     * </p>
     * 
     * @return Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you
     *         start the learning process.
     */
    public final Map<String, String> hyperparameters() {
        return hyperparameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Information about the EC2 resources that are used to train this model.
     * </p>
     * 
     * @return Information about the EC2 resources that are used to train this model.
     */
    public final ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * The criteria that is used to stop model training.
     * </p>
     * 
     * @return The criteria that is used to stop model training.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncrementalTrainingDataChannels
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasIncrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels != null && !(incrementalTrainingDataChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the incremental training data channels for the trained model.
     * </p>
     * <p>
     * Incremental training allows you to create a new trained model with updates without retraining from scratch. You
     * can specify up to one incremental training data channel that references a previously trained model and its
     * version.
     * </p>
     * <p>
     * Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
     * <code>dataChannels</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncrementalTrainingDataChannels}
     * method.
     * </p>
     * 
     * @return Specifies the incremental training data channels for the trained model. </p>
     *         <p>
     *         Incremental training allows you to create a new trained model with updates without retraining from
     *         scratch. You can specify up to one incremental training data channel that references a previously trained
     *         model and its version.
     *         </p>
     *         <p>
     *         Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
     *         <code>dataChannels</code>).
     */
    public final List<IncrementalTrainingDataChannel> incrementalTrainingDataChannels() {
        return incrementalTrainingDataChannels;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataChannels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataChannels() {
        return dataChannels != null && !(dataChannels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the data channels that are used as input for the trained model request.
     * </p>
     * <p>
     * Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
     * <code>incrementalTrainingDataChannels</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataChannels} method.
     * </p>
     * 
     * @return Defines the data channels that are used as input for the trained model request.</p>
     *         <p>
     *         Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
     *         <code>incrementalTrainingDataChannels</code>).
     */
    public final List<ModelTrainingDataChannel> dataChannels() {
        return dataChannels;
    }

    /**
     * <p>
     * The input mode for accessing the training data. This parameter determines how the training data is made available
     * to the training algorithm. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>File</code> - The training data is downloaded to the training instance and made available as files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
     * providing faster access for large datasets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can improve
     * performance for certain algorithms.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The input mode for accessing the training data. This parameter determines how the training data is made
     *         available to the training algorithm. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>File</code> - The training data is downloaded to the training instance and made available as files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
     *         providing faster access for large datasets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can
     *         improve performance for certain algorithms.
     *         </p>
     *         </li>
     * @see TrainingInputMode
     */
    public final TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(trainingInputMode);
    }

    /**
     * <p>
     * The input mode for accessing the training data. This parameter determines how the training data is made available
     * to the training algorithm. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>File</code> - The training data is downloaded to the training instance and made available as files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
     * providing faster access for large datasets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can improve
     * performance for certain algorithms.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingInputMode}
     * will return {@link TrainingInputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingInputModeAsString}.
     * </p>
     * 
     * @return The input mode for accessing the training data. This parameter determines how the training data is made
     *         available to the training algorithm. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>File</code> - The training data is downloaded to the training instance and made available as files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
     *         providing faster access for large datasets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can
     *         improve performance for certain algorithms.
     *         </p>
     *         </li>
     * @see TrainingInputMode
     */
    public final String trainingInputModeAsString() {
        return trainingInputMode;
    }

    /**
     * <p>
     * The description of the trained model.
     * </p>
     * 
     * @return The description of the trained model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in the
     * trained ML model and the associated data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
     *         data in the trained ML model and the associated data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag consists
     * of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved for
     * AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value has aws
     * as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count against the
     * limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
     *         consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
     *         reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix.
     *         If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user
     *         tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not count
     *         against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperparameters() ? hyperparameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataChannels() ? dataChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainedModelRequest)) {
            return false;
        }
        CreateTrainedModelRequest other = (CreateTrainedModelRequest) obj;
        return Objects.equals(membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && hasHyperparameters() == other.hasHyperparameters()
                && Objects.equals(hyperparameters(), other.hyperparameters()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && Objects.equals(resourceConfig(), other.resourceConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && hasIncrementalTrainingDataChannels() == other.hasIncrementalTrainingDataChannels()
                && Objects.equals(incrementalTrainingDataChannels(), other.incrementalTrainingDataChannels())
                && hasDataChannels() == other.hasDataChannels() && Objects.equals(dataChannels(), other.dataChannels())
                && Objects.equals(trainingInputModeAsString(), other.trainingInputModeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateTrainedModelRequest")
                .add("MembershipIdentifier", membershipIdentifier())
                .add("Name", name())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("Hyperparameters", hasHyperparameters() ? hyperparameters() : null)
                .add("Environment", hasEnvironment() ? environment() : null)
                .add("ResourceConfig", resourceConfig())
                .add("StoppingCondition", stoppingCondition())
                .add("IncrementalTrainingDataChannels",
                        hasIncrementalTrainingDataChannels() ? incrementalTrainingDataChannels() : null)
                .add("DataChannels", hasDataChannels() ? dataChannels() : null)
                .add("TrainingInputMode", trainingInputModeAsString()).add("Description", description())
                .add("KmsKeyArn", kmsKeyArn()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "hyperparameters":
            return Optional.ofNullable(clazz.cast(hyperparameters()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "resourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "stoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "incrementalTrainingDataChannels":
            return Optional.ofNullable(clazz.cast(incrementalTrainingDataChannels()));
        case "dataChannels":
            return Optional.ofNullable(clazz.cast(dataChannels()));
        case "trainingInputMode":
            return Optional.ofNullable(clazz.cast(trainingInputModeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("hyperparameters", HYPERPARAMETERS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("resourceConfig", RESOURCE_CONFIG_FIELD);
        map.put("stoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("incrementalTrainingDataChannels", INCREMENTAL_TRAINING_DATA_CHANNELS_FIELD);
        map.put("dataChannels", DATA_CHANNELS_FIELD);
        map.put("trainingInputMode", TRAINING_INPUT_MODE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainedModelRequest, T> g) {
        return obj -> g.apply((CreateTrainedModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainedModelRequest> {
        /**
         * <p>
         * The membership ID of the member that is creating the trained model.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that is creating the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The name of the trained model.
         * </p>
         * 
         * @param name
         *        The name of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The associated configured model algorithm used to train this model.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The associated configured model algorithm used to train this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you
         * start the learning process.
         * </p>
         * 
         * @param hyperparameters
         *        Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before
         *        you start the learning process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperparameters(Map<String, String> hyperparameters);

        /**
         * <p>
         * The environment variables to set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Information about the EC2 resources that are used to train this model.
         * </p>
         * 
         * @param resourceConfig
         *        Information about the EC2 resources that are used to train this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * Information about the EC2 resources that are used to train this model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfig.Builder} avoiding the need
         * to create one manually via {@link ResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * The criteria that is used to stop model training.
         * </p>
         * 
         * @param stoppingCondition
         *        The criteria that is used to stop model training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * The criteria that is used to stop model training.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * Specifies the incremental training data channels for the trained model.
         * </p>
         * <p>
         * Incremental training allows you to create a new trained model with updates without retraining from scratch.
         * You can specify up to one incremental training data channel that references a previously trained model and
         * its version.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
         * <code>dataChannels</code>).
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Specifies the incremental training data channels for the trained model. </p>
         *        <p>
         *        Incremental training allows you to create a new trained model with updates without retraining from
         *        scratch. You can specify up to one incremental training data channel that references a previously
         *        trained model and its version.
         *        </p>
         *        <p>
         *        Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
         *        <code>dataChannels</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(Collection<IncrementalTrainingDataChannel> incrementalTrainingDataChannels);

        /**
         * <p>
         * Specifies the incremental training data channels for the trained model.
         * </p>
         * <p>
         * Incremental training allows you to create a new trained model with updates without retraining from scratch.
         * You can specify up to one incremental training data channel that references a previously trained model and
         * its version.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
         * <code>dataChannels</code>).
         * </p>
         * 
         * @param incrementalTrainingDataChannels
         *        Specifies the incremental training data channels for the trained model. </p>
         *        <p>
         *        Incremental training allows you to create a new trained model with updates without retraining from
         *        scratch. You can specify up to one incremental training data channel that references a previously
         *        trained model and its version.
         *        </p>
         *        <p>
         *        Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
         *        <code>dataChannels</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannel... incrementalTrainingDataChannels);

        /**
         * <p>
         * Specifies the incremental training data channels for the trained model.
         * </p>
         * <p>
         * Incremental training allows you to create a new trained model with updates without retraining from scratch.
         * You can specify up to one incremental training data channel that references a previously trained model and
         * its version.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>incrementalTrainingDataChannels</code> and
         * <code>dataChannels</code>).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannel.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannel.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #incrementalTrainingDataChannels(List<IncrementalTrainingDataChannel>)}.
         * 
         * @param incrementalTrainingDataChannels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.IncrementalTrainingDataChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalTrainingDataChannels(java.util.Collection<IncrementalTrainingDataChannel>)
         */
        Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannel.Builder>... incrementalTrainingDataChannels);

        /**
         * <p>
         * Defines the data channels that are used as input for the trained model request.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
         * <code>incrementalTrainingDataChannels</code>).
         * </p>
         * 
         * @param dataChannels
         *        Defines the data channels that are used as input for the trained model request.</p>
         *        <p>
         *        Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
         *        <code>incrementalTrainingDataChannels</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataChannels(Collection<ModelTrainingDataChannel> dataChannels);

        /**
         * <p>
         * Defines the data channels that are used as input for the trained model request.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
         * <code>incrementalTrainingDataChannels</code>).
         * </p>
         * 
         * @param dataChannels
         *        Defines the data channels that are used as input for the trained model request.</p>
         *        <p>
         *        Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
         *        <code>incrementalTrainingDataChannels</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataChannels(ModelTrainingDataChannel... dataChannels);

        /**
         * <p>
         * Defines the data channels that are used as input for the trained model request.
         * </p>
         * <p>
         * Limit: Maximum of 20 channels total (including both <code>dataChannels</code> and
         * <code>incrementalTrainingDataChannels</code>).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder#build()} is called
         * immediately and its result is passed to {@link #dataChannels(List<ModelTrainingDataChannel>)}.
         * 
         * @param dataChannels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanroomsml.model.ModelTrainingDataChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataChannels(java.util.Collection<ModelTrainingDataChannel>)
         */
        Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder>... dataChannels);

        /**
         * <p>
         * The input mode for accessing the training data. This parameter determines how the training data is made
         * available to the training algorithm. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>File</code> - The training data is downloaded to the training instance and made available as files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
         * providing faster access for large datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can
         * improve performance for certain algorithms.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingInputMode
         *        The input mode for accessing the training data. This parameter determines how the training data is
         *        made available to the training algorithm. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>File</code> - The training data is downloaded to the training instance and made available as
         *        files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training
         *        algorithm, providing faster access for large datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which
         *        can improve performance for certain algorithms.
         *        </p>
         *        </li>
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(String trainingInputMode);

        /**
         * <p>
         * The input mode for accessing the training data. This parameter determines how the training data is made
         * available to the training algorithm. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>File</code> - The training data is downloaded to the training instance and made available as files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training algorithm,
         * providing faster access for large datasets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which can
         * improve performance for certain algorithms.
         * </p>
         * </li>
         * </ul>
         * 
         * @param trainingInputMode
         *        The input mode for accessing the training data. This parameter determines how the training data is
         *        made available to the training algorithm. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>File</code> - The training data is downloaded to the training instance and made available as
         *        files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FastFile</code> - The training data is streamed directly from Amazon S3 to the training
         *        algorithm, providing faster access for large datasets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Pipe</code> - The training data is streamed to the training algorithm using named pipes, which
         *        can improve performance for certain algorithms.
         *        </p>
         *        </li>
         * @see TrainingInputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInputMode
         */
        Builder trainingInputMode(TrainingInputMode trainingInputMode);

        /**
         * <p>
         * The description of the trained model.
         * </p>
         * 
         * @param description
         *        The description of the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned data in
         * the trained ML model and the associated data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt and decrypt customer-owned
         *        data in the trained ML model and the associated data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The optional metadata that you apply to the resource to help you categorize and organize them. Each tag
         * consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is reserved
         * for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this prefix. If a tag value
         * has aws as its prefix but the key does not, then Clean Rooms ML considers it to be a user tag and will count
         * against the limit of 50 tags. Tags with only the key prefix of aws do not count against your tags per
         * resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the resource to help you categorize and organize them. Each
         *        tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use aws:, AWS:, or any upper or lowercase combination of such as a prefix for keys as it is
         *        reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
         *        prefix. If a tag value has aws as its prefix but the key does not, then Clean Rooms ML considers it to
         *        be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of aws do not
         *        count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String membershipIdentifier;

        private String name;

        private String configuredModelAlgorithmAssociationArn;

        private Map<String, String> hyperparameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private ResourceConfig resourceConfig;

        private StoppingCondition stoppingCondition;

        private List<IncrementalTrainingDataChannel> incrementalTrainingDataChannels = DefaultSdkAutoConstructList.getInstance();

        private List<ModelTrainingDataChannel> dataChannels = DefaultSdkAutoConstructList.getInstance();

        private String trainingInputMode;

        private String description;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainedModelRequest model) {
            super(model);
            membershipIdentifier(model.membershipIdentifier);
            name(model.name);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            hyperparameters(model.hyperparameters);
            environment(model.environment);
            resourceConfig(model.resourceConfig);
            stoppingCondition(model.stoppingCondition);
            incrementalTrainingDataChannels(model.incrementalTrainingDataChannels);
            dataChannels(model.dataChannels);
            trainingInputMode(model.trainingInputMode);
            description(model.description);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final Map<String, String> getHyperparameters() {
            if (hyperparameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperparameters;
        }

        public final void setHyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
        }

        @Override
        public final Builder hyperparameters(Map<String, String> hyperparameters) {
            this.hyperparameters = HyperParametersCopier.copy(hyperparameters);
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentCopier.copy(environment);
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<IncrementalTrainingDataChannel.Builder> getIncrementalTrainingDataChannels() {
            List<IncrementalTrainingDataChannel.Builder> result = IncrementalTrainingDataChannelsCopier
                    .copyToBuilder(this.incrementalTrainingDataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannel.BuilderImpl> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsCopier
                    .copyFromBuilder(incrementalTrainingDataChannels);
        }

        @Override
        public final Builder incrementalTrainingDataChannels(
                Collection<IncrementalTrainingDataChannel> incrementalTrainingDataChannels) {
            this.incrementalTrainingDataChannels = IncrementalTrainingDataChannelsCopier.copy(incrementalTrainingDataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(IncrementalTrainingDataChannel... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Arrays.asList(incrementalTrainingDataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incrementalTrainingDataChannels(
                Consumer<IncrementalTrainingDataChannel.Builder>... incrementalTrainingDataChannels) {
            incrementalTrainingDataChannels(Stream.of(incrementalTrainingDataChannels)
                    .map(c -> IncrementalTrainingDataChannel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ModelTrainingDataChannel.Builder> getDataChannels() {
            List<ModelTrainingDataChannel.Builder> result = ModelTrainingDataChannelsCopier.copyToBuilder(this.dataChannels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataChannels(Collection<ModelTrainingDataChannel.BuilderImpl> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copyFromBuilder(dataChannels);
        }

        @Override
        public final Builder dataChannels(Collection<ModelTrainingDataChannel> dataChannels) {
            this.dataChannels = ModelTrainingDataChannelsCopier.copy(dataChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(ModelTrainingDataChannel... dataChannels) {
            dataChannels(Arrays.asList(dataChannels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataChannels(Consumer<ModelTrainingDataChannel.Builder>... dataChannels) {
            dataChannels(Stream.of(dataChannels).map(c -> ModelTrainingDataChannel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTrainingInputMode() {
            return trainingInputMode;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode == null ? null : trainingInputMode.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainedModelRequest build() {
            return new CreateTrainedModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
