/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrainedModelOutputRequest extends CleanRoomsMlRequest implements
        ToCopyableBuilder<DeleteTrainedModelOutputRequest.Builder, DeleteTrainedModelOutputRequest> {
    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(DeleteTrainedModelOutputRequest::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(DeleteTrainedModelOutputRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> VERSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionIdentifier").getter(getter(DeleteTrainedModelOutputRequest::versionIdentifier))
            .setter(setter(Builder::versionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINED_MODEL_ARN_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD, VERSION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainedModelArn;

    private final String membershipIdentifier;

    private final String versionIdentifier;

    private DeleteTrainedModelOutputRequest(BuilderImpl builder) {
        super(builder);
        this.trainedModelArn = builder.trainedModelArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.versionIdentifier = builder.versionIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model whose output you want to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model whose output you want to delete.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The membership ID of the member that is deleting the trained model output.
     * </p>
     * 
     * @return The membership ID of the member that is deleting the trained model output.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The version identifier of the trained model to delete. If not specified, the operation will delete the base
     * version of the trained model. When specified, only the particular version will be deleted.
     * </p>
     * 
     * @return The version identifier of the trained model to delete. If not specified, the operation will delete the
     *         base version of the trained model. When specified, only the particular version will be deleted.
     */
    public final String versionIdentifier() {
        return versionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrainedModelOutputRequest)) {
            return false;
        }
        DeleteTrainedModelOutputRequest other = (DeleteTrainedModelOutputRequest) obj;
        return Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(versionIdentifier(), other.versionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTrainedModelOutputRequest").add("TrainedModelArn", trainedModelArn())
                .add("MembershipIdentifier", membershipIdentifier()).add("VersionIdentifier", versionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "versionIdentifier":
            return Optional.ofNullable(clazz.cast(versionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("versionIdentifier", VERSION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrainedModelOutputRequest, T> g) {
        return obj -> g.apply((DeleteTrainedModelOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsMlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteTrainedModelOutputRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model whose output you want to delete.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model whose output you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The membership ID of the member that is deleting the trained model output.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the member that is deleting the trained model output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The version identifier of the trained model to delete. If not specified, the operation will delete the base
         * version of the trained model. When specified, only the particular version will be deleted.
         * </p>
         * 
         * @param versionIdentifier
         *        The version identifier of the trained model to delete. If not specified, the operation will delete the
         *        base version of the trained model. When specified, only the particular version will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdentifier(String versionIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsMlRequest.BuilderImpl implements Builder {
        private String trainedModelArn;

        private String membershipIdentifier;

        private String versionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrainedModelOutputRequest model) {
            super(model);
            trainedModelArn(model.trainedModelArn);
            membershipIdentifier(model.membershipIdentifier);
            versionIdentifier(model.versionIdentifier);
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getVersionIdentifier() {
            return versionIdentifier;
        }

        public final void setVersionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
        }

        @Override
        public final Builder versionIdentifier(String versionIdentifier) {
            this.versionIdentifier = versionIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrainedModelOutputRequest build() {
            return new DeleteTrainedModelOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
