/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for log redaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogRedactionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogRedactionConfiguration.Builder, LogRedactionConfiguration> {
    private static final SdkField<List<String>> ENTITIES_TO_REDACT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entitiesToRedact")
            .getter(getter(LogRedactionConfiguration::entitiesToRedactAsStrings))
            .setter(setter(Builder::entitiesToRedactWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitiesToRedact").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomEntityConfig> CUSTOM_ENTITY_CONFIG_FIELD = SdkField
            .<CustomEntityConfig> builder(MarshallingType.SDK_POJO).memberName("customEntityConfig")
            .getter(getter(LogRedactionConfiguration::customEntityConfig)).setter(setter(Builder::customEntityConfig))
            .constructor(CustomEntityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customEntityConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITIES_TO_REDACT_FIELD,
            CUSTOM_ENTITY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> entitiesToRedact;

    private final CustomEntityConfig customEntityConfig;

    private LogRedactionConfiguration(BuilderImpl builder) {
        this.entitiesToRedact = builder.entitiesToRedact;
        this.customEntityConfig = builder.customEntityConfig;
    }

    /**
     * <p>
     * Specifies the entities to be redacted from logs. Entities to redact are
     * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
     * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitiesToRedact} method.
     * </p>
     * 
     * @return Specifies the entities to be redacted from logs. Entities to redact are
     *         "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
     *         custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or
     *         error messages.
     */
    public final List<EntityType> entitiesToRedact() {
        return EntityTypeListCopier.copyStringToEnum(entitiesToRedact);
    }

    /**
     * For responses, this returns true if the service returned a value for the EntitiesToRedact property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitiesToRedact() {
        return entitiesToRedact != null && !(entitiesToRedact instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the entities to be redacted from logs. Entities to redact are
     * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
     * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitiesToRedact} method.
     * </p>
     * 
     * @return Specifies the entities to be redacted from logs. Entities to redact are
     *         "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
     *         custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or
     *         error messages.
     */
    public final List<String> entitiesToRedactAsStrings() {
        return entitiesToRedact;
    }

    /**
     * <p>
     * Specifies the configuration for custom entities in the context of log redaction.
     * </p>
     * 
     * @return Specifies the configuration for custom entities in the context of log redaction.
     */
    public final CustomEntityConfig customEntityConfig() {
        return customEntityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitiesToRedact() ? entitiesToRedactAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customEntityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogRedactionConfiguration)) {
            return false;
        }
        LogRedactionConfiguration other = (LogRedactionConfiguration) obj;
        return hasEntitiesToRedact() == other.hasEntitiesToRedact()
                && Objects.equals(entitiesToRedactAsStrings(), other.entitiesToRedactAsStrings())
                && Objects.equals(customEntityConfig(), other.customEntityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogRedactionConfiguration")
                .add("EntitiesToRedact", hasEntitiesToRedact() ? entitiesToRedactAsStrings() : null)
                .add("CustomEntityConfig", customEntityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entitiesToRedact":
            return Optional.ofNullable(clazz.cast(entitiesToRedactAsStrings()));
        case "customEntityConfig":
            return Optional.ofNullable(clazz.cast(customEntityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entitiesToRedact", ENTITIES_TO_REDACT_FIELD);
        map.put("customEntityConfig", CUSTOM_ENTITY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogRedactionConfiguration, T> g) {
        return obj -> g.apply((LogRedactionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogRedactionConfiguration> {
        /**
         * <p>
         * Specifies the entities to be redacted from logs. Entities to redact are
         * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
         * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error
         * messages.
         * </p>
         * 
         * @param entitiesToRedact
         *        Specifies the entities to be redacted from logs. Entities to redact are
         *        "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
         *        custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs
         *        or error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesToRedactWithStrings(Collection<String> entitiesToRedact);

        /**
         * <p>
         * Specifies the entities to be redacted from logs. Entities to redact are
         * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
         * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error
         * messages.
         * </p>
         * 
         * @param entitiesToRedact
         *        Specifies the entities to be redacted from logs. Entities to redact are
         *        "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
         *        custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs
         *        or error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesToRedactWithStrings(String... entitiesToRedact);

        /**
         * <p>
         * Specifies the entities to be redacted from logs. Entities to redact are
         * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
         * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error
         * messages.
         * </p>
         * 
         * @param entitiesToRedact
         *        Specifies the entities to be redacted from logs. Entities to redact are
         *        "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
         *        custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs
         *        or error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesToRedact(Collection<EntityType> entitiesToRedact);

        /**
         * <p>
         * Specifies the entities to be redacted from logs. Entities to redact are
         * "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured, custom
         * patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs or error
         * messages.
         * </p>
         * 
         * @param entitiesToRedact
         *        Specifies the entities to be redacted from logs. Entities to redact are
         *        "ALL_PERSONALLY_IDENTIFIABLE_INFORMATION", "NUMBERS","CUSTOM". If CUSTOM is supplied or configured,
         *        custom patterns (customDataIdentifiers) should be provided, and the patterns will be redacted in logs
         *        or error messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitiesToRedact(EntityType... entitiesToRedact);

        /**
         * <p>
         * Specifies the configuration for custom entities in the context of log redaction.
         * </p>
         * 
         * @param customEntityConfig
         *        Specifies the configuration for custom entities in the context of log redaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEntityConfig(CustomEntityConfig customEntityConfig);

        /**
         * <p>
         * Specifies the configuration for custom entities in the context of log redaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomEntityConfig.Builder} avoiding the
         * need to create one manually via {@link CustomEntityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomEntityConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #customEntityConfig(CustomEntityConfig)}.
         * 
         * @param customEntityConfig
         *        a consumer that will call methods on {@link CustomEntityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customEntityConfig(CustomEntityConfig)
         */
        default Builder customEntityConfig(Consumer<CustomEntityConfig.Builder> customEntityConfig) {
            return customEntityConfig(CustomEntityConfig.builder().applyMutation(customEntityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> entitiesToRedact = DefaultSdkAutoConstructList.getInstance();

        private CustomEntityConfig customEntityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LogRedactionConfiguration model) {
            entitiesToRedactWithStrings(model.entitiesToRedact);
            customEntityConfig(model.customEntityConfig);
        }

        public final Collection<String> getEntitiesToRedact() {
            if (entitiesToRedact instanceof SdkAutoConstructList) {
                return null;
            }
            return entitiesToRedact;
        }

        public final void setEntitiesToRedact(Collection<String> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copy(entitiesToRedact);
        }

        @Override
        public final Builder entitiesToRedactWithStrings(Collection<String> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copy(entitiesToRedact);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesToRedactWithStrings(String... entitiesToRedact) {
            entitiesToRedactWithStrings(Arrays.asList(entitiesToRedact));
            return this;
        }

        @Override
        public final Builder entitiesToRedact(Collection<EntityType> entitiesToRedact) {
            this.entitiesToRedact = EntityTypeListCopier.copyEnumToString(entitiesToRedact);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesToRedact(EntityType... entitiesToRedact) {
            entitiesToRedact(Arrays.asList(entitiesToRedact));
            return this;
        }

        public final CustomEntityConfig.Builder getCustomEntityConfig() {
            return customEntityConfig != null ? customEntityConfig.toBuilder() : null;
        }

        public final void setCustomEntityConfig(CustomEntityConfig.BuilderImpl customEntityConfig) {
            this.customEntityConfig = customEntityConfig != null ? customEntityConfig.build() : null;
        }

        @Override
        public final Builder customEntityConfig(CustomEntityConfig customEntityConfig) {
            this.customEntityConfig = customEntityConfig;
            return this;
        }

        @Override
        public LogRedactionConfiguration build() {
            return new LogRedactionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
