/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the maximum size limit for trained model artifacts. This configuration helps control storage costs and
 * ensures that trained models don't exceed specified size constraints. The size limit applies to the total size of all
 * artifacts produced by the training job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelArtifactMaxSize implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelArtifactMaxSize.Builder, TrainedModelArtifactMaxSize> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(TrainedModelArtifactMaxSize::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(TrainedModelArtifactMaxSize::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String unit;

    private final Double value;

    private TrainedModelArtifactMaxSize(BuilderImpl builder) {
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * The unit of measurement for the maximum artifact size. Valid values include common storage units such as bytes,
     * kilobytes, megabytes, gigabytes, and terabytes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TrainedModelArtifactMaxSizeUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the maximum artifact size. Valid values include common storage units such as
     *         bytes, kilobytes, megabytes, gigabytes, and terabytes.
     * @see TrainedModelArtifactMaxSizeUnitType
     */
    public final TrainedModelArtifactMaxSizeUnitType unit() {
        return TrainedModelArtifactMaxSizeUnitType.fromValue(unit);
    }

    /**
     * <p>
     * The unit of measurement for the maximum artifact size. Valid values include common storage units such as bytes,
     * kilobytes, megabytes, gigabytes, and terabytes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link TrainedModelArtifactMaxSizeUnitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of measurement for the maximum artifact size. Valid values include common storage units such as
     *         bytes, kilobytes, megabytes, gigabytes, and terabytes.
     * @see TrainedModelArtifactMaxSizeUnitType
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The numerical value for the maximum artifact size limit. This value is interpreted according to the specified
     * unit.
     * </p>
     * 
     * @return The numerical value for the maximum artifact size limit. This value is interpreted according to the
     *         specified unit.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelArtifactMaxSize)) {
            return false;
        }
        TrainedModelArtifactMaxSize other = (TrainedModelArtifactMaxSize) obj;
        return Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelArtifactMaxSize").add("Unit", unitAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unit", UNIT_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelArtifactMaxSize, T> g) {
        return obj -> g.apply((TrainedModelArtifactMaxSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelArtifactMaxSize> {
        /**
         * <p>
         * The unit of measurement for the maximum artifact size. Valid values include common storage units such as
         * bytes, kilobytes, megabytes, gigabytes, and terabytes.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the maximum artifact size. Valid values include common storage units such
         *        as bytes, kilobytes, megabytes, gigabytes, and terabytes.
         * @see TrainedModelArtifactMaxSizeUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelArtifactMaxSizeUnitType
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of measurement for the maximum artifact size. Valid values include common storage units such as
         * bytes, kilobytes, megabytes, gigabytes, and terabytes.
         * </p>
         * 
         * @param unit
         *        The unit of measurement for the maximum artifact size. Valid values include common storage units such
         *        as bytes, kilobytes, megabytes, gigabytes, and terabytes.
         * @see TrainedModelArtifactMaxSizeUnitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelArtifactMaxSizeUnitType
         */
        Builder unit(TrainedModelArtifactMaxSizeUnitType unit);

        /**
         * <p>
         * The numerical value for the maximum artifact size limit. This value is interpreted according to the specified
         * unit.
         * </p>
         * 
         * @param value
         *        The numerical value for the maximum artifact size limit. This value is interpreted according to the
         *        specified unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String unit;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelArtifactMaxSize model) {
            unit(model.unit);
            value(model.value);
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(TrainedModelArtifactMaxSizeUnitType unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public TrainedModelArtifactMaxSize build() {
            return new TrainedModelArtifactMaxSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
