/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanroomsml.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the trained model inference job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainedModelInferenceJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainedModelInferenceJobSummary.Builder, TrainedModelInferenceJobSummary> {
    private static final SdkField<String> TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainedModelInferenceJobArn")
            .getter(getter(TrainedModelInferenceJobSummary::trainedModelInferenceJobArn))
            .setter(setter(Builder::trainedModelInferenceJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelInferenceJobArn")
                    .build()).build();

    private static final SdkField<String> CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("configuredModelAlgorithmAssociationArn")
            .getter(getter(TrainedModelInferenceJobSummary::configuredModelAlgorithmAssociationArn))
            .setter(setter(Builder::configuredModelAlgorithmAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("configuredModelAlgorithmAssociationArn").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(TrainedModelInferenceJobSummary::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipIdentifier").build())
            .build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainedModelArn").getter(getter(TrainedModelInferenceJobSummary::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelArn").build()).build();

    private static final SdkField<String> TRAINED_MODEL_VERSION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("trainedModelVersionIdentifier")
            .getter(getter(TrainedModelInferenceJobSummary::trainedModelVersionIdentifier))
            .setter(setter(Builder::trainedModelVersionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainedModelVersionIdentifier")
                    .build()).build();

    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(TrainedModelInferenceJobSummary::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TrainedModelInferenceJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<InferenceOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("outputConfiguration")
            .getter(getter(TrainedModelInferenceJobSummary::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TrainedModelInferenceJobSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(TrainedModelInferenceJobSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> METRICS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatus").getter(getter(TrainedModelInferenceJobSummary::metricsStatusAsString))
            .setter(setter(Builder::metricsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatus").build()).build();

    private static final SdkField<String> METRICS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricsStatusDetails").getter(getter(TrainedModelInferenceJobSummary::metricsStatusDetails))
            .setter(setter(Builder::metricsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsStatusDetails").build())
            .build();

    private static final SdkField<String> LOGS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatus").getter(getter(TrainedModelInferenceJobSummary::logsStatusAsString))
            .setter(setter(Builder::logsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatus").build()).build();

    private static final SdkField<String> LOGS_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logsStatusDetails").getter(getter(TrainedModelInferenceJobSummary::logsStatusDetails))
            .setter(setter(Builder::logsStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsStatusDetails").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime")
            .getter(getter(TrainedModelInferenceJobSummary::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(TrainedModelInferenceJobSummary::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD, CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD, MEMBERSHIP_IDENTIFIER_FIELD,
            TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_VERSION_IDENTIFIER_FIELD, COLLABORATION_IDENTIFIER_FIELD, STATUS_FIELD,
            OUTPUT_CONFIGURATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, METRICS_STATUS_FIELD, METRICS_STATUS_DETAILS_FIELD,
            LOGS_STATUS_FIELD, LOGS_STATUS_DETAILS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trainedModelInferenceJobArn;

    private final String configuredModelAlgorithmAssociationArn;

    private final String membershipIdentifier;

    private final String trainedModelArn;

    private final String trainedModelVersionIdentifier;

    private final String collaborationIdentifier;

    private final String status;

    private final InferenceOutputConfiguration outputConfiguration;

    private final String name;

    private final String description;

    private final String metricsStatus;

    private final String metricsStatusDetails;

    private final String logsStatus;

    private final String logsStatusDetails;

    private final Instant createTime;

    private final Instant updateTime;

    private TrainedModelInferenceJobSummary(BuilderImpl builder) {
        this.trainedModelInferenceJobArn = builder.trainedModelInferenceJobArn;
        this.configuredModelAlgorithmAssociationArn = builder.configuredModelAlgorithmAssociationArn;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelVersionIdentifier = builder.trainedModelVersionIdentifier;
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.status = builder.status;
        this.outputConfiguration = builder.outputConfiguration;
        this.name = builder.name;
        this.description = builder.description;
        this.metricsStatus = builder.metricsStatus;
        this.metricsStatusDetails = builder.metricsStatusDetails;
        this.logsStatus = builder.logsStatus;
        this.logsStatusDetails = builder.logsStatusDetails;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model inference job.
     */
    public final String trainedModelInferenceJobArn() {
        return trainedModelInferenceJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the trained model
     * inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the trained
     *         model inference job.
     */
    public final String configuredModelAlgorithmAssociationArn() {
        return configuredModelAlgorithmAssociationArn;
    }

    /**
     * <p>
     * The membership ID of the membership that contains the trained model inference job.
     * </p>
     * 
     * @return The membership ID of the membership that contains the trained model inference job.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The version identifier of the trained model that was used for inference in this job.
     * </p>
     * 
     * @return The version identifier of the trained model that was used for inference in this job.
     */
    public final String trainedModelVersionIdentifier() {
        return trainedModelVersionIdentifier;
    }

    /**
     * <p>
     * The collaboration ID of the collaboration that contains the trained model inference job.
     * </p>
     * 
     * @return The collaboration ID of the collaboration that contains the trained model inference job.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * The status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelInferenceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model inference job.
     * @see TrainedModelInferenceJobStatus
     */
    public final TrainedModelInferenceJobStatus status() {
        return TrainedModelInferenceJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrainedModelInferenceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the trained model inference job.
     * @see TrainedModelInferenceJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The output configuration information of the trained model job.
     * </p>
     * 
     * @return The output configuration information of the trained model job.
     */
    public final InferenceOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The name of the trained model inference job.
     * </p>
     * 
     * @return The name of the trained model inference job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the trained model inference job.
     * </p>
     * 
     * @return The description of the trained model inference job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The metric status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The metric status of the trained model inference job.
     * @see MetricsStatus
     */
    public final MetricsStatus metricsStatus() {
        return MetricsStatus.fromValue(metricsStatus);
    }

    /**
     * <p>
     * The metric status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricsStatus}
     * will return {@link MetricsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricsStatusAsString}.
     * </p>
     * 
     * @return The metric status of the trained model inference job.
     * @see MetricsStatus
     */
    public final String metricsStatusAsString() {
        return metricsStatus;
    }

    /**
     * <p>
     * Details about the metrics status for the trained model inference job.
     * </p>
     * 
     * @return Details about the metrics status for the trained model inference job.
     */
    public final String metricsStatusDetails() {
        return metricsStatusDetails;
    }

    /**
     * <p>
     * The log status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The log status of the trained model inference job.
     * @see LogsStatus
     */
    public final LogsStatus logsStatus() {
        return LogsStatus.fromValue(logsStatus);
    }

    /**
     * <p>
     * The log status of the trained model inference job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logsStatus} will
     * return {@link LogsStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logsStatusAsString}.
     * </p>
     * 
     * @return The log status of the trained model inference job.
     * @see LogsStatus
     */
    public final String logsStatusAsString() {
        return logsStatus;
    }

    /**
     * <p>
     * Details about the log status for the trained model inference job.
     * </p>
     * 
     * @return Details about the log status for the trained model inference job.
     */
    public final String logsStatusDetails() {
        return logsStatusDetails;
    }

    /**
     * <p>
     * The time at which the trained model inference job was created.
     * </p>
     * 
     * @return The time at which the trained model inference job was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The most recent time at which the trained model inference job was updated.
     * </p>
     * 
     * @return The most recent time at which the trained model inference job was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelInferenceJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(configuredModelAlgorithmAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logsStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainedModelInferenceJobSummary)) {
            return false;
        }
        TrainedModelInferenceJobSummary other = (TrainedModelInferenceJobSummary) obj;
        return Objects.equals(trainedModelInferenceJobArn(), other.trainedModelInferenceJobArn())
                && Objects.equals(configuredModelAlgorithmAssociationArn(), other.configuredModelAlgorithmAssociationArn())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(trainedModelVersionIdentifier(), other.trainedModelVersionIdentifier())
                && Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(outputConfiguration(), other.outputConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(metricsStatusAsString(), other.metricsStatusAsString())
                && Objects.equals(metricsStatusDetails(), other.metricsStatusDetails())
                && Objects.equals(logsStatusAsString(), other.logsStatusAsString())
                && Objects.equals(logsStatusDetails(), other.logsStatusDetails())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrainedModelInferenceJobSummary")
                .add("TrainedModelInferenceJobArn", trainedModelInferenceJobArn())
                .add("ConfiguredModelAlgorithmAssociationArn", configuredModelAlgorithmAssociationArn())
                .add("MembershipIdentifier", membershipIdentifier()).add("TrainedModelArn", trainedModelArn())
                .add("TrainedModelVersionIdentifier", trainedModelVersionIdentifier())
                .add("CollaborationIdentifier", collaborationIdentifier()).add("Status", statusAsString())
                .add("OutputConfiguration", outputConfiguration()).add("Name", name()).add("Description", description())
                .add("MetricsStatus", metricsStatusAsString()).add("MetricsStatusDetails", metricsStatusDetails())
                .add("LogsStatus", logsStatusAsString()).add("LogsStatusDetails", logsStatusDetails())
                .add("CreateTime", createTime()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trainedModelInferenceJobArn":
            return Optional.ofNullable(clazz.cast(trainedModelInferenceJobArn()));
        case "configuredModelAlgorithmAssociationArn":
            return Optional.ofNullable(clazz.cast(configuredModelAlgorithmAssociationArn()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "trainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "trainedModelVersionIdentifier":
            return Optional.ofNullable(clazz.cast(trainedModelVersionIdentifier()));
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "metricsStatus":
            return Optional.ofNullable(clazz.cast(metricsStatusAsString()));
        case "metricsStatusDetails":
            return Optional.ofNullable(clazz.cast(metricsStatusDetails()));
        case "logsStatus":
            return Optional.ofNullable(clazz.cast(logsStatusAsString()));
        case "logsStatusDetails":
            return Optional.ofNullable(clazz.cast(logsStatusDetails()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("trainedModelInferenceJobArn", TRAINED_MODEL_INFERENCE_JOB_ARN_FIELD);
        map.put("configuredModelAlgorithmAssociationArn", CONFIGURED_MODEL_ALGORITHM_ASSOCIATION_ARN_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("trainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("trainedModelVersionIdentifier", TRAINED_MODEL_VERSION_IDENTIFIER_FIELD);
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("outputConfiguration", OUTPUT_CONFIGURATION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("metricsStatus", METRICS_STATUS_FIELD);
        map.put("metricsStatusDetails", METRICS_STATUS_DETAILS_FIELD);
        map.put("logsStatus", LOGS_STATUS_FIELD);
        map.put("logsStatusDetails", LOGS_STATUS_DETAILS_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainedModelInferenceJobSummary, T> g) {
        return obj -> g.apply((TrainedModelInferenceJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainedModelInferenceJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model inference job.
         * </p>
         * 
         * @param trainedModelInferenceJobArn
         *        The Amazon Resource Name (ARN) of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the trained
         * model inference job.
         * </p>
         * 
         * @param configuredModelAlgorithmAssociationArn
         *        The Amazon Resource Name (ARN) of the configured model algorithm association that is used for the
         *        trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn);

        /**
         * <p>
         * The membership ID of the membership that contains the trained model inference job.
         * </p>
         * 
         * @param membershipIdentifier
         *        The membership ID of the membership that contains the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
         * </p>
         * 
         * @param trainedModelArn
         *        The Amazon Resource Name (ARN) of the trained model that is used for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The version identifier of the trained model that was used for inference in this job.
         * </p>
         * 
         * @param trainedModelVersionIdentifier
         *        The version identifier of the trained model that was used for inference in this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier);

        /**
         * <p>
         * The collaboration ID of the collaboration that contains the trained model inference job.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The collaboration ID of the collaboration that contains the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * The status of the trained model inference job.
         * </p>
         * 
         * @param status
         *        The status of the trained model inference job.
         * @see TrainedModelInferenceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelInferenceJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the trained model inference job.
         * </p>
         * 
         * @param status
         *        The status of the trained model inference job.
         * @see TrainedModelInferenceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainedModelInferenceJobStatus
         */
        Builder status(TrainedModelInferenceJobStatus status);

        /**
         * <p>
         * The output configuration information of the trained model job.
         * </p>
         * 
         * @param outputConfiguration
         *        The output configuration information of the trained model job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The output configuration information of the trained model job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(InferenceOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<InferenceOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(InferenceOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The name of the trained model inference job.
         * </p>
         * 
         * @param name
         *        The name of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the trained model inference job.
         * </p>
         * 
         * @param description
         *        The description of the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The metric status of the trained model inference job.
         * </p>
         * 
         * @param metricsStatus
         *        The metric status of the trained model inference job.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(String metricsStatus);

        /**
         * <p>
         * The metric status of the trained model inference job.
         * </p>
         * 
         * @param metricsStatus
         *        The metric status of the trained model inference job.
         * @see MetricsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsStatus
         */
        Builder metricsStatus(MetricsStatus metricsStatus);

        /**
         * <p>
         * Details about the metrics status for the trained model inference job.
         * </p>
         * 
         * @param metricsStatusDetails
         *        Details about the metrics status for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsStatusDetails(String metricsStatusDetails);

        /**
         * <p>
         * The log status of the trained model inference job.
         * </p>
         * 
         * @param logsStatus
         *        The log status of the trained model inference job.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(String logsStatus);

        /**
         * <p>
         * The log status of the trained model inference job.
         * </p>
         * 
         * @param logsStatus
         *        The log status of the trained model inference job.
         * @see LogsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsStatus
         */
        Builder logsStatus(LogsStatus logsStatus);

        /**
         * <p>
         * Details about the log status for the trained model inference job.
         * </p>
         * 
         * @param logsStatusDetails
         *        Details about the log status for the trained model inference job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsStatusDetails(String logsStatusDetails);

        /**
         * <p>
         * The time at which the trained model inference job was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the trained model inference job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The most recent time at which the trained model inference job was updated.
         * </p>
         * 
         * @param updateTime
         *        The most recent time at which the trained model inference job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String trainedModelInferenceJobArn;

        private String configuredModelAlgorithmAssociationArn;

        private String membershipIdentifier;

        private String trainedModelArn;

        private String trainedModelVersionIdentifier;

        private String collaborationIdentifier;

        private String status;

        private InferenceOutputConfiguration outputConfiguration;

        private String name;

        private String description;

        private String metricsStatus;

        private String metricsStatusDetails;

        private String logsStatus;

        private String logsStatusDetails;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainedModelInferenceJobSummary model) {
            trainedModelInferenceJobArn(model.trainedModelInferenceJobArn);
            configuredModelAlgorithmAssociationArn(model.configuredModelAlgorithmAssociationArn);
            membershipIdentifier(model.membershipIdentifier);
            trainedModelArn(model.trainedModelArn);
            trainedModelVersionIdentifier(model.trainedModelVersionIdentifier);
            collaborationIdentifier(model.collaborationIdentifier);
            status(model.status);
            outputConfiguration(model.outputConfiguration);
            name(model.name);
            description(model.description);
            metricsStatus(model.metricsStatus);
            metricsStatusDetails(model.metricsStatusDetails);
            logsStatus(model.logsStatus);
            logsStatusDetails(model.logsStatusDetails);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getTrainedModelInferenceJobArn() {
            return trainedModelInferenceJobArn;
        }

        public final void setTrainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
        }

        @Override
        public final Builder trainedModelInferenceJobArn(String trainedModelInferenceJobArn) {
            this.trainedModelInferenceJobArn = trainedModelInferenceJobArn;
            return this;
        }

        public final String getConfiguredModelAlgorithmAssociationArn() {
            return configuredModelAlgorithmAssociationArn;
        }

        public final void setConfiguredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
        }

        @Override
        public final Builder configuredModelAlgorithmAssociationArn(String configuredModelAlgorithmAssociationArn) {
            this.configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final String getTrainedModelVersionIdentifier() {
            return trainedModelVersionIdentifier;
        }

        public final void setTrainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
        }

        @Override
        public final Builder trainedModelVersionIdentifier(String trainedModelVersionIdentifier) {
            this.trainedModelVersionIdentifier = trainedModelVersionIdentifier;
            return this;
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrainedModelInferenceJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InferenceOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        public final void setOutputConfiguration(InferenceOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        @Override
        public final Builder outputConfiguration(InferenceOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMetricsStatus() {
            return metricsStatus;
        }

        public final void setMetricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
        }

        @Override
        public final Builder metricsStatus(String metricsStatus) {
            this.metricsStatus = metricsStatus;
            return this;
        }

        @Override
        public final Builder metricsStatus(MetricsStatus metricsStatus) {
            this.metricsStatus(metricsStatus == null ? null : metricsStatus.toString());
            return this;
        }

        public final String getMetricsStatusDetails() {
            return metricsStatusDetails;
        }

        public final void setMetricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
        }

        @Override
        public final Builder metricsStatusDetails(String metricsStatusDetails) {
            this.metricsStatusDetails = metricsStatusDetails;
            return this;
        }

        public final String getLogsStatus() {
            return logsStatus;
        }

        public final void setLogsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
        }

        @Override
        public final Builder logsStatus(String logsStatus) {
            this.logsStatus = logsStatus;
            return this;
        }

        @Override
        public final Builder logsStatus(LogsStatus logsStatus) {
            this.logsStatus(logsStatus == null ? null : logsStatus.toString());
            return this;
        }

        public final String getLogsStatusDetails() {
            return logsStatusDetails;
        }

        public final void setLogsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
        }

        @Override
        public final Builder logsStatusDetails(String logsStatusDetails) {
            this.logsStatusDetails = logsStatusDetails;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public TrainedModelInferenceJobSummary build() {
            return new TrainedModelInferenceJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
