/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an environment member for an AWS Cloud9 development environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentMember implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentMember.Builder, EnvironmentMember> {
    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentMember::permissionsAsString)).setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentMember::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()).build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentMember::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EnvironmentMember::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<Instant> LAST_ACCESS_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EnvironmentMember::lastAccess)).setter(setter(Builder::lastAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD,
            USER_ID_FIELD, USER_ARN_FIELD, ENVIRONMENT_ID_FIELD, LAST_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String permissions;

    private final String userId;

    private final String userArn;

    private final String environmentId;

    private final Instant lastAccess;

    private EnvironmentMember(BuilderImpl builder) {
        this.permissions = builder.permissions;
        this.userId = builder.userId;
        this.userArn = builder.userArn;
        this.environmentId = builder.environmentId;
        this.lastAccess = builder.lastAccess;
    }

    /**
     * <p>
     * The type of environment member permissions associated with this environment member. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>owner</code>: Owns the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissions} will
     * return {@link Permissions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionsAsString}.
     * </p>
     * 
     * @return The type of environment member permissions associated with this environment member. Available values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>owner</code>: Owns the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     * @see Permissions
     */
    public Permissions permissions() {
        return Permissions.fromValue(permissions);
    }

    /**
     * <p>
     * The type of environment member permissions associated with this environment member. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>owner</code>: Owns the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissions} will
     * return {@link Permissions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionsAsString}.
     * </p>
     * 
     * @return The type of environment member permissions associated with this environment member. Available values
     *         include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>owner</code>: Owns the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     * @see Permissions
     */
    public String permissionsAsString() {
        return permissions;
    }

    /**
     * <p>
     * The user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
     * </p>
     * 
     * @return The user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment member.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment member.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The ID of the environment for the environment member.
     * </p>
     * 
     * @return The ID of the environment for the environment member.
     */
    public String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The time, expressed in epoch time format, when the environment member last opened the environment.
     * </p>
     * 
     * @return The time, expressed in epoch time format, when the environment member last opened the environment.
     */
    public Instant lastAccess() {
        return lastAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(permissionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccess());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentMember)) {
            return false;
        }
        EnvironmentMember other = (EnvironmentMember) obj;
        return Objects.equals(permissionsAsString(), other.permissionsAsString()) && Objects.equals(userId(), other.userId())
                && Objects.equals(userArn(), other.userArn()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(lastAccess(), other.lastAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EnvironmentMember").add("Permissions", permissionsAsString()).add("UserId", userId())
                .add("UserArn", userArn()).add("EnvironmentId", environmentId()).add("LastAccess", lastAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsString()));
        case "userId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "lastAccess":
            return Optional.ofNullable(clazz.cast(lastAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentMember, T> g) {
        return obj -> g.apply((EnvironmentMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentMember> {
        /**
         * <p>
         * The type of environment member permissions associated with this environment member. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        The type of environment member permissions associated with this environment member. Available values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         * @see Permissions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permissions
         */
        Builder permissions(String permissions);

        /**
         * <p>
         * The type of environment member permissions associated with this environment member. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>owner</code>: Owns the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        The type of environment member permissions associated with this environment member. Available values
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>owner</code>: Owns the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         * @see Permissions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permissions
         */
        Builder permissions(Permissions permissions);

        /**
         * <p>
         * The user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
         * </p>
         * 
         * @param userId
         *        The user ID in AWS Identity and Access Management (AWS IAM) of the environment member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment member.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the environment member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The ID of the environment for the environment member.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment for the environment member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The time, expressed in epoch time format, when the environment member last opened the environment.
         * </p>
         * 
         * @param lastAccess
         *        The time, expressed in epoch time format, when the environment member last opened the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccess(Instant lastAccess);
    }

    static final class BuilderImpl implements Builder {
        private String permissions;

        private String userId;

        private String userArn;

        private String environmentId;

        private Instant lastAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentMember model) {
            permissions(model.permissions);
            userId(model.userId);
            userArn(model.userArn);
            environmentId(model.environmentId);
            lastAccess(model.lastAccess);
        }

        public final String getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(Permissions permissions) {
            this.permissions(permissions == null ? null : permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final Instant getLastAccess() {
            return lastAccess;
        }

        @Override
        public final Builder lastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public final void setLastAccess(Instant lastAccess) {
            this.lastAccess = lastAccess;
        }

        @Override
        public EnvironmentMember build() {
            return new EnvironmentMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
