/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentMembershipRequest extends Cloud9Request implements
        ToCopyableBuilder<UpdateEnvironmentMembershipRequest.Builder, UpdateEnvironmentMembershipRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEnvironmentMembershipRequest::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEnvironmentMembershipRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userArn").build()).build();

    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEnvironmentMembershipRequest::permissionsAsString)).setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            USER_ARN_FIELD, PERMISSIONS_FIELD));

    private final String environmentId;

    private final String userArn;

    private final String permissions;

    private UpdateEnvironmentMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.userArn = builder.userArn;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The ID of the environment for the environment member whose settings you want to change.
     * </p>
     * 
     * @return The ID of the environment for the environment member whose settings you want to change.
     */
    public String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment member whose settings you want to change.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment member whose settings you want to change.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The replacement type of environment member permissions you want to associate with this environment member.
     * Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissions} will
     * return {@link MemberPermissions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionsAsString}.
     * </p>
     * 
     * @return The replacement type of environment member permissions you want to associate with this environment
     *         member. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     * @see MemberPermissions
     */
    public MemberPermissions permissions() {
        return MemberPermissions.fromValue(permissions);
    }

    /**
     * <p>
     * The replacement type of environment member permissions you want to associate with this environment member.
     * Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>read-only</code>: Has read-only access to the environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>read-write</code>: Has read-write access to the environment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissions} will
     * return {@link MemberPermissions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionsAsString}.
     * </p>
     * 
     * @return The replacement type of environment member permissions you want to associate with this environment
     *         member. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>read-only</code>: Has read-only access to the environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>read-write</code>: Has read-write access to the environment.
     *         </p>
     *         </li>
     * @see MemberPermissions
     */
    public String permissionsAsString() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentMembershipRequest)) {
            return false;
        }
        UpdateEnvironmentMembershipRequest other = (UpdateEnvironmentMembershipRequest) obj;
        return Objects.equals(environmentId(), other.environmentId()) && Objects.equals(userArn(), other.userArn())
                && Objects.equals(permissionsAsString(), other.permissionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEnvironmentMembershipRequest").add("EnvironmentId", environmentId())
                .add("UserArn", userArn()).add("Permissions", permissionsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "userArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentMembershipRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEnvironmentMembershipRequest> {
        /**
         * <p>
         * The ID of the environment for the environment member whose settings you want to change.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment for the environment member whose settings you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment member whose settings you want to change.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name (ARN) of the environment member whose settings you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The replacement type of environment member permissions you want to associate with this environment member.
         * Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        The replacement type of environment member permissions you want to associate with this environment
         *        member. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         * @see MemberPermissions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberPermissions
         */
        Builder permissions(String permissions);

        /**
         * <p>
         * The replacement type of environment member permissions you want to associate with this environment member.
         * Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>read-only</code>: Has read-only access to the environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>read-write</code>: Has read-write access to the environment.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        The replacement type of environment member permissions you want to associate with this environment
         *        member. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>read-only</code>: Has read-only access to the environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>read-write</code>: Has read-write access to the environment.
         *        </p>
         *        </li>
         * @see MemberPermissions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberPermissions
         */
        Builder permissions(MemberPermissions permissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Cloud9Request.BuilderImpl implements Builder {
        private String environmentId;

        private String userArn;

        private String permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentMembershipRequest model) {
            super(model);
            environmentId(model.environmentId);
            userArn(model.userArn);
            permissions(model.permissions);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public final Builder permissions(MemberPermissions permissions) {
            this.permissions(permissions == null ? null : permissions.toString());
            return this;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentMembershipRequest build() {
            return new UpdateEnvironmentMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
