/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentEc2Request extends Cloud9Request implements
        ToCopyableBuilder<CreateEnvironmentEc2Request.Builder, CreateEnvironmentEc2Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentEc2Request::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentEc2Request::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(CreateEnvironmentEc2Request::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(CreateEnvironmentEc2Request::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(CreateEnvironmentEc2Request::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageId").getter(getter(CreateEnvironmentEc2Request::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<Integer> AUTOMATIC_STOP_TIME_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("automaticStopTimeMinutes")
            .getter(getter(CreateEnvironmentEc2Request::automaticStopTimeMinutes))
            .setter(setter(Builder::automaticStopTimeMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticStopTimeMinutes").build())
            .build();

    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerArn").getter(getter(CreateEnvironmentEc2Request::ownerArn)).setter(setter(Builder::ownerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateEnvironmentEc2Request::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionType").getter(getter(CreateEnvironmentEc2Request::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, IMAGE_ID_FIELD, AUTOMATIC_STOP_TIME_MINUTES_FIELD,
            OWNER_ARN_FIELD, TAGS_FIELD, CONNECTION_TYPE_FIELD));

    private final String name;

    private final String description;

    private final String clientRequestToken;

    private final String instanceType;

    private final String subnetId;

    private final String imageId;

    private final Integer automaticStopTimeMinutes;

    private final String ownerArn;

    private final List<Tag> tags;

    private final String connectionType;

    private CreateEnvironmentEc2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.imageId = builder.imageId;
        this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
        this.ownerArn = builder.ownerArn;
        this.tags = builder.tags;
        this.connectionType = builder.connectionType;
    }

    /**
     * <p>
     * The name of the environment to create.
     * </p>
     * <p>
     * This name is visible to other AWS IAM users in the same AWS account.
     * </p>
     * 
     * @return The name of the environment to create.</p>
     *         <p>
     *         This name is visible to other AWS IAM users in the same AWS account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the environment to create.
     * </p>
     * 
     * @return The description of the environment to create.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one time.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one
     *         time.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client
     *         Tokens</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The type of instance to connect to the environment (for example, <code>t2.micro</code>).
     * </p>
     * 
     * @return The type of instance to connect to the environment (for example, <code>t2.micro</code>).
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI for
     * the instance, you must specify a valid AMI alias or a valid AWS Systems Manager (SSM) path.
     * </p>
     * <p>
     * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
     * </p>
     * <p>
     * <b>AMI aliases </b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>SSM paths</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an
     *         AMI for the instance, you must specify a valid AMI alias or a valid AWS Systems Manager (SSM) path.</p>
     *         <p>
     *         The default AMI is used if the parameter isn't explicitly assigned a value in the request.
     *         </p>
     *         <p>
     *         <b>AMI aliases </b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>SSM paths</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
     *         </p>
     *         </li>
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The number of minutes until the running instance is shut down after the environment has last been used.
     * </p>
     * 
     * @return The number of minutes until the running instance is shut down after the environment has last been used.
     */
    public final Integer automaticStopTimeMinutes() {
        return automaticStopTimeMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM principal. If
     * this value is not specified, the ARN defaults to this environment's creator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM
     *         principal. If this value is not specified, the ARN defaults to this environment's creator.
     */
    public final String ownerArn() {
        return ownerArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The connection type used for connecting to an Amazon EC2 environment. Valid values are <code>CONNECT_SSH</code>
     * (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing
     * no-ingress EC2 instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type used for connecting to an Amazon EC2 environment. Valid values are
     *         <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems
     *         Manager).</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2
     *         instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The connection type used for connecting to an Amazon EC2 environment. Valid values are <code>CONNECT_SSH</code>
     * (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing
     * no-ingress EC2 instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type used for connecting to an Amazon EC2 environment. Valid values are
     *         <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems
     *         Manager).</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2
     *         instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticStopTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(ownerArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentEc2Request)) {
            return false;
        }
        CreateEnvironmentEc2Request other = (CreateEnvironmentEc2Request) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(imageId(), other.imageId())
                && Objects.equals(automaticStopTimeMinutes(), other.automaticStopTimeMinutes())
                && Objects.equals(ownerArn(), other.ownerArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentEc2Request").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("InstanceType", instanceType()).add("SubnetId", subnetId())
                .add("ImageId", imageId()).add("AutomaticStopTimeMinutes", automaticStopTimeMinutes())
                .add("OwnerArn", ownerArn()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectionType", connectionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "automaticStopTimeMinutes":
            return Optional.ofNullable(clazz.cast(automaticStopTimeMinutes()));
        case "ownerArn":
            return Optional.ofNullable(clazz.cast(ownerArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "connectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentEc2Request, T> g) {
        return obj -> g.apply((CreateEnvironmentEc2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentEc2Request> {
        /**
         * <p>
         * The name of the environment to create.
         * </p>
         * <p>
         * This name is visible to other AWS IAM users in the same AWS account.
         * </p>
         * 
         * @param name
         *        The name of the environment to create.</p>
         *        <p>
         *        This name is visible to other AWS IAM users in the same AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the environment to create.
         * </p>
         * 
         * @param description
         *        The description of the environment to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one
         * time.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a>
         * in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than
         *        one time.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client
         *        Tokens</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The type of instance to connect to the environment (for example, <code>t2.micro</code>).
         * </p>
         * 
         * @param instanceType
         *        The type of instance to connect to the environment (for example, <code>t2.micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an AMI
         * for the instance, you must specify a valid AMI alias or a valid AWS Systems Manager (SSM) path.
         * </p>
         * <p>
         * The default AMI is used if the parameter isn't explicitly assigned a value in the request.
         * </p>
         * <p>
         * <b>AMI aliases </b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>SSM paths</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param imageId
         *        The identifier for the Amazon Machine Image (AMI) that's used to create the EC2 instance. To choose an
         *        AMI for the instance, you must specify a valid AMI alias or a valid AWS Systems Manager (SSM)
         *        path.</p>
         *        <p>
         *        The default AMI is used if the parameter isn't explicitly assigned a value in the request.
         *        </p>
         *        <p>
         *        <b>AMI aliases </b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Linux (default): <code>amazonlinux-1-x86_64</code> </b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Linux 2: <code>amazonlinux-2-x86_64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Ubuntu 18.04: <code>ubuntu-18.04-x86_64</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>SSM paths</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Linux (default): <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-1-x86_64</code> </b>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Linux 2: <code>resolve:ssm:/aws/service/cloud9/amis/amazonlinux-2-x86_64</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Ubuntu 18.04: <code>resolve:ssm:/aws/service/cloud9/amis/ubuntu-18.04-x86_64</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The number of minutes until the running instance is shut down after the environment has last been used.
         * </p>
         * 
         * @param automaticStopTimeMinutes
         *        The number of minutes until the running instance is shut down after the environment has last been
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM principal. If
         * this value is not specified, the ARN defaults to this environment's creator.
         * </p>
         * 
         * @param ownerArn
         *        The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM
         *        principal. If this value is not specified, the ARN defaults to this environment's creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerArn(String ownerArn);

        /**
         * <p>
         * An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that will be associated with the new AWS Cloud9 development environment.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The connection type used for connecting to an Amazon EC2 environment. Valid values are
         * <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances
         * with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
         * </p>
         * 
         * @param connectionType
         *        The connection type used for connecting to an Amazon EC2 environment. Valid values are
         *        <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems
         *        Manager).</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2
         *        instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The connection type used for connecting to an Amazon EC2 environment. Valid values are
         * <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems Manager).
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2 instances
         * with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
         * </p>
         * 
         * @param connectionType
         *        The connection type used for connecting to an Amazon EC2 environment. Valid values are
         *        <code>CONNECT_SSH</code> (default) and <code>CONNECT_SSM</code> (connected through AWS Systems
         *        Manager).</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloud9/latest/user-guide/ec2-ssm.html">Accessing no-ingress EC2
         *        instances with AWS Systems Manager</a> in the <i>AWS Cloud9 User Guide</i>.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Cloud9Request.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String clientRequestToken;

        private String instanceType;

        private String subnetId;

        private String imageId;

        private Integer automaticStopTimeMinutes;

        private String ownerArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentEc2Request model) {
            super(model);
            name(model.name);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
            instanceType(model.instanceType);
            subnetId(model.subnetId);
            imageId(model.imageId);
            automaticStopTimeMinutes(model.automaticStopTimeMinutes);
            ownerArn(model.ownerArn);
            tags(model.tags);
            connectionType(model.connectionType);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Integer getAutomaticStopTimeMinutes() {
            return automaticStopTimeMinutes;
        }

        @Override
        public final Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        public final void setAutomaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
        }

        public final String getOwnerArn() {
            return ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getConnectionType() {
            return connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentEc2Request build() {
            return new CreateEnvironmentEc2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
