/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentStatusResponse extends Cloud9Response implements
        ToCopyableBuilder<DescribeEnvironmentStatusResponse.Builder, DescribeEnvironmentStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DescribeEnvironmentStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(DescribeEnvironmentStatusResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MESSAGE_FIELD));

    private final String status;

    private final String message;

    private DescribeEnvironmentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.message = builder.message;
    }

    /**
     * <p>
     * The status of the environment. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>connecting</code>: The environment is connecting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code>: The environment is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The environment is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error</code>: The environment is in an error state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ready</code>: The environment is ready.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopped</code>: The environment is stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopping</code>: The environment is stopping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>connecting</code>: The environment is connecting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code>: The environment is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The environment is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error</code>: The environment is in an error state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ready</code>: The environment is ready.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopped</code>: The environment is stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopping</code>: The environment is stopping.
     *         </p>
     *         </li>
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the environment. Available values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>connecting</code>: The environment is connecting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>creating</code>: The environment is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The environment is being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error</code>: The environment is in an error state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ready</code>: The environment is ready.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopped</code>: The environment is stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopping</code>: The environment is stopping.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment. Available values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>connecting</code>: The environment is connecting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>creating</code>: The environment is being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The environment is being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error</code>: The environment is in an error state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ready</code>: The environment is ready.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopped</code>: The environment is stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopping</code>: The environment is stopping.
     *         </p>
     *         </li>
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Any informational message about the status of the environment.
     * </p>
     * 
     * @return Any informational message about the status of the environment.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentStatusResponse)) {
            return false;
        }
        DescribeEnvironmentStatusResponse other = (DescribeEnvironmentStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentStatusResponse").add("Status", statusAsString()).add("Message", message())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentStatusResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEnvironmentStatusResponse> {
        /**
         * <p>
         * The status of the environment. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>connecting</code>: The environment is connecting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code>: The environment is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The environment is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error</code>: The environment is in an error state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ready</code>: The environment is ready.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopped</code>: The environment is stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopping</code>: The environment is stopping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the environment. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>connecting</code>: The environment is connecting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code>: The environment is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The environment is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error</code>: The environment is in an error state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ready</code>: The environment is ready.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopped</code>: The environment is stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopping</code>: The environment is stopping.
         *        </p>
         *        </li>
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environment. Available values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>connecting</code>: The environment is connecting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>creating</code>: The environment is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The environment is being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error</code>: The environment is in an error state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ready</code>: The environment is ready.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopped</code>: The environment is stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopping</code>: The environment is stopping.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the environment. Available values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>connecting</code>: The environment is connecting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>creating</code>: The environment is being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The environment is being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error</code>: The environment is in an error state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ready</code>: The environment is ready.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopped</code>: The environment is stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopping</code>: The environment is stopping.
         *        </p>
         *        </li>
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * Any informational message about the status of the environment.
         * </p>
         * 
         * @param message
         *        Any informational message about the status of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl extends Cloud9Response.BuilderImpl implements Builder {
        private String status;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentStatusResponse model) {
            super(model);
            status(model.status);
            message(model.message);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public DescribeEnvironmentStatusResponse build() {
            return new DescribeEnvironmentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
