/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ManagedCredentialsStatus {
    ENABLED_ON_CREATE("ENABLED_ON_CREATE"),

    ENABLED_BY_OWNER("ENABLED_BY_OWNER"),

    DISABLED_BY_DEFAULT("DISABLED_BY_DEFAULT"),

    DISABLED_BY_OWNER("DISABLED_BY_OWNER"),

    DISABLED_BY_COLLABORATOR("DISABLED_BY_COLLABORATOR"),

    PENDING_REMOVAL_BY_COLLABORATOR("PENDING_REMOVAL_BY_COLLABORATOR"),

    PENDING_START_REMOVAL_BY_COLLABORATOR("PENDING_START_REMOVAL_BY_COLLABORATOR"),

    PENDING_REMOVAL_BY_OWNER("PENDING_REMOVAL_BY_OWNER"),

    PENDING_START_REMOVAL_BY_OWNER("PENDING_START_REMOVAL_BY_OWNER"),

    FAILED_REMOVAL_BY_COLLABORATOR("FAILED_REMOVAL_BY_COLLABORATOR"),

    FAILED_REMOVAL_BY_OWNER("FAILED_REMOVAL_BY_OWNER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ManagedCredentialsStatus> VALUE_MAP = EnumUtils.uniqueIndex(ManagedCredentialsStatus.class,
            ManagedCredentialsStatus::toString);

    private final String value;

    private ManagedCredentialsStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ManagedCredentialsStatus corresponding to the value
     */
    public static ManagedCredentialsStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ManagedCredentialsStatus}s
     */
    public static Set<ManagedCredentialsStatus> knownValues() {
        Set<ManagedCredentialsStatus> knownValues = EnumSet.allOf(ManagedCredentialsStatus.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
