/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the current creation or deletion lifecycle state of an Cloud9 development environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentLifecycle implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentLifecycle.Builder, EnvironmentLifecycle> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnvironmentLifecycle::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(EnvironmentLifecycle::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> FAILURE_RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureResource").getter(getter(EnvironmentLifecycle::failureResource))
            .setter(setter(Builder::failureResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REASON_FIELD,
            FAILURE_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("status", STATUS_FIELD);
                    put("reason", REASON_FIELD);
                    put("failureResource", FAILURE_RESOURCE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String reason;

    private final String failureResource;

    private EnvironmentLifecycle(BuilderImpl builder) {
        this.status = builder.status;
        this.reason = builder.reason;
        this.failureResource = builder.failureResource;
    }

    /**
     * <p>
     * The current creation or deletion lifecycle state of the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: The environment is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: The environment was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The environment failed to be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The environment is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code>: The environment failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current creation or deletion lifecycle state of the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: The environment is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: The environment was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The environment failed to be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The environment is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code>: The environment failed to delete.
     *         </p>
     *         </li>
     * @see EnvironmentLifecycleStatus
     */
    public final EnvironmentLifecycleStatus status() {
        return EnvironmentLifecycleStatus.fromValue(status);
    }

    /**
     * <p>
     * The current creation or deletion lifecycle state of the environment.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: The environment is in the process of being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATED</code>: The environment was successfully created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>: The environment failed to be created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: The environment is in the process of being deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code>: The environment failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current creation or deletion lifecycle state of the environment.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: The environment is in the process of being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATED</code>: The environment was successfully created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>: The environment failed to be created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: The environment is in the process of being deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code>: The environment failed to delete.
     *         </p>
     *         </li>
     * @see EnvironmentLifecycleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Any informational message about the lifecycle state of the environment.
     * </p>
     * 
     * @return Any informational message about the lifecycle state of the environment.
     */
    public final String reason() {
        return reason;
    }

    /**
     * <p>
     * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services resource.
     * </p>
     * 
     * @return If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
     *         resource.
     */
    public final String failureResource() {
        return failureResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(failureResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLifecycle)) {
            return false;
        }
        EnvironmentLifecycle other = (EnvironmentLifecycle) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(reason(), other.reason())
                && Objects.equals(failureResource(), other.failureResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentLifecycle").add("Status", statusAsString()).add("Reason", reason())
                .add("FailureResource", failureResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "failureResource":
            return Optional.ofNullable(clazz.cast(failureResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentLifecycle, T> g) {
        return obj -> g.apply((EnvironmentLifecycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentLifecycle> {
        /**
         * <p>
         * The current creation or deletion lifecycle state of the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: The environment is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: The environment was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The environment failed to be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The environment is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code>: The environment failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current creation or deletion lifecycle state of the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: The environment is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: The environment was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The environment failed to be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The environment is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code>: The environment failed to delete.
         *        </p>
         *        </li>
         * @see EnvironmentLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current creation or deletion lifecycle state of the environment.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: The environment is in the process of being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATED</code>: The environment was successfully created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>: The environment failed to be created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: The environment is in the process of being deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code>: The environment failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current creation or deletion lifecycle state of the environment.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: The environment is in the process of being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATED</code>: The environment was successfully created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>: The environment failed to be created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: The environment is in the process of being deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code>: The environment failed to delete.
         *        </p>
         *        </li>
         * @see EnvironmentLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentLifecycleStatus
         */
        Builder status(EnvironmentLifecycleStatus status);

        /**
         * <p>
         * Any informational message about the lifecycle state of the environment.
         * </p>
         * 
         * @param reason
         *        Any informational message about the lifecycle state of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
         * resource.
         * </p>
         * 
         * @param failureResource
         *        If the environment failed to delete, the Amazon Resource Name (ARN) of the related Amazon Web Services
         *        resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResource(String failureResource);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String reason;

        private String failureResource;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLifecycle model) {
            status(model.status);
            reason(model.reason);
            failureResource(model.failureResource);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentLifecycleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final String getFailureResource() {
            return failureResource;
        }

        public final void setFailureResource(String failureResource) {
            this.failureResource = failureResource;
        }

        @Override
        public final Builder failureResource(String failureResource) {
            this.failureResource = failureResource;
            return this;
        }

        @Override
        public EnvironmentLifecycle build() {
            return new EnvironmentLifecycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
