/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEnvironmentsResponse extends Cloud9Response implements
        ToCopyableBuilder<DescribeEnvironmentsResponse.Builder, DescribeEnvironmentsResponse> {
    private static final SdkField<List<Environment>> ENVIRONMENTS_FIELD = SdkField
            .<List<Environment>> builder(MarshallingType.LIST)
            .memberName("environments")
            .getter(getter(DescribeEnvironmentsResponse::environments))
            .setter(setter(Builder::environments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Environment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Environment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Environment> environments;

    private DescribeEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.environments = builder.environments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironments() {
        return environments != null && !(environments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the environments that are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironments} method.
     * </p>
     * 
     * @return Information about the environments that are returned.
     */
    public final List<Environment> environments() {
        return environments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironments() ? environments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEnvironmentsResponse)) {
            return false;
        }
        DescribeEnvironmentsResponse other = (DescribeEnvironmentsResponse) obj;
        return hasEnvironments() == other.hasEnvironments() && Objects.equals(environments(), other.environments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEnvironmentsResponse").add("Environments", hasEnvironments() ? environments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environments":
            return Optional.ofNullable(clazz.cast(environments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("environments", ENVIRONMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEnvironmentsResponse, T> g) {
        return obj -> g.apply((DescribeEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEnvironmentsResponse> {
        /**
         * <p>
         * Information about the environments that are returned.
         * </p>
         * 
         * @param environments
         *        Information about the environments that are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Collection<Environment> environments);

        /**
         * <p>
         * Information about the environments that are returned.
         * </p>
         * 
         * @param environments
         *        Information about the environments that are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environments(Environment... environments);

        /**
         * <p>
         * Information about the environments that are returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloud9.model.Environment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloud9.model.Environment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloud9.model.Environment.Builder#build()} is called immediately and
         * its result is passed to {@link #environments(List<Environment>)}.
         * 
         * @param environments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloud9.model.Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environments(java.util.Collection<Environment>)
         */
        Builder environments(Consumer<Environment.Builder>... environments);
    }

    static final class BuilderImpl extends Cloud9Response.BuilderImpl implements Builder {
        private List<Environment> environments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEnvironmentsResponse model) {
            super(model);
            environments(model.environments);
        }

        public final List<Environment.Builder> getEnvironments() {
            List<Environment.Builder> result = EnvironmentListCopier.copyToBuilder(this.environments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironments(Collection<Environment.BuilderImpl> environments) {
            this.environments = EnvironmentListCopier.copyFromBuilder(environments);
        }

        @Override
        public final Builder environments(Collection<Environment> environments) {
            this.environments = EnvironmentListCopier.copy(environments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Environment... environments) {
            environments(Arrays.asList(environments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environments(Consumer<Environment.Builder>... environments) {
            environments(Stream.of(environments).map(c -> Environment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEnvironmentsResponse build() {
            return new DescribeEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
