/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentEc2Request extends Cloud9Request implements
        ToCopyableBuilder<CreateEnvironmentEc2Request.Builder, CreateEnvironmentEc2Request> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final SdkField<Integer> AUTOMATIC_STOP_TIME_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(CreateEnvironmentEc2Request::automaticStopTimeMinutes))
            .setter(setter(Builder::automaticStopTimeMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automaticStopTimeMinutes").build())
            .build();

    private static final SdkField<String> OWNER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEnvironmentEc2Request::ownerArn)).setter(setter(Builder::ownerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, INSTANCE_TYPE_FIELD,
                    SUBNET_ID_FIELD, AUTOMATIC_STOP_TIME_MINUTES_FIELD, OWNER_ARN_FIELD));

    private final String name;

    private final String description;

    private final String clientRequestToken;

    private final String instanceType;

    private final String subnetId;

    private final Integer automaticStopTimeMinutes;

    private final String ownerArn;

    private CreateEnvironmentEc2Request(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.automaticStopTimeMinutes = builder.automaticStopTimeMinutes;
        this.ownerArn = builder.ownerArn;
    }

    /**
     * <p>
     * The name of the environment to create.
     * </p>
     * <p>
     * This name is visible to other AWS IAM users in the same AWS account.
     * </p>
     * 
     * @return The name of the environment to create.</p>
     *         <p>
     *         This name is visible to other AWS IAM users in the same AWS account.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the environment to create.
     * </p>
     * 
     * @return The description of the environment to create.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one time.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * 
     * @return A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one
     *         time.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client
     *         Tokens</a> in the <i>Amazon EC2 API Reference</i>.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The type of instance to connect to the environment (for example, <code>t2.micro</code>).
     * </p>
     * 
     * @return The type of instance to connect to the environment (for example, <code>t2.micro</code>).
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The number of minutes until the running instance is shut down after the environment has last been used.
     * </p>
     * 
     * @return The number of minutes until the running instance is shut down after the environment has last been used.
     */
    public Integer automaticStopTimeMinutes() {
        return automaticStopTimeMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM principal. If
     * this value is not specified, the ARN defaults to this environment's creator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM
     *         principal. If this value is not specified, the ARN defaults to this environment's creator.
     */
    public String ownerArn() {
        return ownerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(automaticStopTimeMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(ownerArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentEc2Request)) {
            return false;
        }
        CreateEnvironmentEc2Request other = (CreateEnvironmentEc2Request) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(automaticStopTimeMinutes(), other.automaticStopTimeMinutes())
                && Objects.equals(ownerArn(), other.ownerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEnvironmentEc2Request").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientRequestToken", clientRequestToken()).add("InstanceType", instanceType()).add("SubnetId", subnetId())
                .add("AutomaticStopTimeMinutes", automaticStopTimeMinutes()).add("OwnerArn", ownerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "automaticStopTimeMinutes":
            return Optional.ofNullable(clazz.cast(automaticStopTimeMinutes()));
        case "ownerArn":
            return Optional.ofNullable(clazz.cast(ownerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentEc2Request, T> g) {
        return obj -> g.apply((CreateEnvironmentEc2Request) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentEc2Request> {
        /**
         * <p>
         * The name of the environment to create.
         * </p>
         * <p>
         * This name is visible to other AWS IAM users in the same AWS account.
         * </p>
         * 
         * @param name
         *        The name of the environment to create.</p>
         *        <p>
         *        This name is visible to other AWS IAM users in the same AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the environment to create.
         * </p>
         * 
         * @param description
         *        The description of the environment to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than one
         * time.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client Tokens</a>
         * in the <i>Amazon EC2 API Reference</i>.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation completes no more than
         *        one time.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Client
         *        Tokens</a> in the <i>Amazon EC2 API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The type of instance to connect to the environment (for example, <code>t2.micro</code>).
         * </p>
         * 
         * @param instanceType
         *        The type of instance to connect to the environment (for example, <code>t2.micro</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2 instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate with the Amazon EC2
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The number of minutes until the running instance is shut down after the environment has last been used.
         * </p>
         * 
         * @param automaticStopTimeMinutes
         *        The number of minutes until the running instance is shut down after the environment has last been
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM principal. If
         * this value is not specified, the ARN defaults to this environment's creator.
         * </p>
         * 
         * @param ownerArn
         *        The Amazon Resource Name (ARN) of the environment owner. This ARN can be the ARN of any AWS IAM
         *        principal. If this value is not specified, the ARN defaults to this environment's creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerArn(String ownerArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Cloud9Request.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String clientRequestToken;

        private String instanceType;

        private String subnetId;

        private Integer automaticStopTimeMinutes;

        private String ownerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentEc2Request model) {
            super(model);
            name(model.name);
            description(model.description);
            clientRequestToken(model.clientRequestToken);
            instanceType(model.instanceType);
            subnetId(model.subnetId);
            automaticStopTimeMinutes(model.automaticStopTimeMinutes);
            ownerArn(model.ownerArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Integer getAutomaticStopTimeMinutes() {
            return automaticStopTimeMinutes;
        }

        @Override
        public final Builder automaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
            return this;
        }

        public final void setAutomaticStopTimeMinutes(Integer automaticStopTimeMinutes) {
            this.automaticStopTimeMinutes = automaticStopTimeMinutes;
        }

        public final String getOwnerArn() {
            return ownerArn;
        }

        @Override
        public final Builder ownerArn(String ownerArn) {
            this.ownerArn = ownerArn;
            return this;
        }

        public final void setOwnerArn(String ownerArn) {
            this.ownerArn = ownerArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentEc2Request build() {
            return new CreateEnvironmentEc2Request(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
