/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloud9.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentMembershipResponse extends Cloud9Response implements
        ToCopyableBuilder<CreateEnvironmentMembershipResponse.Builder, CreateEnvironmentMembershipResponse> {
    private static final SdkField<EnvironmentMember> MEMBERSHIP_FIELD = SdkField
            .<EnvironmentMember> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateEnvironmentMembershipResponse::membership)).setter(setter(Builder::membership))
            .constructor(EnvironmentMember::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membership").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_FIELD));

    private final EnvironmentMember membership;

    private CreateEnvironmentMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.membership = builder.membership;
    }

    /**
     * <p>
     * Information about the environment member that was added.
     * </p>
     * 
     * @return Information about the environment member that was added.
     */
    public EnvironmentMember membership() {
        return membership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(membership());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentMembershipResponse)) {
            return false;
        }
        CreateEnvironmentMembershipResponse other = (CreateEnvironmentMembershipResponse) obj;
        return Objects.equals(membership(), other.membership());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEnvironmentMembershipResponse").add("Membership", membership()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "membership":
            return Optional.ofNullable(clazz.cast(membership()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentMembershipResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Cloud9Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEnvironmentMembershipResponse> {
        /**
         * <p>
         * Information about the environment member that was added.
         * </p>
         * 
         * @param membership
         *        Information about the environment member that was added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membership(EnvironmentMember membership);

        /**
         * <p>
         * Information about the environment member that was added.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentMember.Builder} avoiding the need to
         * create one manually via {@link EnvironmentMember#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentMember.Builder#build()} is called immediately and its
         * result is passed to {@link #membership(EnvironmentMember)}.
         * 
         * @param membership
         *        a consumer that will call methods on {@link EnvironmentMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #membership(EnvironmentMember)
         */
        default Builder membership(Consumer<EnvironmentMember.Builder> membership) {
            return membership(EnvironmentMember.builder().applyMutation(membership).build());
        }
    }

    static final class BuilderImpl extends Cloud9Response.BuilderImpl implements Builder {
        private EnvironmentMember membership;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentMembershipResponse model) {
            super(model);
            membership(model.membership);
        }

        public final EnvironmentMember.Builder getMembership() {
            return membership != null ? membership.toBuilder() : null;
        }

        @Override
        public final Builder membership(EnvironmentMember membership) {
            this.membership = membership;
            return this;
        }

        public final void setMembership(EnvironmentMember.BuilderImpl membership) {
            this.membership = membership != null ? membership.build() : null;
        }

        @Override
        public CreateEnvironmentMembershipResponse build() {
            return new CreateEnvironmentMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
