/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourceRequest extends CloudControlRequest implements
        ToCopyableBuilder<DeleteResourceRequest.Builder, DeleteResourceRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(DeleteResourceRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(DeleteResourceRequest::typeVersionId))
            .setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DeleteResourceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteResourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(DeleteResourceRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, IDENTIFIER_FIELD));

    private final String typeName;

    private final String typeVersionId;

    private final String roleArn;

    private final String clientToken;

    private final String identifier;

    private DeleteResourceRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.identifier = builder.identifier;
    }

    /**
     * <p>
     * The name of the resource type.
     * </p>
     * 
     * @return The name of the resource type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * For private resource types, the type version to use in this resource operation. If you do not specify a resource
     * version, CloudFormation uses the default version.
     * </p>
     * 
     * @return For private resource types, the type version to use in this resource operation. If you do not specify a
     *         resource version, CloudFormation uses the default version.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use when
     * performing this resource operation. The role specified must have the permissions required for this operation. The
     * necessary permissions for each event handler are defined in the
     * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     * section of the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type
     * definition schema</a>.
     * </p>
     * <p>
     * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services
     * user credentials.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use
     *         when performing this resource operation. The role specified must have the permissions required for this
     *         operation. The necessary permissions for each event handler are defined in the
     *         <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     *         section of the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
     *         type definition schema</a>.</p>
     *         <p>
     *         If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
     *         Services user credentials.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     *         >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token to
     * ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between request
     * retries and new resource requests. You might retry a resource request to ensure that it was successfully
     * received.
     * </p>
     * <p>
     * A client token is valid for 36 hours once used. After that, a resource request with the same client token is
     * treated as a new request.
     * </p>
     * <p>
     * If you do not specify a client token, one is generated for inclusion in the request.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
     * >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
     * Guide</i>.
     * </p>
     * 
     * @return A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this
     *         token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish
     *         between request retries and new resource requests. You might retry a resource request to ensure that it
     *         was successfully received.</p>
     *         <p>
     *         A client token is valid for 36 hours once used. After that, a resource request with the same client token
     *         is treated as a new request.
     *         </p>
     *         <p>
     *         If you do not specify a client token, one is generated for inclusion in the request.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
     *         >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
     *         Guide</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier for the resource.
     * </p>
     * <p>
     * You can specify the primary identifier, or any secondary identifier defined for the resource type in its resource
     * schema. You can only specify one identifier. Primary identifiers can be specified as a string or JSON; secondary
     * identifiers must be specified as JSON.
     * </p>
     * <p>
     * For compound primary identifiers (that is, one that consists of multiple resource properties strung together), to
     * specify the primary identifier as a string, list the property values <i>in the order they are specified</i> in
     * the primary identifier definition, separated by <code>|</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
     * resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * 
     * @return The identifier for the resource.</p>
     *         <p>
     *         You can specify the primary identifier, or any secondary identifier defined for the resource type in its
     *         resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or
     *         JSON; secondary identifiers must be specified as JSON.
     *         </p>
     *         <p>
     *         For compound primary identifiers (that is, one that consists of multiple resource properties strung
     *         together), to specify the primary identifier as a string, list the property values <i>in the order they
     *         are specified</i> in the primary identifier definition, separated by <code>|</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
     *         resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     */
    public final String identifier() {
        return identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceRequest)) {
            return false;
        }
        DeleteResourceRequest other = (DeleteResourceRequest) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(identifier(), other.identifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourceRequest").add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("RoleArn", roleArn()).add("ClientToken", clientToken()).add("Identifier", identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceRequest, T> g) {
        return obj -> g.apply((DeleteResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourceRequest> {
        /**
         * <p>
         * The name of the resource type.
         * </p>
         * 
         * @param typeName
         *        The name of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * For private resource types, the type version to use in this resource operation. If you do not specify a
         * resource version, CloudFormation uses the default version.
         * </p>
         * 
         * @param typeVersionId
         *        For private resource types, the type version to use in this resource operation. If you do not specify
         *        a resource version, CloudFormation uses the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use when
         * performing this resource operation. The role specified must have the permissions required for this operation.
         * The necessary permissions for each event handler are defined in the
         * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         * section of the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
         * type definition schema</a>.
         * </p>
         * <p>
         * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         * Services user credentials.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to
         *        use when performing this resource operation. The role specified must have the permissions required for
         *        this operation. The necessary permissions for each event handler are defined in the
         *        <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         *        section of the <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >resource type definition schema</a>.</p>
         *        <p>
         *        If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         *        Services user credentials.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         *        >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique identifier to ensure the idempotency of the resource request. As a best practice, specify this token
         * to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately distinguish between
         * request retries and new resource requests. You might retry a resource request to ensure that it was
         * successfully received.
         * </p>
         * <p>
         * A client token is valid for 36 hours once used. After that, a resource request with the same client token is
         * treated as a new request.
         * </p>
         * <p>
         * If you do not specify a client token, one is generated for inclusion in the request.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
         * >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API User
         * Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier to ensure the idempotency of the resource request. As a best practice, specify
         *        this token to ensure idempotency, so that Amazon Web Services Cloud Control API can accurately
         *        distinguish between request retries and new resource requests. You might retry a resource request to
         *        ensure that it was successfully received.</p>
         *        <p>
         *        A client token is valid for 36 hours once used. After that, a resource request with the same client
         *        token is treated as a new request.
         *        </p>
         *        <p>
         *        If you do not specify a client token, one is generated for inclusion in the request.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-idempotency"
         *        >Ensuring resource operation requests are unique</a> in the <i>Amazon Web Services Cloud Control API
         *        User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier for the resource.
         * </p>
         * <p>
         * You can specify the primary identifier, or any secondary identifier defined for the resource type in its
         * resource schema. You can only specify one identifier. Primary identifiers can be specified as a string or
         * JSON; secondary identifiers must be specified as JSON.
         * </p>
         * <p>
         * For compound primary identifiers (that is, one that consists of multiple resource properties strung
         * together), to specify the primary identifier as a string, list the property values <i>in the order they are
         * specified</i> in the primary identifier definition, separated by <code>|</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
         * resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * </p>
         * 
         * @param identifier
         *        The identifier for the resource.</p>
         *        <p>
         *        You can specify the primary identifier, or any secondary identifier defined for the resource type in
         *        its resource schema. You can only specify one identifier. Primary identifiers can be specified as a
         *        string or JSON; secondary identifiers must be specified as JSON.
         *        </p>
         *        <p>
         *        For compound primary identifiers (that is, one that consists of multiple resource properties strung
         *        together), to specify the primary identifier as a string, list the property values <i>in the order
         *        they are specified</i> in the primary identifier definition, separated by <code>|</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html"
         *        >Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudControlRequest.BuilderImpl implements Builder {
        private String typeName;

        private String typeVersionId;

        private String roleArn;

        private String clientToken;

        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceRequest model) {
            super(model);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            identifier(model.identifier);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        @Transient
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourceRequest build() {
            return new DeleteResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
