/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesRequest extends CloudControlRequest implements
        ToCopyableBuilder<ListResourcesRequest.Builder, ListResourcesRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListResourcesRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(ListResourcesRequest::typeVersionId))
            .setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ListResourcesRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> RESOURCE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceModel").getter(getter(ListResourcesRequest::resourceModel))
            .setter(setter(Builder::resourceModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            TYPE_VERSION_ID_FIELD, ROLE_ARN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOURCE_MODEL_FIELD));

    private final String typeName;

    private final String typeVersionId;

    private final String roleArn;

    private final String nextToken;

    private final Integer maxResults;

    private final String resourceModel;

    private ListResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.roleArn = builder.roleArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resourceModel = builder.resourceModel;
    }

    /**
     * <p>
     * The name of the resource type.
     * </p>
     * 
     * @return The name of the resource type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * For private resource types, the type version to use in this resource operation. If you do not specify a resource
     * version, CloudFormation uses the default version.
     * </p>
     * 
     * @return For private resource types, the type version to use in this resource operation. If you do not specify a
     *         resource version, CloudFormation uses the default version.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use when
     * performing this resource operation. The role specified must have the permissions required for this operation. The
     * necessary permissions for each event handler are defined in the
     * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     * section of the <a
     * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource type
     * definition schema</a>.
     * </p>
     * <p>
     * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web Services
     * user credentials.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use
     *         when performing this resource operation. The role specified must have the permissions required for this
     *         operation. The necessary permissions for each event handler are defined in the
     *         <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
     *         section of the <a
     *         href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
     *         type definition schema</a>.</p>
     *         <p>
     *         If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
     *         Services user credentials.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
     *         >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * If the previous paginated request didn't return all of the remaining results, the response object's
     * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this action
     * again and assign that token to the request object's <code>NextToken</code> parameter. If there are no remaining
     * results, the previous response object's <code>NextToken</code> parameter is set to <code>null</code>.
     * </p>
     * 
     * @return If the previous paginated request didn't return all of the remaining results, the response object's
     *         <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
     *         action again and assign that token to the request object's <code>NextToken</code> parameter. If there are
     *         no remaining results, the previous response object's <code>NextToken</code> parameter is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * <p>
     * The default is <code>20</code>.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.</p>
     *         <p>
     *         The default is <code>20</code>.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The resource model to use to select the resources to return.
     * </p>
     * 
     * @return The resource model to use to select the resources to return.
     */
    public final String resourceModel() {
        return resourceModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(resourceModel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesRequest)) {
            return false;
        }
        ListResourcesRequest other = (ListResourcesRequest) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(resourceModel(), other.resourceModel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesRequest").add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("RoleArn", roleArn()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ResourceModel", resourceModel() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResourceModel":
            return Optional.ofNullable(clazz.cast(resourceModel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesRequest, T> g) {
        return obj -> g.apply((ListResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudControlRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesRequest> {
        /**
         * <p>
         * The name of the resource type.
         * </p>
         * 
         * @param typeName
         *        The name of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * For private resource types, the type version to use in this resource operation. If you do not specify a
         * resource version, CloudFormation uses the default version.
         * </p>
         * 
         * @param typeVersionId
         *        For private resource types, the type version to use in this resource operation. If you do not specify
         *        a resource version, CloudFormation uses the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to use when
         * performing this resource operation. The role specified must have the permissions required for this operation.
         * The necessary permissions for each event handler are defined in the
         * <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         * section of the <a
         * href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html">resource
         * type definition schema</a>.
         * </p>
         * <p>
         * If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         * Services user credentials.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         * >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) for Cloud Control API to
         *        use when performing this resource operation. The role specified must have the permissions required for
         *        this operation. The necessary permissions for each event handler are defined in the
         *        <code> <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-handlers">handlers</a> </code>
         *        section of the <a
         *        href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html"
         *        >resource type definition schema</a>.</p>
         *        <p>
         *        If you do not specify a role, Cloud Control API uses a temporary session created using your Amazon Web
         *        Services user credentials.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-operations.html#resource-operations-permissions"
         *        >Specifying credentials</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * If the previous paginated request didn't return all of the remaining results, the response object's
         * <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call this
         * action again and assign that token to the request object's <code>NextToken</code> parameter. If there are no
         * remaining results, the previous response object's <code>NextToken</code> parameter is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request didn't return all of the remaining results, the response object's
         *        <code>NextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        this action again and assign that token to the request object's <code>NextToken</code> parameter. If
         *        there are no remaining results, the previous response object's <code>NextToken</code> parameter is set
         *        to <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * <p>
         * The default is <code>20</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.</p>
         *        <p>
         *        The default is <code>20</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The resource model to use to select the resources to return.
         * </p>
         * 
         * @param resourceModel
         *        The resource model to use to select the resources to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceModel(String resourceModel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudControlRequest.BuilderImpl implements Builder {
        private String typeName;

        private String typeVersionId;

        private String roleArn;

        private String nextToken;

        private Integer maxResults;

        private String resourceModel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesRequest model) {
            super(model);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            roleArn(model.roleArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resourceModel(model.resourceModel);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        @Transient
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getResourceModel() {
            return resourceModel;
        }

        public final void setResourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
        }

        @Override
        @Transient
        public final Builder resourceModel(String resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourcesRequest build() {
            return new ListResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
