/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a provisioned resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDescription.Builder, ResourceDescription> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(ResourceDescription::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<String> PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Properties").getter(getter(ResourceDescription::properties)).setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String properties;

    private ResourceDescription(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The primary identifier for the resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
     * resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     * </p>
     * 
     * @return The primary identifier for the resource.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
     *         resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * A list of the resource properties and their current values.
     * </p>
     * 
     * @return A list of the resource properties and their current values.
     */
    public final String properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDescription)) {
            return false;
        }
        ResourceDescription other = (ResourceDescription) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDescription").add("Identifier", identifier())
                .add("Properties", properties() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDescription, T> g) {
        return obj -> g.apply((ResourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDescription> {
        /**
         * <p>
         * The primary identifier for the resource.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html">Identifying
         * resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * </p>
         * 
         * @param identifier
         *        The primary identifier for the resource.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/cloudcontrolapi/latest/userguide/resource-identifier.html"
         *        >Identifying resources</a> in the <i>Amazon Web Services Cloud Control API User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A list of the resource properties and their current values.
         * </p>
         * 
         * @param properties
         *        A list of the resource properties and their current values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(String properties);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String properties;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDescription model) {
            identifier(model.identifier);
            properties(model.properties);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getProperties() {
            return properties;
        }

        public final void setProperties(String properties) {
            this.properties = properties;
        }

        @Override
        @Transient
        public final Builder properties(String properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public ResourceDescription build() {
            return new ResourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
