/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourceResponse extends CloudControlResponse implements
        ToCopyableBuilder<DeleteResourceResponse.Builder, DeleteResourceResponse> {
    private static final SdkField<ProgressEvent> PROGRESS_EVENT_FIELD = SdkField
            .<ProgressEvent> builder(MarshallingType.SDK_POJO).memberName("ProgressEvent")
            .getter(getter(DeleteResourceResponse::progressEvent)).setter(setter(Builder::progressEvent))
            .constructor(ProgressEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_EVENT_FIELD));

    private final ProgressEvent progressEvent;

    private DeleteResourceResponse(BuilderImpl builder) {
        super(builder);
        this.progressEvent = builder.progressEvent;
    }

    /**
     * <p>
     * Represents the current status of the resource deletion request.
     * </p>
     * <p>
     * After you have initiated a resource deletion request, you can monitor the progress of your request by calling <a
     * href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">
     * GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned by
     * <code>DeleteResource</code>.
     * </p>
     * 
     * @return Represents the current status of the resource deletion request.</p>
     *         <p>
     *         After you have initiated a resource deletion request, you can monitor the progress of your request by
     *         calling <a href=
     *         "https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html"
     *         >GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code>
     *         returned by <code>DeleteResource</code>.
     */
    public final ProgressEvent progressEvent() {
        return progressEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceResponse)) {
            return false;
        }
        DeleteResourceResponse other = (DeleteResourceResponse) obj;
        return Objects.equals(progressEvent(), other.progressEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourceResponse").add("ProgressEvent", progressEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressEvent":
            return Optional.ofNullable(clazz.cast(progressEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceResponse, T> g) {
        return obj -> g.apply((DeleteResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteResourceResponse> {
        /**
         * <p>
         * Represents the current status of the resource deletion request.
         * </p>
         * <p>
         * After you have initiated a resource deletion request, you can monitor the progress of your request by calling
         * <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">
         * GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned
         * by <code>DeleteResource</code>.
         * </p>
         * 
         * @param progressEvent
         *        Represents the current status of the resource deletion request.</p>
         *        <p>
         *        After you have initiated a resource deletion request, you can monitor the progress of your request by
         *        calling <a href=
         *        "https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html"
         *        >GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code>
         *        returned by <code>DeleteResource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressEvent(ProgressEvent progressEvent);

        /**
         * <p>
         * Represents the current status of the resource deletion request.
         * </p>
         * <p>
         * After you have initiated a resource deletion request, you can monitor the progress of your request by calling
         * <a href="https://docs.aws.amazon.com/cloudcontrolapi/latest/APIReference/API_GetResourceRequestStatus.html">
         * GetResourceRequestStatus</a> using the <code>RequestToken</code> of the <code>ProgressEvent</code> returned
         * by <code>DeleteResource</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProgressEvent.Builder} avoiding the need
         * to create one manually via {@link ProgressEvent#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProgressEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #progressEvent(ProgressEvent)}.
         * 
         * @param progressEvent
         *        a consumer that will call methods on {@link ProgressEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #progressEvent(ProgressEvent)
         */
        default Builder progressEvent(Consumer<ProgressEvent.Builder> progressEvent) {
            return progressEvent(ProgressEvent.builder().applyMutation(progressEvent).build());
        }
    }

    static final class BuilderImpl extends CloudControlResponse.BuilderImpl implements Builder {
        private ProgressEvent progressEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceResponse model) {
            super(model);
            progressEvent(model.progressEvent);
        }

        public final ProgressEvent.Builder getProgressEvent() {
            return progressEvent != null ? progressEvent.toBuilder() : null;
        }

        public final void setProgressEvent(ProgressEvent.BuilderImpl progressEvent) {
            this.progressEvent = progressEvent != null ? progressEvent.build() : null;
        }

        @Override
        public final Builder progressEvent(ProgressEvent progressEvent) {
            this.progressEvent = progressEvent;
            return this;
        }

        @Override
        public DeleteResourceResponse build() {
            return new DeleteResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
