/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceResponse extends CloudControlResponse implements
        ToCopyableBuilder<GetResourceResponse.Builder, GetResourceResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(GetResourceResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<ResourceDescription> RESOURCE_DESCRIPTION_FIELD = SdkField
            .<ResourceDescription> builder(MarshallingType.SDK_POJO).memberName("ResourceDescription")
            .getter(getter(GetResourceResponse::resourceDescription)).setter(setter(Builder::resourceDescription))
            .constructor(ResourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            RESOURCE_DESCRIPTION_FIELD));

    private final String typeName;

    private final ResourceDescription resourceDescription;

    private GetResourceResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.resourceDescription = builder.resourceDescription;
    }

    /**
     * <p>
     * The name of the resource type.
     * </p>
     * 
     * @return The name of the resource type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * Returns the value of the ResourceDescription property for this object.
     * 
     * @return The value of the ResourceDescription property for this object.
     */
    public final ResourceDescription resourceDescription() {
        return resourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceResponse)) {
            return false;
        }
        GetResourceResponse other = (GetResourceResponse) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(resourceDescription(), other.resourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceResponse").add("TypeName", typeName())
                .add("ResourceDescription", resourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "ResourceDescription":
            return Optional.ofNullable(clazz.cast(resourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceResponse, T> g) {
        return obj -> g.apply((GetResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetResourceResponse> {
        /**
         * <p>
         * The name of the resource type.
         * </p>
         * 
         * @param typeName
         *        The name of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * Sets the value of the ResourceDescription property for this object.
         *
         * @param resourceDescription
         *        The new value for the ResourceDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDescription(ResourceDescription resourceDescription);

        /**
         * Sets the value of the ResourceDescription property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceDescription.Builder} avoiding the
         * need to create one manually via {@link ResourceDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceDescription(ResourceDescription)}.
         * 
         * @param resourceDescription
         *        a consumer that will call methods on {@link ResourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDescription(ResourceDescription)
         */
        default Builder resourceDescription(Consumer<ResourceDescription.Builder> resourceDescription) {
            return resourceDescription(ResourceDescription.builder().applyMutation(resourceDescription).build());
        }
    }

    static final class BuilderImpl extends CloudControlResponse.BuilderImpl implements Builder {
        private String typeName;

        private ResourceDescription resourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceResponse model) {
            super(model);
            typeName(model.typeName);
            resourceDescription(model.resourceDescription);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final ResourceDescription.Builder getResourceDescription() {
            return resourceDescription != null ? resourceDescription.toBuilder() : null;
        }

        public final void setResourceDescription(ResourceDescription.BuilderImpl resourceDescription) {
            this.resourceDescription = resourceDescription != null ? resourceDescription.build() : null;
        }

        @Override
        public final Builder resourceDescription(ResourceDescription resourceDescription) {
            this.resourceDescription = resourceDescription;
            return this;
        }

        @Override
        public GetResourceResponse build() {
            return new GetResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
