/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudcontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourcesResponse extends CloudControlResponse implements
        ToCopyableBuilder<ListResourcesResponse.Builder, ListResourcesResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListResourcesResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<List<ResourceDescription>> RESOURCE_DESCRIPTIONS_FIELD = SdkField
            .<List<ResourceDescription>> builder(MarshallingType.LIST)
            .memberName("ResourceDescriptions")
            .getter(getter(ListResourcesResponse::resourceDescriptions))
            .setter(setter(Builder::resourceDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            RESOURCE_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));

    private final String typeName;

    private final List<ResourceDescription> resourceDescriptions;

    private final String nextToken;

    private ListResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.resourceDescriptions = builder.resourceDescriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the resource type.
     * </p>
     * 
     * @return The name of the resource type.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceDescriptions() {
        return resourceDescriptions != null && !(resourceDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the specified resources, including primary identifier and resource model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceDescriptions} method.
     * </p>
     * 
     * @return Information about the specified resources, including primary identifier and resource model.
     */
    public final List<ResourceDescription> resourceDescriptions() {
        return resourceDescriptions;
    }

    /**
     * <p>
     * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call <code>ListResources</code> again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to null.
     * </p>
     * 
     * @return If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call <code>ListResources</code> again and assign that token to the
     *         request object's <code>NextToken</code> parameter. If the request returns all results,
     *         <code>NextToken</code> is set to null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceDescriptions() ? resourceDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesResponse)) {
            return false;
        }
        ListResourcesResponse other = (ListResourcesResponse) obj;
        return Objects.equals(typeName(), other.typeName()) && hasResourceDescriptions() == other.hasResourceDescriptions()
                && Objects.equals(resourceDescriptions(), other.resourceDescriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourcesResponse").add("TypeName", typeName())
                .add("ResourceDescriptions", hasResourceDescriptions() ? resourceDescriptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "ResourceDescriptions":
            return Optional.ofNullable(clazz.cast(resourceDescriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesResponse, T> g) {
        return obj -> g.apply((ListResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResourcesResponse> {
        /**
         * <p>
         * The name of the resource type.
         * </p>
         * 
         * @param typeName
         *        The name of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * Information about the specified resources, including primary identifier and resource model.
         * </p>
         * 
         * @param resourceDescriptions
         *        Information about the specified resources, including primary identifier and resource model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDescriptions(Collection<ResourceDescription> resourceDescriptions);

        /**
         * <p>
         * Information about the specified resources, including primary identifier and resource model.
         * </p>
         * 
         * @param resourceDescriptions
         *        Information about the specified resources, including primary identifier and resource model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceDescriptions(ResourceDescription... resourceDescriptions);

        /**
         * <p>
         * Information about the specified resources, including primary identifier and resource model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceDescriptions(List<ResourceDescription>)}.
         * 
         * @param resourceDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudcontrol.model.ResourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceDescriptions(java.util.Collection<ResourceDescription>)
         */
        Builder resourceDescriptions(Consumer<ResourceDescription.Builder>... resourceDescriptions);

        /**
         * <p>
         * If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call <code>ListResources</code> again and assign that token to the request
         * object's <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set
         * to null.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all of the remaining results, <code>NextToken</code> is set to a token.
         *        To retrieve the next set of results, call <code>ListResources</code> again and assign that token to
         *        the request object's <code>NextToken</code> parameter. If the request returns all results,
         *        <code>NextToken</code> is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudControlResponse.BuilderImpl implements Builder {
        private String typeName;

        private List<ResourceDescription> resourceDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesResponse model) {
            super(model);
            typeName(model.typeName);
            resourceDescriptions(model.resourceDescriptions);
            nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final List<ResourceDescription.Builder> getResourceDescriptions() {
            List<ResourceDescription.Builder> result = ResourceDescriptionsCopier.copyToBuilder(this.resourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDescriptions(Collection<ResourceDescription.BuilderImpl> resourceDescriptions) {
            this.resourceDescriptions = ResourceDescriptionsCopier.copyFromBuilder(resourceDescriptions);
        }

        @Override
        public final Builder resourceDescriptions(Collection<ResourceDescription> resourceDescriptions) {
            this.resourceDescriptions = ResourceDescriptionsCopier.copy(resourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDescriptions(ResourceDescription... resourceDescriptions) {
            resourceDescriptions(Arrays.asList(resourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDescriptions(Consumer<ResourceDescription.Builder>... resourceDescriptions) {
            resourceDescriptions(Stream.of(resourceDescriptions).map(c -> ResourceDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourcesResponse build() {
            return new ListResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
