/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudcontrol;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudcontrol.CloudControlClient;
import software.amazon.awssdk.services.cloudcontrol.CloudControlServiceClientConfiguration;
import software.amazon.awssdk.services.cloudcontrol.internal.CloudControlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudcontrol.model.AlreadyExistsException;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CancelResourceRequestResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ClientTokenConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.CloudControlException;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudcontrol.model.ConcurrentOperationException;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.CreateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.DeleteResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GeneralServiceException;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusRequest;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceRequestStatusResponse;
import software.amazon.awssdk.services.cloudcontrol.model.GetResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.HandlerInternalFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidCredentialsException;
import software.amazon.awssdk.services.cloudcontrol.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourceRequestsResponse;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesRequest;
import software.amazon.awssdk.services.cloudcontrol.model.ListResourcesResponse;
import software.amazon.awssdk.services.cloudcontrol.model.NetworkFailureException;
import software.amazon.awssdk.services.cloudcontrol.model.NotStabilizedException;
import software.amazon.awssdk.services.cloudcontrol.model.NotUpdatableException;
import software.amazon.awssdk.services.cloudcontrol.model.PrivateTypeException;
import software.amazon.awssdk.services.cloudcontrol.model.RequestTokenNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceConflictException;
import software.amazon.awssdk.services.cloudcontrol.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceInternalErrorException;
import software.amazon.awssdk.services.cloudcontrol.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.cloudcontrol.model.ThrottlingException;
import software.amazon.awssdk.services.cloudcontrol.model.TypeNotFoundException;
import software.amazon.awssdk.services.cloudcontrol.model.UnsupportedActionException;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceRequest;
import software.amazon.awssdk.services.cloudcontrol.model.UpdateResourceResponse;
import software.amazon.awssdk.services.cloudcontrol.transform.CancelResourceRequestRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.GetResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.GetResourceRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.ListResourceRequestsRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudcontrol.waiters.CloudControlWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudControlClient
implements CloudControlClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudControlClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudControlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudControl#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelResourceRequestResponse cancelResourceRequest(CancelResourceRequestRequest cancelResourceRequestRequest) throws ConcurrentModificationException, RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelResourceRequestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelResourceRequestRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, cancelResourceRequestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelResourceRequest");
            CancelResourceRequestResponse cancelResourceRequestResponse = (CancelResourceRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelResourceRequest").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelResourceRequestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelResourceRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelResourceRequestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$cancelResourceRequest$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, createResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateResource");
            CreateResourceResponse createResourceResponse = (CreateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$createResource$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, deleteResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResource");
            DeleteResourceResponse deleteResourceResponse = (DeleteResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$deleteResource$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceResponse getResource(GetResourceRequest getResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, getResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResource");
            GetResourceResponse getResourceResponse = (GetResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$getResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceRequestStatusResponse getResourceRequestStatus(GetResourceRequestStatusRequest getResourceRequestStatusRequest) throws RequestTokenNotFoundException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourceRequestStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourceRequestStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, getResourceRequestStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourceRequestStatus");
            GetResourceRequestStatusResponse getResourceRequestStatusResponse = (GetResourceRequestStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourceRequestStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourceRequestStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourceRequestStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourceRequestStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$getResourceRequestStatus$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceRequestsResponse listResourceRequests(ListResourceRequestsRequest listResourceRequestsRequest) throws AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceRequestsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourceRequestsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, listResourceRequestsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceRequests");
            ListResourceRequestsResponse listResourceRequestsResponse = (ListResourceRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceRequests").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourceRequestsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourceRequestsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$listResourceRequests$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, listResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResources");
            ListResourcesResponse listResourcesResponse = (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$listResources$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws AlreadyExistsException, HandlerInternalFailureException, GeneralServiceException, NotUpdatableException, TypeNotFoundException, ConcurrentOperationException, InvalidRequestException, PrivateTypeException, ResourceNotFoundException, NetworkFailureException, UnsupportedActionException, NotStabilizedException, ServiceInternalErrorException, HandlerFailureException, ServiceLimitExceededException, InvalidCredentialsException, ResourceConflictException, ClientTokenConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudControlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "HandlerFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerFailureException::builder).build());
                }
                case "HandlerInternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HandlerInternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(HandlerInternalFailureException::builder).build());
                }
                case "ServiceLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceLimitExceededException::builder).build());
                }
                case "ServiceInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServiceInternalErrorException::builder).build());
                }
                case "PrivateTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("PrivateTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(PrivateTypeException::builder).build());
                }
                case "RequestTokenNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTokenNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestTokenNotFoundException::builder).build());
                }
                case "ClientTokenConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientTokenConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientTokenConflictException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "NetworkFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NetworkFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(NetworkFailureException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "AlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyExistsException::builder).build());
                }
                case "ConcurrentOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentOperationException::builder).build());
                }
                case "UnsupportedActionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedActionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedActionException::builder).build());
                }
                case "NotStabilizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotStabilizedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotStabilizedException::builder).build());
                }
                case "ResourceConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                }
                case "InvalidCredentialsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCredentialsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCredentialsException::builder).build());
                }
                case "GeneralServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GeneralServiceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GeneralServiceException::builder).build());
                }
                case "TypeNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TypeNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TypeNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "NotUpdatableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotUpdatableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotUpdatableException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudControlClient.resolveMetricPublishers(clientConfiguration, updateResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudControl");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateResource");
            UpdateResourceResponse updateResourceResponse = (UpdateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudControlClient.lambda$updateResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public CloudControlWaiter waiter() {
        return CloudControlWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "cloudcontrolapi";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudControlServiceClientConfigurationBuilder serviceConfigBuilder = new CloudControlServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudControlException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final CloudControlServiceClientConfiguration serviceClientConfiguration() {
        return new CloudControlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResources$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listResourceRequests$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourceRequestStatus$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResource$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createResource$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelResourceRequest$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

