/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAttachTypedLink
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchAttachTypedLink> {
    private static final SdkField<ObjectReference> SOURCE_OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchAttachTypedLink.getter(BatchAttachTypedLink::sourceObjectReference)).setter(BatchAttachTypedLink.setter(Builder::sourceObjectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObjectReference").build()}).build();
    private static final SdkField<ObjectReference> TARGET_OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchAttachTypedLink.getter(BatchAttachTypedLink::targetObjectReference)).setter(BatchAttachTypedLink.setter(Builder::targetObjectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectReference").build()}).build();
    private static final SdkField<TypedLinkSchemaAndFacetName> TYPED_LINK_FACET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchAttachTypedLink.getter(BatchAttachTypedLink::typedLinkFacet)).setter(BatchAttachTypedLink.setter(Builder::typedLinkFacet)).constructor(TypedLinkSchemaAndFacetName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkFacet").build()}).build();
    private static final SdkField<List<AttributeNameAndValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchAttachTypedLink.getter(BatchAttachTypedLink::attributes)).setter(BatchAttachTypedLink.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeNameAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_OBJECT_REFERENCE_FIELD, TARGET_OBJECT_REFERENCE_FIELD, TYPED_LINK_FACET_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference sourceObjectReference;
    private final ObjectReference targetObjectReference;
    private final TypedLinkSchemaAndFacetName typedLinkFacet;
    private final List<AttributeNameAndValue> attributes;

    private BatchAttachTypedLink(BuilderImpl builder) {
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.typedLinkFacet = builder.typedLinkFacet;
        this.attributes = builder.attributes;
    }

    public ObjectReference sourceObjectReference() {
        return this.sourceObjectReference;
    }

    public ObjectReference targetObjectReference() {
        return this.targetObjectReference;
    }

    public TypedLinkSchemaAndFacetName typedLinkFacet() {
        return this.typedLinkFacet;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<AttributeNameAndValue> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachTypedLink)) {
            return false;
        }
        BatchAttachTypedLink other = (BatchAttachTypedLink)obj;
        return Objects.equals(this.sourceObjectReference(), other.sourceObjectReference()) && Objects.equals(this.targetObjectReference(), other.targetObjectReference()) && Objects.equals(this.typedLinkFacet(), other.typedLinkFacet()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"BatchAttachTypedLink").add("SourceObjectReference", (Object)this.sourceObjectReference()).add("TargetObjectReference", (Object)this.targetObjectReference()).add("TypedLinkFacet", (Object)this.typedLinkFacet()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceObjectReference": {
                return Optional.ofNullable(clazz.cast(this.sourceObjectReference()));
            }
            case "TargetObjectReference": {
                return Optional.ofNullable(clazz.cast(this.targetObjectReference()));
            }
            case "TypedLinkFacet": {
                return Optional.ofNullable(clazz.cast(this.typedLinkFacet()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachTypedLink, T> g) {
        return obj -> g.apply((BatchAttachTypedLink)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference sourceObjectReference;
        private ObjectReference targetObjectReference;
        private TypedLinkSchemaAndFacetName typedLinkFacet;
        private List<AttributeNameAndValue> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachTypedLink model) {
            this.sourceObjectReference(model.sourceObjectReference);
            this.targetObjectReference(model.targetObjectReference);
            this.typedLinkFacet(model.typedLinkFacet);
            this.attributes(model.attributes);
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return this.sourceObjectReference != null ? this.sourceObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return this.targetObjectReference != null ? this.targetObjectReference.toBuilder() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return this.typedLinkFacet != null ? this.typedLinkFacet.toBuilder() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        public final Collection<AttributeNameAndValue.Builder> getAttributes() {
            return this.attributes != null ? (Collection)this.attributes.stream().map(AttributeNameAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AttributeNameAndValue> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AttributeNameAndValue ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AttributeNameAndValue.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (AttributeNameAndValue)((AttributeNameAndValue.Builder)AttributeNameAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AttributeNameAndValue.BuilderImpl> attributes) {
            this.attributes = AttributeNameAndValueListCopier.copyFromBuilder(attributes);
        }

        public BatchAttachTypedLink build() {
            return new BatchAttachTypedLink(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchAttachTypedLink> {
        public Builder sourceObjectReference(ObjectReference var1);

        default public Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return this.sourceObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(sourceObjectReference)).build());
        }

        public Builder targetObjectReference(ObjectReference var1);

        default public Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return this.targetObjectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(targetObjectReference)).build());
        }

        public Builder typedLinkFacet(TypedLinkSchemaAndFacetName var1);

        default public Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return this.typedLinkFacet((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().applyMutation(typedLinkFacet)).build());
        }

        public Builder attributes(Collection<AttributeNameAndValue> var1);

        public Builder attributes(AttributeNameAndValue ... var1);

        public Builder attributes(Consumer<AttributeNameAndValue.Builder> ... var1);
    }
}

