/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttribute;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.FacetStyle;
import software.amazon.awssdk.services.clouddirectory.model.ObjectType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaArn").getter(CreateFacetRequest.getter(CreateFacetRequest::schemaArn)).setter(CreateFacetRequest.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFacetRequest.getter(CreateFacetRequest::name)).setter(CreateFacetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<FacetAttribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(CreateFacetRequest.getter(CreateFacetRequest::attributes)).setter(CreateFacetRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FacetAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectType").getter(CreateFacetRequest.getter(CreateFacetRequest::objectTypeAsString)).setter(CreateFacetRequest.setter(Builder::objectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()}).build();
    private static final SdkField<String> FACET_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FacetStyle").getter(CreateFacetRequest.getter(CreateFacetRequest::facetStyleAsString)).setter(CreateFacetRequest.setter(Builder::facetStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD, ATTRIBUTES_FIELD, OBJECT_TYPE_FIELD, FACET_STYLE_FIELD));
    private final String schemaArn;
    private final String name;
    private final List<FacetAttribute> attributes;
    private final String objectType;
    private final String facetStyle;

    private CreateFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.objectType = builder.objectType;
        this.facetStyle = builder.facetStyle;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public List<FacetAttribute> attributes() {
        return this.attributes;
    }

    public ObjectType objectType() {
        return ObjectType.fromValue(this.objectType);
    }

    public String objectTypeAsString() {
        return this.objectType;
    }

    public FacetStyle facetStyle() {
        return FacetStyle.fromValue(this.facetStyle);
    }

    public String facetStyleAsString() {
        return this.facetStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetStyleAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFacetRequest)) {
            return false;
        }
        CreateFacetRequest other = (CreateFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.objectTypeAsString(), other.objectTypeAsString()) && Objects.equals(this.facetStyleAsString(), other.facetStyleAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateFacetRequest").add("SchemaArn", (Object)this.schemaArn()).add("Name", (Object)this.name()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ObjectType", (Object)this.objectTypeAsString()).add("FacetStyle", (Object)this.facetStyleAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ObjectType": {
                return Optional.ofNullable(clazz.cast(this.objectTypeAsString()));
            }
            case "FacetStyle": {
                return Optional.ofNullable(clazz.cast(this.facetStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFacetRequest, T> g) {
        return obj -> g.apply((CreateFacetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<FacetAttribute> attributes = DefaultSdkAutoConstructList.getInstance();
        private String objectType;
        private String facetStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFacetRequest model) {
            super(model);
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributes(model.attributes);
            this.objectType(model.objectType);
            this.facetStyle(model.facetStyle);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<FacetAttribute.Builder> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes != null ? (Collection)this.attributes.stream().map(FacetAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<FacetAttribute> attributes) {
            this.attributes = FacetAttributeListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FacetAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<FacetAttribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (FacetAttribute)((FacetAttribute.Builder)FacetAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<FacetAttribute.BuilderImpl> attributes) {
            this.attributes = FacetAttributeListCopier.copyFromBuilder(attributes);
        }

        public final String getObjectType() {
            return this.objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public final String getFacetStyle() {
            return this.facetStyle;
        }

        @Override
        public final Builder facetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
            return this;
        }

        @Override
        public final Builder facetStyle(FacetStyle facetStyle) {
            this.facetStyle(facetStyle == null ? null : facetStyle.toString());
            return this;
        }

        public final void setFacetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFacetRequest build() {
            return new CreateFacetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributes(Collection<FacetAttribute> var1);

        public Builder attributes(FacetAttribute ... var1);

        public Builder attributes(Consumer<FacetAttribute.Builder> ... var1);

        public Builder objectType(String var1);

        public Builder objectType(ObjectType var1);

        public Builder facetStyle(String var1);

        public Builder facetStyle(FacetStyle var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

