/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListObjectParentsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListObjectParentsResponse.Builder, BatchListObjectParentsResponse> {
    private static final SdkField<List<ObjectIdentifierAndLinkNameTuple>> PARENT_LINKS_FIELD = SdkField
            .<List<ObjectIdentifierAndLinkNameTuple>> builder(MarshallingType.LIST)
            .memberName("ParentLinks")
            .getter(getter(BatchListObjectParentsResponse::parentLinks))
            .setter(setter(Builder::parentLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectIdentifierAndLinkNameTuple> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectIdentifierAndLinkNameTuple::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListObjectParentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_LINKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ObjectIdentifierAndLinkNameTuple> parentLinks;

    private final String nextToken;

    private BatchListObjectParentsResponse(BuilderImpl builder) {
        this.parentLinks = builder.parentLinks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ParentLinks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParentLinks() {
        return parentLinks != null && !(parentLinks instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ParentLinks property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParentLinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the ParentLinks property for this object.
     */
    public final List<ObjectIdentifierAndLinkNameTuple> parentLinks() {
        return parentLinks;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasParentLinks() ? parentLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectParentsResponse)) {
            return false;
        }
        BatchListObjectParentsResponse other = (BatchListObjectParentsResponse) obj;
        return hasParentLinks() == other.hasParentLinks() && Objects.equals(parentLinks(), other.parentLinks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListObjectParentsResponse").add("ParentLinks", hasParentLinks() ? parentLinks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParentLinks":
            return Optional.ofNullable(clazz.cast(parentLinks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectParentsResponse, T> g) {
        return obj -> g.apply((BatchListObjectParentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListObjectParentsResponse> {
        /**
         * Sets the value of the ParentLinks property for this object.
         *
         * @param parentLinks
         *        The new value for the ParentLinks property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks);

        /**
         * Sets the value of the ParentLinks property for this object.
         *
         * @param parentLinks
         *        The new value for the ParentLinks property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentLinks(ObjectIdentifierAndLinkNameTuple... parentLinks);

        /**
         * Sets the value of the ParentLinks property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<ObjectIdentifierAndLinkNameTuple>.Builder}
         * avoiding the need to create one manually via {@link List<ObjectIdentifierAndLinkNameTuple>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectIdentifierAndLinkNameTuple>.Builder#build()} is called
         * immediately and its result is passed to {@link #parentLinks(List<ObjectIdentifierAndLinkNameTuple>)}.
         * 
         * @param parentLinks
         *        a consumer that will call methods on {@link List<ObjectIdentifierAndLinkNameTuple>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentLinks(List<ObjectIdentifierAndLinkNameTuple>)
         */
        Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder>... parentLinks);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<ObjectIdentifierAndLinkNameTuple> parentLinks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectParentsResponse model) {
            parentLinks(model.parentLinks);
            nextToken(model.nextToken);
        }

        public final List<ObjectIdentifierAndLinkNameTuple.Builder> getParentLinks() {
            List<ObjectIdentifierAndLinkNameTuple.Builder> result = ObjectIdentifierAndLinkNameListCopier
                    .copyToBuilder(this.parentLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copy(parentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(ObjectIdentifierAndLinkNameTuple... parentLinks) {
            parentLinks(Arrays.asList(parentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder>... parentLinks) {
            parentLinks(Stream.of(parentLinks).map(c -> ObjectIdentifierAndLinkNameTuple.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParentLinks(Collection<ObjectIdentifierAndLinkNameTuple.BuilderImpl> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copyFromBuilder(parentLinks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public BatchListObjectParentsResponse build() {
            return new BatchListObjectParentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
