/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateObjectRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<CreateObjectRequest.Builder, CreateObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(CreateObjectRequest::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build())
            .build();

    private static final SdkField<List<SchemaFacet>> SCHEMA_FACETS_FIELD = SdkField
            .<List<SchemaFacet>> builder(MarshallingType.LIST)
            .memberName("SchemaFacets")
            .getter(getter(CreateObjectRequest::schemaFacets))
            .setter(setter(Builder::schemaFacets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaFacet> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaFacet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttributeKeyAndValue>> OBJECT_ATTRIBUTE_LIST_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("ObjectAttributeList")
            .getter(getter(CreateObjectRequest::objectAttributeList))
            .setter(setter(Builder::objectAttributeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ParentReference")
            .getter(getter(CreateObjectRequest::parentReference)).setter(setter(Builder::parentReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()).build();

    private static final SdkField<String> LINK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LinkName").getter(getter(CreateObjectRequest::linkName)).setter(setter(Builder::linkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD,
            SCHEMA_FACETS_FIELD, OBJECT_ATTRIBUTE_LIST_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD));

    private final String directoryArn;

    private final List<SchemaFacet> schemaFacets;

    private final List<AttributeKeyAndValue> objectAttributeList;

    private final ObjectReference parentReference;

    private final String linkName;

    private CreateObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacets = builder.schemaFacets;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> in which the object will be created.
     * For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> in which the object will be
     *         created. For more information, see <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * Returns true if the SchemaFacets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSchemaFacets() {
        return schemaFacets != null && !(schemaFacets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of schema facets to be associated with the object. Do not provide minor version components. See
     * <a>SchemaFacet</a> for details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemaFacets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of schema facets to be associated with the object. Do not provide minor version components. See
     *         <a>SchemaFacet</a> for details.
     */
    public final List<SchemaFacet> schemaFacets() {
        return schemaFacets;
    }

    /**
     * Returns true if the ObjectAttributeList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasObjectAttributeList() {
        return objectAttributeList != null && !(objectAttributeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attribute map whose attribute ARN contains the key and attribute value as the map value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectAttributeList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attribute map whose attribute ARN contains the key and attribute value as the map value.
     */
    public final List<AttributeKeyAndValue> objectAttributeList() {
        return objectAttributeList;
    }

    /**
     * <p>
     * If specified, the parent reference to which this object will be attached.
     * </p>
     * 
     * @return If specified, the parent reference to which this object will be attached.
     */
    public final ObjectReference parentReference() {
        return parentReference;
    }

    /**
     * <p>
     * The name of link that is used to attach this object to a parent.
     * </p>
     * 
     * @return The name of link that is used to attach this object to a parent.
     */
    public final String linkName() {
        return linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaFacets() ? schemaFacets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectAttributeList() ? objectAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(linkName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObjectRequest)) {
            return false;
        }
        CreateObjectRequest other = (CreateObjectRequest) obj;
        return Objects.equals(directoryArn(), other.directoryArn()) && hasSchemaFacets() == other.hasSchemaFacets()
                && Objects.equals(schemaFacets(), other.schemaFacets())
                && hasObjectAttributeList() == other.hasObjectAttributeList()
                && Objects.equals(objectAttributeList(), other.objectAttributeList())
                && Objects.equals(parentReference(), other.parentReference()) && Objects.equals(linkName(), other.linkName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateObjectRequest").add("DirectoryArn", directoryArn())
                .add("SchemaFacets", hasSchemaFacets() ? schemaFacets() : null)
                .add("ObjectAttributeList", hasObjectAttributeList() ? objectAttributeList() : null)
                .add("ParentReference", parentReference()).add("LinkName", linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "SchemaFacets":
            return Optional.ofNullable(clazz.cast(schemaFacets()));
        case "ObjectAttributeList":
            return Optional.ofNullable(clazz.cast(objectAttributeList()));
        case "ParentReference":
            return Optional.ofNullable(clazz.cast(parentReference()));
        case "LinkName":
            return Optional.ofNullable(clazz.cast(linkName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateObjectRequest, T> g) {
        return obj -> g.apply((CreateObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateObjectRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> in which the object will be
         * created. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the <a>Directory</a> in which the object will
         *        be created. For more information, see <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * A list of schema facets to be associated with the object. Do not provide minor version components. See
         * <a>SchemaFacet</a> for details.
         * </p>
         * 
         * @param schemaFacets
         *        A list of schema facets to be associated with the object. Do not provide minor version components. See
         *        <a>SchemaFacet</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacets(Collection<SchemaFacet> schemaFacets);

        /**
         * <p>
         * A list of schema facets to be associated with the object. Do not provide minor version components. See
         * <a>SchemaFacet</a> for details.
         * </p>
         * 
         * @param schemaFacets
         *        A list of schema facets to be associated with the object. Do not provide minor version components. See
         *        <a>SchemaFacet</a> for details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaFacets(SchemaFacet... schemaFacets);

        /**
         * <p>
         * A list of schema facets to be associated with the object. Do not provide minor version components. See
         * <a>SchemaFacet</a> for details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaFacet>.Builder} avoiding the need to
         * create one manually via {@link List<SchemaFacet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaFacet>.Builder#build()} is called immediately and its
         * result is passed to {@link #schemaFacets(List<SchemaFacet>)}.
         * 
         * @param schemaFacets
         *        a consumer that will call methods on {@link List<SchemaFacet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaFacets(List<SchemaFacet>)
         */
        Builder schemaFacets(Consumer<SchemaFacet.Builder>... schemaFacets);

        /**
         * <p>
         * The attribute map whose attribute ARN contains the key and attribute value as the map value.
         * </p>
         * 
         * @param objectAttributeList
         *        The attribute map whose attribute ARN contains the key and attribute value as the map value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList);

        /**
         * <p>
         * The attribute map whose attribute ARN contains the key and attribute value as the map value.
         * </p>
         * 
         * @param objectAttributeList
         *        The attribute map whose attribute ARN contains the key and attribute value as the map value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList);

        /**
         * <p>
         * The attribute map whose attribute ARN contains the key and attribute value as the map value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKeyAndValue>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeKeyAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKeyAndValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #objectAttributeList(List<AttributeKeyAndValue>)}.
         * 
         * @param objectAttributeList
         *        a consumer that will call methods on {@link List<AttributeKeyAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributeList(List<AttributeKeyAndValue>)
         */
        Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList);

        /**
         * <p>
         * If specified, the parent reference to which this object will be attached.
         * </p>
         * 
         * @param parentReference
         *        If specified, the parent reference to which this object will be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentReference(ObjectReference parentReference);

        /**
         * <p>
         * If specified, the parent reference to which this object will be attached.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectReference.Builder} avoiding the need to
         * create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #parentReference(ObjectReference)}.
         * 
         * @param parentReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parentReference(ObjectReference)
         */
        default Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return parentReference(ObjectReference.builder().applyMutation(parentReference).build());
        }

        /**
         * <p>
         * The name of link that is used to attach this object to a parent.
         * </p>
         * 
         * @param linkName
         *        The name of link that is used to attach this object to a parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkName(String linkName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String directoryArn;

        private List<SchemaFacet> schemaFacets = DefaultSdkAutoConstructList.getInstance();

        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();

        private ObjectReference parentReference;

        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateObjectRequest model) {
            super(model);
            directoryArn(model.directoryArn);
            schemaFacets(model.schemaFacets);
            objectAttributeList(model.objectAttributeList);
            parentReference(model.parentReference);
            linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final List<SchemaFacet.Builder> getSchemaFacets() {
            List<SchemaFacet.Builder> result = SchemaFacetListCopier.copyToBuilder(this.schemaFacets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet... schemaFacets) {
            schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(Consumer<SchemaFacet.Builder>... schemaFacets) {
            schemaFacets(Stream.of(schemaFacets).map(c -> SchemaFacet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaFacets(Collection<SchemaFacet.BuilderImpl> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copyFromBuilder(schemaFacets);
        }

        public final List<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            List<AttributeKeyAndValue.Builder> result = AttributeKeyAndValueListCopier.copyToBuilder(this.objectAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue... objectAttributeList) {
            objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder>... objectAttributeList) {
            objectAttributeList(Stream.of(objectAttributeList).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getParentReference() {
            return parentReference != null ? parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateObjectRequest build() {
            return new CreateObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
