/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFacetNamesResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListFacetNamesResponse.Builder, ListFacetNamesResponse> {
    private static final SdkField<List<String>> FACET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FacetNames")
            .getter(getter(ListFacetNamesResponse::facetNames))
            .setter(setter(Builder::facetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFacetNamesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FACET_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> facetNames;

    private final String nextToken;

    private ListFacetNamesResponse(BuilderImpl builder) {
        super(builder);
        this.facetNames = builder.facetNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FacetNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFacetNames() {
        return facetNames != null && !(facetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of facets that exist within the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFacetNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of facets that exist within the schema.
     */
    public final List<String> facetNames() {
        return facetNames;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFacetNames() ? facetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacetNamesResponse)) {
            return false;
        }
        ListFacetNamesResponse other = (ListFacetNamesResponse) obj;
        return hasFacetNames() == other.hasFacetNames() && Objects.equals(facetNames(), other.facetNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFacetNamesResponse").add("FacetNames", hasFacetNames() ? facetNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FacetNames":
            return Optional.ofNullable(clazz.cast(facetNames()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFacetNamesResponse, T> g) {
        return obj -> g.apply((ListFacetNamesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFacetNamesResponse> {
        /**
         * <p>
         * The names of facets that exist within the schema.
         * </p>
         * 
         * @param facetNames
         *        The names of facets that exist within the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetNames(Collection<String> facetNames);

        /**
         * <p>
         * The names of facets that exist within the schema.
         * </p>
         * 
         * @param facetNames
         *        The names of facets that exist within the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetNames(String... facetNames);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<String> facetNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacetNamesResponse model) {
            super(model);
            facetNames(model.facetNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFacetNames() {
            if (facetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return facetNames;
        }

        @Override
        public final Builder facetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetNames(String... facetNames) {
            facetNames(Arrays.asList(facetNames));
            return this;
        }

        public final void setFacetNames(Collection<String> facetNames) {
            this.facetNames = FacetNameListCopier.copy(facetNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFacetNamesResponse build() {
            return new ListFacetNamesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
