/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LookupPolicyResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<LookupPolicyResponse.Builder, LookupPolicyResponse> {
    private static final SdkField<List<PolicyToPath>> POLICY_TO_PATH_LIST_FIELD = SdkField
            .<List<PolicyToPath>> builder(MarshallingType.LIST)
            .memberName("PolicyToPathList")
            .getter(getter(LookupPolicyResponse::policyToPathList))
            .setter(setter(Builder::policyToPathList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyToPathList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyToPath> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyToPath::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(LookupPolicyResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TO_PATH_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PolicyToPath> policyToPathList;

    private final String nextToken;

    private LookupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyToPathList = builder.policyToPathList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PolicyToPathList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPolicyToPathList() {
        return policyToPathList != null && !(policyToPathList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
     * <code>PolicyType</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPolicyToPathList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>,
     *         and <code>PolicyType</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     */
    public final List<PolicyToPath> policyToPathList() {
        return policyToPathList;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyToPathList() ? policyToPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupPolicyResponse)) {
            return false;
        }
        LookupPolicyResponse other = (LookupPolicyResponse) obj;
        return hasPolicyToPathList() == other.hasPolicyToPathList()
                && Objects.equals(policyToPathList(), other.policyToPathList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LookupPolicyResponse")
                .add("PolicyToPathList", hasPolicyToPathList() ? policyToPathList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyToPathList":
            return Optional.ofNullable(clazz.cast(policyToPathList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LookupPolicyResponse, T> g) {
        return obj -> g.apply((LookupPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, LookupPolicyResponse> {
        /**
         * <p>
         * Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
         * <code>PolicyType</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * 
         * @param policyToPathList
         *        Provides list of path to policies. Policies contain <code>PolicyId</code>,
         *        <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyToPathList(Collection<PolicyToPath> policyToPathList);

        /**
         * <p>
         * Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
         * <code>PolicyType</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * 
         * @param policyToPathList
         *        Provides list of path to policies. Policies contain <code>PolicyId</code>,
         *        <code>ObjectIdentifier</code>, and <code>PolicyType</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyToPathList(PolicyToPath... policyToPathList);

        /**
         * <p>
         * Provides list of path to policies. Policies contain <code>PolicyId</code>, <code>ObjectIdentifier</code>, and
         * <code>PolicyType</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyToPath>.Builder} avoiding the need to
         * create one manually via {@link List<PolicyToPath>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyToPath>.Builder#build()} is called immediately and its
         * result is passed to {@link #policyToPathList(List<PolicyToPath>)}.
         * 
         * @param policyToPathList
         *        a consumer that will call methods on {@link List<PolicyToPath>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyToPathList(List<PolicyToPath>)
         */
        Builder policyToPathList(Consumer<PolicyToPath.Builder>... policyToPathList);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<PolicyToPath> policyToPathList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupPolicyResponse model) {
            super(model);
            policyToPathList(model.policyToPathList);
            nextToken(model.nextToken);
        }

        public final List<PolicyToPath.Builder> getPolicyToPathList() {
            List<PolicyToPath.Builder> result = PolicyToPathListCopier.copyToBuilder(this.policyToPathList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policyToPathList(Collection<PolicyToPath> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copy(policyToPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(PolicyToPath... policyToPathList) {
            policyToPathList(Arrays.asList(policyToPathList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(Consumer<PolicyToPath.Builder>... policyToPathList) {
            policyToPathList(Stream.of(policyToPathList).map(c -> PolicyToPath.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyToPathList(Collection<PolicyToPath.BuilderImpl> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copyFromBuilder(policyToPathList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public LookupPolicyResponse build() {
            return new LookupPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
