/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Directory structure that includes the directory name and directory ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Directory implements SdkPojo, Serializable, ToCopyableBuilder<Directory.Builder, Directory> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Directory::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(Directory::directoryArn)).setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Directory::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(Directory::creationDateTime)).setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DIRECTORY_ARN_FIELD, STATE_FIELD, CREATION_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String directoryArn;

    private final String state;

    private final Instant creationDateTime;

    private Directory(BuilderImpl builder) {
        this.name = builder.name;
        this.directoryArn = builder.directoryArn;
        this.state = builder.state;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The name of the directory.
     * </p>
     * 
     * @return The name of the directory.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <a>arns</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that is associated with the directory. For more information, see
     *         <a>arns</a>.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
     *         <code>Deleted</code>.
     * @see DirectoryState
     */
    public final DirectoryState state() {
        return DirectoryState.fromValue(state);
    }

    /**
     * <p>
     * The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or <code>Deleted</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
     *         <code>Deleted</code>.
     * @see DirectoryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when the directory was created.
     * </p>
     * 
     * @return The date and time when the directory was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Directory)) {
            return false;
        }
        Directory other = (Directory) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(directoryArn(), other.directoryArn())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Directory").add("Name", name()).add("DirectoryArn", directoryArn())
                .add("State", stateAsString()).add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Directory, T> g) {
        return obj -> g.apply((Directory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Directory> {
        /**
         * <p>
         * The name of the directory.
         * </p>
         * 
         * @param name
         *        The name of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that is associated with the directory. For more information, see <a>arns</a>.
         * </p>
         * 
         * @param directoryArn
         *        The Amazon Resource Name (ARN) that is associated with the directory. For more information, see
         *        <a>arns</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
         * <code>Deleted</code>.
         * </p>
         * 
         * @param state
         *        The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
         *        <code>Deleted</code>.
         * @see DirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
         * <code>Deleted</code>.
         * </p>
         * 
         * @param state
         *        The state of the directory. Can be either <code>Enabled</code>, <code>Disabled</code>, or
         *        <code>Deleted</code>.
         * @see DirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryState
         */
        Builder state(DirectoryState state);

        /**
         * <p>
         * The date and time when the directory was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time when the directory was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String directoryArn;

        private String state;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Directory model) {
            name(model.name);
            directoryArn(model.directoryArn);
            state(model.state);
            creationDateTime(model.creationDateTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DirectoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public Directory build() {
            return new Directory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
