/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains <code>Name</code>, <code>ARN</code>, <code>Attributes</code>, <code> <a>Rule</a>s</code>,
 * and <code>ObjectTypes</code>. See <a
 * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_whatarefacets.html">Facets</a> for
 * more information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Facet implements SdkPojo, Serializable, ToCopyableBuilder<Facet.Builder, Facet> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Facet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectType").getter(getter(Facet::objectTypeAsString)).setter(setter(Builder::objectType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectType").build()).build();

    private static final SdkField<String> FACET_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FacetStyle").getter(getter(Facet::facetStyleAsString)).setter(setter(Builder::facetStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetStyle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OBJECT_TYPE_FIELD,
            FACET_STYLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String objectType;

    private final String facetStyle;

    private Facet(BuilderImpl builder) {
        this.name = builder.name;
        this.objectType = builder.objectType;
        this.facetStyle = builder.facetStyle;
    }

    /**
     * <p>
     * The name of the <a>Facet</a>.
     * </p>
     * 
     * @return The name of the <a>Facet</a>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
     *         details.
     * @see ObjectType
     */
    public final ObjectType objectType() {
        return ObjectType.fromValue(objectType);
    }

    /**
     * <p>
     * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #objectType} will
     * return {@link ObjectType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #objectTypeAsString}.
     * </p>
     * 
     * @return The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
     *         details.
     * @see ObjectType
     */
    public final String objectTypeAsString() {
        return objectType;
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public final FacetStyle facetStyle() {
        return FacetStyle.fromValue(facetStyle);
    }

    /**
     * <p>
     * There are two different styles that you can define on any given facet, <code>Static</code> and
     * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
     * attributes can be defined during data plane operations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #facetStyle} will
     * return {@link FacetStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #facetStyleAsString}.
     * </p>
     * 
     * @return There are two different styles that you can define on any given facet, <code>Static</code> and
     *         <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
     *         facets, attributes can be defined during data plane operations.
     * @see FacetStyle
     */
    public final String facetStyleAsString() {
        return facetStyle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(facetStyleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(objectTypeAsString(), other.objectTypeAsString())
                && Objects.equals(facetStyleAsString(), other.facetStyleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Facet").add("Name", name()).add("ObjectType", objectTypeAsString())
                .add("FacetStyle", facetStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ObjectType":
            return Optional.ofNullable(clazz.cast(objectTypeAsString()));
        case "FacetStyle":
            return Optional.ofNullable(clazz.cast(facetStyleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Facet, T> g) {
        return obj -> g.apply((Facet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Facet> {
        /**
         * <p>
         * The name of the <a>Facet</a>.
         * </p>
         * 
         * @param name
         *        The name of the <a>Facet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
         * </p>
         * 
         * @param objectType
         *        The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
         *        details.
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(String objectType);

        /**
         * <p>
         * The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more details.
         * </p>
         * 
         * @param objectType
         *        The object type that is associated with the facet. See <a>CreateFacetRequest$ObjectType</a> for more
         *        details.
         * @see ObjectType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObjectType
         */
        Builder objectType(ObjectType objectType);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(String facetStyle);

        /**
         * <p>
         * There are two different styles that you can define on any given facet, <code>Static</code> and
         * <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic facets,
         * attributes can be defined during data plane operations.
         * </p>
         * 
         * @param facetStyle
         *        There are two different styles that you can define on any given facet, <code>Static</code> and
         *        <code>Dynamic</code>. For static facets, all attributes must be defined in the schema. For dynamic
         *        facets, attributes can be defined during data plane operations.
         * @see FacetStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FacetStyle
         */
        Builder facetStyle(FacetStyle facetStyle);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String objectType;

        private String facetStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(Facet model) {
            name(model.name);
            objectType(model.objectType);
            facetStyle(model.facetStyle);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getObjectType() {
            return objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        @Override
        public final Builder objectType(ObjectType objectType) {
            this.objectType(objectType == null ? null : objectType.toString());
            return this;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public final String getFacetStyle() {
            return facetStyle;
        }

        @Override
        public final Builder facetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
            return this;
        }

        @Override
        public final Builder facetStyle(FacetStyle facetStyle) {
            this.facetStyle(facetStyle == null ? null : facetStyle.toString());
            return this;
        }

        public final void setFacetStyle(String facetStyle) {
            this.facetStyle = facetStyle;
        }

        @Override
        public Facet build() {
            return new Facet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
