/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppliedSchemaArnsResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<ListAppliedSchemaArnsResponse.Builder, ListAppliedSchemaArnsResponse> {
    private static final SdkField<List<String>> SCHEMA_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SchemaArns")
            .getter(getter(ListAppliedSchemaArnsResponse::schemaArns))
            .setter(setter(Builder::schemaArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAppliedSchemaArnsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARNS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> schemaArns;

    private final String nextToken;

    private ListAppliedSchemaArnsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaArns = builder.schemaArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SchemaArns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSchemaArns() {
        return schemaArns != null && !(schemaArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of schemas that are applied to the directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSchemaArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ARNs of schemas that are applied to the directory.
     */
    public final List<String> schemaArns() {
        return schemaArns;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaArns() ? schemaArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppliedSchemaArnsResponse)) {
            return false;
        }
        ListAppliedSchemaArnsResponse other = (ListAppliedSchemaArnsResponse) obj;
        return hasSchemaArns() == other.hasSchemaArns() && Objects.equals(schemaArns(), other.schemaArns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppliedSchemaArnsResponse").add("SchemaArns", hasSchemaArns() ? schemaArns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArns":
            return Optional.ofNullable(clazz.cast(schemaArns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppliedSchemaArnsResponse, T> g) {
        return obj -> g.apply((ListAppliedSchemaArnsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppliedSchemaArnsResponse> {
        /**
         * <p>
         * The ARNs of schemas that are applied to the directory.
         * </p>
         * 
         * @param schemaArns
         *        The ARNs of schemas that are applied to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArns(Collection<String> schemaArns);

        /**
         * <p>
         * The ARNs of schemas that are applied to the directory.
         * </p>
         * 
         * @param schemaArns
         *        The ARNs of schemas that are applied to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArns(String... schemaArns);

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private List<String> schemaArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppliedSchemaArnsResponse model) {
            super(model);
            schemaArns(model.schemaArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getSchemaArns() {
            if (schemaArns instanceof SdkAutoConstructList) {
                return null;
            }
            return schemaArns;
        }

        @Override
        public final Builder schemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaArns(String... schemaArns) {
            schemaArns(Arrays.asList(schemaArns));
            return this;
        }

        public final void setSchemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppliedSchemaArnsResponse build() {
            return new ListAppliedSchemaArnsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
