/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectPoliciesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListObjectPoliciesResponse> {
    private static final SdkField<List<String>> ATTACHED_POLICY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachedPolicyIds").getter(ListObjectPoliciesResponse.getter(ListObjectPoliciesResponse::attachedPolicyIds)).setter(ListObjectPoliciesResponse.setter(Builder::attachedPolicyIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedPolicyIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectPoliciesResponse.getter(ListObjectPoliciesResponse::nextToken)).setter(ListObjectPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_POLICY_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> attachedPolicyIds;
    private final String nextToken;

    private ListObjectPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.attachedPolicyIds = builder.attachedPolicyIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAttachedPolicyIds() {
        return this.attachedPolicyIds != null && !(this.attachedPolicyIds instanceof SdkAutoConstructList);
    }

    public final List<String> attachedPolicyIds() {
        return this.attachedPolicyIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedPolicyIds() ? this.attachedPolicyIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectPoliciesResponse)) {
            return false;
        }
        ListObjectPoliciesResponse other = (ListObjectPoliciesResponse)((Object)obj);
        return this.hasAttachedPolicyIds() == other.hasAttachedPolicyIds() && Objects.equals(this.attachedPolicyIds(), other.attachedPolicyIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListObjectPoliciesResponse").add("AttachedPolicyIds", this.hasAttachedPolicyIds() ? this.attachedPolicyIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedPolicyIds": {
                return Optional.ofNullable(clazz.cast(this.attachedPolicyIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObjectPoliciesResponse, T> g) {
        return obj -> g.apply((ListObjectPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> attachedPolicyIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectPoliciesResponse model) {
            super(model);
            this.attachedPolicyIds(model.attachedPolicyIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAttachedPolicyIds() {
            if (this.attachedPolicyIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachedPolicyIds;
        }

        @Override
        public final Builder attachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedPolicyIds(String ... attachedPolicyIds) {
            this.attachedPolicyIds(Arrays.asList(attachedPolicyIds));
            return this;
        }

        public final void setAttachedPolicyIds(Collection<String> attachedPolicyIds) {
            this.attachedPolicyIds = ObjectIdentifierListCopier.copy(attachedPolicyIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListObjectPoliciesResponse build() {
            return new ListObjectPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectPoliciesResponse> {
        public Builder attachedPolicyIds(Collection<String> var1);

        public Builder attachedPolicyIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

