/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A unique identifier for an attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeKey implements SdkPojo, Serializable, ToCopyableBuilder<AttributeKey.Builder, AttributeKey> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(AttributeKey::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> FACET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FacetName").getter(getter(AttributeKey::facetName)).setter(setter(Builder::facetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AttributeKey::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD,
            FACET_NAME_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaArn;

    private final String facetName;

    private final String name;

    private AttributeKey(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.facetName = builder.facetName;
        this.name = builder.name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the facet that the attribute exists within.
     * </p>
     * 
     * @return The name of the facet that the attribute exists within.
     */
    public final String facetName() {
        return facetName;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * 
     * @return The name of the attribute.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(facetName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeKey)) {
            return false;
        }
        AttributeKey other = (AttributeKey) obj;
        return Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(facetName(), other.facetName())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeKey").add("SchemaArn", schemaArn()).add("FacetName", facetName()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "FacetName":
            return Optional.ofNullable(clazz.cast(facetName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeKey, T> g) {
        return obj -> g.apply((AttributeKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeKey> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.
         * </p>
         * 
         * @param schemaArn
         *        The Amazon Resource Name (ARN) of the schema that contains the facet and attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the facet that the attribute exists within.
         * </p>
         * 
         * @param facetName
         *        The name of the facet that the attribute exists within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetName(String facetName);

        /**
         * <p>
         * The name of the attribute.
         * </p>
         * 
         * @param name
         *        The name of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String schemaArn;

        private String facetName;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeKey model) {
            schemaArn(model.schemaArn);
            facetName(model.facetName);
            name(model.name);
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        @Transient
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getFacetName() {
            return facetName;
        }

        public final void setFacetName(String facetName) {
            this.facetName = facetName;
        }

        @Override
        @Transient
        public final Builder facetName(String facetName) {
            this.facetName = facetName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AttributeKey build() {
            return new AttributeKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
