/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output batch <a>AttachObject</a> response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAttachObjectResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchAttachObjectResponse.Builder, BatchAttachObjectResponse> {
    private static final SdkField<String> ATTACHED_OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachedObjectIdentifier").getter(getter(BatchAttachObjectResponse::attachedObjectIdentifier))
            .setter(setter(Builder::attachedObjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedObjectIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ATTACHED_OBJECT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attachedObjectIdentifier;

    private BatchAttachObjectResponse(BuilderImpl builder) {
        this.attachedObjectIdentifier = builder.attachedObjectIdentifier;
    }

    /**
     * <p>
     * The <code>ObjectIdentifier</code> of the object that has been attached.
     * </p>
     * 
     * @return The <code>ObjectIdentifier</code> of the object that has been attached.
     */
    public final String attachedObjectIdentifier() {
        return attachedObjectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachedObjectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObjectResponse)) {
            return false;
        }
        BatchAttachObjectResponse other = (BatchAttachObjectResponse) obj;
        return Objects.equals(attachedObjectIdentifier(), other.attachedObjectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAttachObjectResponse").add("AttachedObjectIdentifier", attachedObjectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachedObjectIdentifier":
            return Optional.ofNullable(clazz.cast(attachedObjectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachObjectResponse, T> g) {
        return obj -> g.apply((BatchAttachObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAttachObjectResponse> {
        /**
         * <p>
         * The <code>ObjectIdentifier</code> of the object that has been attached.
         * </p>
         * 
         * @param attachedObjectIdentifier
         *        The <code>ObjectIdentifier</code> of the object that has been attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedObjectIdentifier(String attachedObjectIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String attachedObjectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObjectResponse model) {
            attachedObjectIdentifier(model.attachedObjectIdentifier);
        }

        public final String getAttachedObjectIdentifier() {
            return attachedObjectIdentifier;
        }

        public final void setAttachedObjectIdentifier(String attachedObjectIdentifier) {
            this.attachedObjectIdentifier = attachedObjectIdentifier;
        }

        @Override
        @Transient
        public final Builder attachedObjectIdentifier(String attachedObjectIdentifier) {
            this.attachedObjectIdentifier = attachedObjectIdentifier;
            return this;
        }

        @Override
        public BatchAttachObjectResponse build() {
            return new BatchAttachObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
