/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information used to update an attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FacetAttributeUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<FacetAttributeUpdate.Builder, FacetAttributeUpdate> {
    private static final SdkField<FacetAttribute> ATTRIBUTE_FIELD = SdkField.<FacetAttribute> builder(MarshallingType.SDK_POJO)
            .memberName("Attribute").getter(getter(FacetAttributeUpdate::attribute)).setter(setter(Builder::attribute))
            .constructor(FacetAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(FacetAttributeUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FacetAttribute attribute;

    private final String action;

    private FacetAttributeUpdate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.action = builder.action;
    }

    /**
     * <p>
     * The attribute to update.
     * </p>
     * 
     * @return The attribute to update.
     */
    public final FacetAttribute attribute() {
        return attribute;
    }

    /**
     * <p>
     * The action to perform when updating the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when updating the attribute.
     * @see UpdateActionType
     */
    public final UpdateActionType action() {
        return UpdateActionType.fromValue(action);
    }

    /**
     * <p>
     * The action to perform when updating the attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link UpdateActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when updating the attribute.
     * @see UpdateActionType
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeUpdate)) {
            return false;
        }
        FacetAttributeUpdate other = (FacetAttributeUpdate) obj;
        return Objects.equals(attribute(), other.attribute()) && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FacetAttributeUpdate").add("Attribute", attribute()).add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetAttributeUpdate, T> g) {
        return obj -> g.apply((FacetAttributeUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FacetAttributeUpdate> {
        /**
         * <p>
         * The attribute to update.
         * </p>
         * 
         * @param attribute
         *        The attribute to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(FacetAttribute attribute);

        /**
         * <p>
         * The attribute to update.
         * </p>
         * This is a convenience that creates an instance of the {@link FacetAttribute.Builder} avoiding the need to
         * create one manually via {@link FacetAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link FacetAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #attribute(FacetAttribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link FacetAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(FacetAttribute)
         */
        default Builder attribute(Consumer<FacetAttribute.Builder> attribute) {
            return attribute(FacetAttribute.builder().applyMutation(attribute).build());
        }

        /**
         * <p>
         * The action to perform when updating the attribute.
         * </p>
         * 
         * @param action
         *        The action to perform when updating the attribute.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform when updating the attribute.
         * </p>
         * 
         * @param action
         *        The action to perform when updating the attribute.
         * @see UpdateActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionType
         */
        Builder action(UpdateActionType action);
    }

    static final class BuilderImpl implements Builder {
        private FacetAttribute attribute;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeUpdate model) {
            attribute(model.attribute);
            action(model.action);
        }

        public final FacetAttribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        public final void setAttribute(FacetAttribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        @Transient
        public final Builder attribute(FacetAttribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        @Transient
        public final Builder action(UpdateActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public FacetAttributeUpdate build() {
            return new FacetAttributeUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
