/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDirectoryResponse extends CloudDirectoryResponse implements
        ToCopyableBuilder<GetDirectoryResponse.Builder, GetDirectoryResponse> {
    private static final SdkField<Directory> DIRECTORY_FIELD = SdkField.<Directory> builder(MarshallingType.SDK_POJO)
            .memberName("Directory").getter(getter(GetDirectoryResponse::directory)).setter(setter(Builder::directory))
            .constructor(Directory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_FIELD));

    private final Directory directory;

    private GetDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.directory = builder.directory;
    }

    /**
     * <p>
     * Metadata about the directory.
     * </p>
     * 
     * @return Metadata about the directory.
     */
    public final Directory directory() {
        return directory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDirectoryResponse)) {
            return false;
        }
        GetDirectoryResponse other = (GetDirectoryResponse) obj;
        return Objects.equals(directory(), other.directory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDirectoryResponse").add("Directory", directory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Directory":
            return Optional.ofNullable(clazz.cast(directory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDirectoryResponse, T> g) {
        return obj -> g.apply((GetDirectoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDirectoryResponse> {
        /**
         * <p>
         * Metadata about the directory.
         * </p>
         * 
         * @param directory
         *        Metadata about the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directory(Directory directory);

        /**
         * <p>
         * Metadata about the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link Directory.Builder} avoiding the need to create
         * one manually via {@link Directory#builder()}.
         *
         * When the {@link Consumer} completes, {@link Directory.Builder#build()} is called immediately and its result
         * is passed to {@link #directory(Directory)}.
         * 
         * @param directory
         *        a consumer that will call methods on {@link Directory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directory(Directory)
         */
        default Builder directory(Consumer<Directory.Builder> directory) {
            return directory(Directory.builder().applyMutation(directory).build());
        }
    }

    static final class BuilderImpl extends CloudDirectoryResponse.BuilderImpl implements Builder {
        private Directory directory;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDirectoryResponse model) {
            super(model);
            directory(model.directory);
        }

        public final Directory.Builder getDirectory() {
            return directory != null ? directory.toBuilder() : null;
        }

        public final void setDirectory(Directory.BuilderImpl directory) {
            this.directory = directory != null ? directory.build() : null;
        }

        @Override
        @Transient
        public final Builder directory(Directory directory) {
            this.directory = directory;
            return this;
        }

        @Override
        public GetDirectoryResponse build() {
            return new GetDirectoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
