/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an index and an attached object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexAttachment implements SdkPojo, Serializable, ToCopyableBuilder<IndexAttachment.Builder, IndexAttachment> {
    private static final SdkField<List<AttributeKeyAndValue>> INDEXED_ATTRIBUTES_FIELD = SdkField
            .<List<AttributeKeyAndValue>> builder(MarshallingType.LIST)
            .memberName("IndexedAttributes")
            .getter(getter(IndexAttachment::indexedAttributes))
            .setter(setter(Builder::indexedAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeKeyAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeKeyAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectIdentifier").getter(getter(IndexAttachment::objectIdentifier))
            .setter(setter(Builder::objectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_ATTRIBUTES_FIELD,
            OBJECT_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AttributeKeyAndValue> indexedAttributes;

    private final String objectIdentifier;

    private IndexAttachment(BuilderImpl builder) {
        this.indexedAttributes = builder.indexedAttributes;
        this.objectIdentifier = builder.objectIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the IndexedAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIndexedAttributes() {
        return indexedAttributes != null && !(indexedAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The indexed attribute values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexedAttributes} method.
     * </p>
     * 
     * @return The indexed attribute values.
     */
    public final List<AttributeKeyAndValue> indexedAttributes() {
        return indexedAttributes;
    }

    /**
     * <p>
     * In response to <a>ListIndex</a>, the <code>ObjectIdentifier</code> of the object attached to the index. In
     * response to <a>ListAttachedIndices</a>, the <code>ObjectIdentifier</code> of the index attached to the object.
     * This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side of the
     * attachment specified in the query.
     * </p>
     * 
     * @return In response to <a>ListIndex</a>, the <code>ObjectIdentifier</code> of the object attached to the index.
     *         In response to <a>ListAttachedIndices</a>, the <code>ObjectIdentifier</code> of the index attached to the
     *         object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite
     *         side of the attachment specified in the query.
     */
    public final String objectIdentifier() {
        return objectIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexedAttributes() ? indexedAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(objectIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAttachment)) {
            return false;
        }
        IndexAttachment other = (IndexAttachment) obj;
        return hasIndexedAttributes() == other.hasIndexedAttributes()
                && Objects.equals(indexedAttributes(), other.indexedAttributes())
                && Objects.equals(objectIdentifier(), other.objectIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexAttachment").add("IndexedAttributes", hasIndexedAttributes() ? indexedAttributes() : null)
                .add("ObjectIdentifier", objectIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexedAttributes":
            return Optional.ofNullable(clazz.cast(indexedAttributes()));
        case "ObjectIdentifier":
            return Optional.ofNullable(clazz.cast(objectIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexAttachment, T> g) {
        return obj -> g.apply((IndexAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexAttachment> {
        /**
         * <p>
         * The indexed attribute values.
         * </p>
         * 
         * @param indexedAttributes
         *        The indexed attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes);

        /**
         * <p>
         * The indexed attribute values.
         * </p>
         * 
         * @param indexedAttributes
         *        The indexed attribute values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexedAttributes(AttributeKeyAndValue... indexedAttributes);

        /**
         * <p>
         * The indexed attribute values.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeKeyAndValue>.Builder} avoiding the
         * need to create one manually via {@link List<AttributeKeyAndValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeKeyAndValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #indexedAttributes(List<AttributeKeyAndValue>)}.
         * 
         * @param indexedAttributes
         *        a consumer that will call methods on {@link List<AttributeKeyAndValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexedAttributes(List<AttributeKeyAndValue>)
         */
        Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder>... indexedAttributes);

        /**
         * <p>
         * In response to <a>ListIndex</a>, the <code>ObjectIdentifier</code> of the object attached to the index. In
         * response to <a>ListAttachedIndices</a>, the <code>ObjectIdentifier</code> of the index attached to the
         * object. This field will always contain the <code>ObjectIdentifier</code> of the object on the opposite side
         * of the attachment specified in the query.
         * </p>
         * 
         * @param objectIdentifier
         *        In response to <a>ListIndex</a>, the <code>ObjectIdentifier</code> of the object attached to the
         *        index. In response to <a>ListAttachedIndices</a>, the <code>ObjectIdentifier</code> of the index
         *        attached to the object. This field will always contain the <code>ObjectIdentifier</code> of the object
         *        on the opposite side of the attachment specified in the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectIdentifier(String objectIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private List<AttributeKeyAndValue> indexedAttributes = DefaultSdkAutoConstructList.getInstance();

        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexAttachment model) {
            indexedAttributes(model.indexedAttributes);
            objectIdentifier(model.objectIdentifier);
        }

        public final List<AttributeKeyAndValue.Builder> getIndexedAttributes() {
            List<AttributeKeyAndValue.Builder> result = AttributeKeyAndValueListCopier.copyToBuilder(this.indexedAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexedAttributes(Collection<AttributeKeyAndValue.BuilderImpl> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copyFromBuilder(indexedAttributes);
        }

        @Override
        @Transient
        public final Builder indexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copy(indexedAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder indexedAttributes(AttributeKeyAndValue... indexedAttributes) {
            indexedAttributes(Arrays.asList(indexedAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder>... indexedAttributes) {
            indexedAttributes(Stream.of(indexedAttributes).map(c -> AttributeKeyAndValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getObjectIdentifier() {
            return objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        @Transient
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        @Override
        public IndexAttachment build() {
            return new IndexAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
