/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object inside a
 * <a>BatchRead</a> operation. For more information, see <a>ListOutgoingTypedLinks</a> and
 * <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchListOutgoingTypedLinks implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchListOutgoingTypedLinks.Builder, BatchListOutgoingTypedLinks> {
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(BatchListOutgoingTypedLinks::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final SdkField<List<TypedLinkAttributeRange>> FILTER_ATTRIBUTE_RANGES_FIELD = SdkField
            .<List<TypedLinkAttributeRange>> builder(MarshallingType.LIST)
            .memberName("FilterAttributeRanges")
            .getter(getter(BatchListOutgoingTypedLinks::filterAttributeRanges))
            .setter(setter(Builder::filterAttributeRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAttributeRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TypedLinkAttributeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(TypedLinkAttributeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TypedLinkSchemaAndFacetName> FILTER_TYPED_LINK_FIELD = SdkField
            .<TypedLinkSchemaAndFacetName> builder(MarshallingType.SDK_POJO).memberName("FilterTypedLink")
            .getter(getter(BatchListOutgoingTypedLinks::filterTypedLink)).setter(setter(Builder::filterTypedLink))
            .constructor(TypedLinkSchemaAndFacetName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterTypedLink").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(BatchListOutgoingTypedLinks::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(BatchListOutgoingTypedLinks::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_REFERENCE_FIELD,
            FILTER_ATTRIBUTE_RANGES_FIELD, FILTER_TYPED_LINK_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference objectReference;

    private final List<TypedLinkAttributeRange> filterAttributeRanges;

    private final TypedLinkSchemaAndFacetName filterTypedLink;

    private final String nextToken;

    private final Integer maxResults;

    private BatchListOutgoingTypedLinks(BuilderImpl builder) {
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The reference that identifies the object whose attributes will be listed.
     * </p>
     * 
     * @return The reference that identifies the object whose attributes will be listed.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterAttributeRanges property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFilterAttributeRanges() {
        return filterAttributeRanges != null && !(filterAttributeRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact ranges
     * must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire
     * range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterAttributeRanges} method.
     * </p>
     * 
     * @return Provides range filters for multiple attributes. When providing ranges to typed link selection, any
     *         inexact ranges must be specified at the end. Any attributes that do not have a range specified are
     *         presumed to match the entire range.
     */
    public final List<TypedLinkAttributeRange> filterAttributeRanges() {
        return filterAttributeRanges;
    }

    /**
     * <p>
     * Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they are
     * supplied to any API calls.
     * </p>
     * 
     * @return Filters are interpreted in the order of the attributes defined on the typed link facet, not the order
     *         they are supplied to any API calls.
     */
    public final TypedLinkSchemaAndFacetName filterTypedLink() {
        return filterTypedLink;
    }

    /**
     * <p>
     * The pagination token.
     * </p>
     * 
     * @return The pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to retrieve.
     * </p>
     * 
     * @return The maximum number of results to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterAttributeRanges() ? filterAttributeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListOutgoingTypedLinks)) {
            return false;
        }
        BatchListOutgoingTypedLinks other = (BatchListOutgoingTypedLinks) obj;
        return Objects.equals(objectReference(), other.objectReference())
                && hasFilterAttributeRanges() == other.hasFilterAttributeRanges()
                && Objects.equals(filterAttributeRanges(), other.filterAttributeRanges())
                && Objects.equals(filterTypedLink(), other.filterTypedLink()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchListOutgoingTypedLinks").add("ObjectReference", objectReference())
                .add("FilterAttributeRanges", hasFilterAttributeRanges() ? filterAttributeRanges() : null)
                .add("FilterTypedLink", filterTypedLink()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        case "FilterAttributeRanges":
            return Optional.ofNullable(clazz.cast(filterAttributeRanges()));
        case "FilterTypedLink":
            return Optional.ofNullable(clazz.cast(filterTypedLink()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListOutgoingTypedLinks, T> g) {
        return obj -> g.apply((BatchListOutgoingTypedLinks) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchListOutgoingTypedLinks> {
        /**
         * <p>
         * The reference that identifies the object whose attributes will be listed.
         * </p>
         * 
         * @param objectReference
         *        The reference that identifies the object whose attributes will be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * The reference that identifies the object whose attributes will be listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * 
         * @param filterAttributeRanges
         *        Provides range filters for multiple attributes. When providing ranges to typed link selection, any
         *        inexact ranges must be specified at the end. Any attributes that do not have a range specified are
         *        presumed to match the entire range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges);

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * 
         * @param filterAttributeRanges
         *        Provides range filters for multiple attributes. When providing ranges to typed link selection, any
         *        inexact ranges must be specified at the end. Any attributes that do not have a range specified are
         *        presumed to match the entire range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAttributeRanges(TypedLinkAttributeRange... filterAttributeRanges);

        /**
         * <p>
         * Provides range filters for multiple attributes. When providing ranges to typed link selection, any inexact
         * ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match
         * the entire range.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TypedLinkAttributeRange>.Builder}
         * avoiding the need to create one manually via {@link List<TypedLinkAttributeRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TypedLinkAttributeRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #filterAttributeRanges(List<TypedLinkAttributeRange>)}.
         * 
         * @param filterAttributeRanges
         *        a consumer that will call methods on {@link List<TypedLinkAttributeRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAttributeRanges(List<TypedLinkAttributeRange>)
         */
        Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder>... filterAttributeRanges);

        /**
         * <p>
         * Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they
         * are supplied to any API calls.
         * </p>
         * 
         * @param filterTypedLink
         *        Filters are interpreted in the order of the attributes defined on the typed link facet, not the order
         *        they are supplied to any API calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink);

        /**
         * <p>
         * Filters are interpreted in the order of the attributes defined on the typed link facet, not the order they
         * are supplied to any API calls.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedLinkSchemaAndFacetName.Builder}
         * avoiding the need to create one manually via {@link TypedLinkSchemaAndFacetName#builder()}.
         *
         * When the {@link Consumer} completes, {@link TypedLinkSchemaAndFacetName.Builder#build()} is called
         * immediately and its result is passed to {@link #filterTypedLink(TypedLinkSchemaAndFacetName)}.
         * 
         * @param filterTypedLink
         *        a consumer that will call methods on {@link TypedLinkSchemaAndFacetName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterTypedLink(TypedLinkSchemaAndFacetName)
         */
        default Builder filterTypedLink(Consumer<TypedLinkSchemaAndFacetName.Builder> filterTypedLink) {
            return filterTypedLink(TypedLinkSchemaAndFacetName.builder().applyMutation(filterTypedLink).build());
        }

        /**
         * <p>
         * The pagination token.
         * </p>
         * 
         * @param nextToken
         *        The pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference objectReference;

        private List<TypedLinkAttributeRange> filterAttributeRanges = DefaultSdkAutoConstructList.getInstance();

        private TypedLinkSchemaAndFacetName filterTypedLink;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListOutgoingTypedLinks model) {
            objectReference(model.objectReference);
            filterAttributeRanges(model.filterAttributeRanges);
            filterTypedLink(model.filterTypedLink);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final List<TypedLinkAttributeRange.Builder> getFilterAttributeRanges() {
            List<TypedLinkAttributeRange.Builder> result = TypedLinkAttributeRangeListCopier
                    .copyToBuilder(this.filterAttributeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange.BuilderImpl> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copyFromBuilder(filterAttributeRanges);
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange... filterAttributeRanges) {
            filterAttributeRanges(Arrays.asList(filterAttributeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder>... filterAttributeRanges) {
            filterAttributeRanges(Stream.of(filterAttributeRanges)
                    .map(c -> TypedLinkAttributeRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TypedLinkSchemaAndFacetName.Builder getFilterTypedLink() {
            return filterTypedLink != null ? filterTypedLink.toBuilder() : null;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName.BuilderImpl filterTypedLink) {
            this.filterTypedLink = filterTypedLink != null ? filterTypedLink.build() : null;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public BatchListOutgoingTypedLinks build() {
            return new BatchListOutgoingTypedLinks(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
