/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchRead</code> success response operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchReadSuccessfulResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchReadSuccessfulResponse.Builder, BatchReadSuccessfulResponse> {
    private static final SdkField<BatchListObjectAttributesResponse> LIST_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchListObjectAttributesResponse> builder(MarshallingType.SDK_POJO).memberName("ListObjectAttributes")
            .getter(getter(BatchReadSuccessfulResponse::listObjectAttributes)).setter(setter(Builder::listObjectAttributes))
            .constructor(BatchListObjectAttributesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectAttributes").build())
            .build();

    private static final SdkField<BatchListObjectChildrenResponse> LIST_OBJECT_CHILDREN_FIELD = SdkField
            .<BatchListObjectChildrenResponse> builder(MarshallingType.SDK_POJO).memberName("ListObjectChildren")
            .getter(getter(BatchReadSuccessfulResponse::listObjectChildren)).setter(setter(Builder::listObjectChildren))
            .constructor(BatchListObjectChildrenResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectChildren").build())
            .build();

    private static final SdkField<BatchGetObjectInformationResponse> GET_OBJECT_INFORMATION_FIELD = SdkField
            .<BatchGetObjectInformationResponse> builder(MarshallingType.SDK_POJO).memberName("GetObjectInformation")
            .getter(getter(BatchReadSuccessfulResponse::getObjectInformation)).setter(setter(Builder::getObjectInformation))
            .constructor(BatchGetObjectInformationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetObjectInformation").build())
            .build();

    private static final SdkField<BatchGetObjectAttributesResponse> GET_OBJECT_ATTRIBUTES_FIELD = SdkField
            .<BatchGetObjectAttributesResponse> builder(MarshallingType.SDK_POJO).memberName("GetObjectAttributes")
            .getter(getter(BatchReadSuccessfulResponse::getObjectAttributes)).setter(setter(Builder::getObjectAttributes))
            .constructor(BatchGetObjectAttributesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetObjectAttributes").build())
            .build();

    private static final SdkField<BatchListAttachedIndicesResponse> LIST_ATTACHED_INDICES_FIELD = SdkField
            .<BatchListAttachedIndicesResponse> builder(MarshallingType.SDK_POJO).memberName("ListAttachedIndices")
            .getter(getter(BatchReadSuccessfulResponse::listAttachedIndices)).setter(setter(Builder::listAttachedIndices))
            .constructor(BatchListAttachedIndicesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListAttachedIndices").build())
            .build();

    private static final SdkField<BatchListObjectParentPathsResponse> LIST_OBJECT_PARENT_PATHS_FIELD = SdkField
            .<BatchListObjectParentPathsResponse> builder(MarshallingType.SDK_POJO).memberName("ListObjectParentPaths")
            .getter(getter(BatchReadSuccessfulResponse::listObjectParentPaths)).setter(setter(Builder::listObjectParentPaths))
            .constructor(BatchListObjectParentPathsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectParentPaths").build())
            .build();

    private static final SdkField<BatchListObjectPoliciesResponse> LIST_OBJECT_POLICIES_FIELD = SdkField
            .<BatchListObjectPoliciesResponse> builder(MarshallingType.SDK_POJO).memberName("ListObjectPolicies")
            .getter(getter(BatchReadSuccessfulResponse::listObjectPolicies)).setter(setter(Builder::listObjectPolicies))
            .constructor(BatchListObjectPoliciesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectPolicies").build())
            .build();

    private static final SdkField<BatchListPolicyAttachmentsResponse> LIST_POLICY_ATTACHMENTS_FIELD = SdkField
            .<BatchListPolicyAttachmentsResponse> builder(MarshallingType.SDK_POJO).memberName("ListPolicyAttachments")
            .getter(getter(BatchReadSuccessfulResponse::listPolicyAttachments)).setter(setter(Builder::listPolicyAttachments))
            .constructor(BatchListPolicyAttachmentsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListPolicyAttachments").build())
            .build();

    private static final SdkField<BatchLookupPolicyResponse> LOOKUP_POLICY_FIELD = SdkField
            .<BatchLookupPolicyResponse> builder(MarshallingType.SDK_POJO).memberName("LookupPolicy")
            .getter(getter(BatchReadSuccessfulResponse::lookupPolicy)).setter(setter(Builder::lookupPolicy))
            .constructor(BatchLookupPolicyResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookupPolicy").build()).build();

    private static final SdkField<BatchListIndexResponse> LIST_INDEX_FIELD = SdkField
            .<BatchListIndexResponse> builder(MarshallingType.SDK_POJO).memberName("ListIndex")
            .getter(getter(BatchReadSuccessfulResponse::listIndex)).setter(setter(Builder::listIndex))
            .constructor(BatchListIndexResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListIndex").build()).build();

    private static final SdkField<BatchListOutgoingTypedLinksResponse> LIST_OUTGOING_TYPED_LINKS_FIELD = SdkField
            .<BatchListOutgoingTypedLinksResponse> builder(MarshallingType.SDK_POJO).memberName("ListOutgoingTypedLinks")
            .getter(getter(BatchReadSuccessfulResponse::listOutgoingTypedLinks)).setter(setter(Builder::listOutgoingTypedLinks))
            .constructor(BatchListOutgoingTypedLinksResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListOutgoingTypedLinks").build())
            .build();

    private static final SdkField<BatchListIncomingTypedLinksResponse> LIST_INCOMING_TYPED_LINKS_FIELD = SdkField
            .<BatchListIncomingTypedLinksResponse> builder(MarshallingType.SDK_POJO).memberName("ListIncomingTypedLinks")
            .getter(getter(BatchReadSuccessfulResponse::listIncomingTypedLinks)).setter(setter(Builder::listIncomingTypedLinks))
            .constructor(BatchListIncomingTypedLinksResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListIncomingTypedLinks").build())
            .build();

    private static final SdkField<BatchGetLinkAttributesResponse> GET_LINK_ATTRIBUTES_FIELD = SdkField
            .<BatchGetLinkAttributesResponse> builder(MarshallingType.SDK_POJO).memberName("GetLinkAttributes")
            .getter(getter(BatchReadSuccessfulResponse::getLinkAttributes)).setter(setter(Builder::getLinkAttributes))
            .constructor(BatchGetLinkAttributesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GetLinkAttributes").build()).build();

    private static final SdkField<BatchListObjectParentsResponse> LIST_OBJECT_PARENTS_FIELD = SdkField
            .<BatchListObjectParentsResponse> builder(MarshallingType.SDK_POJO).memberName("ListObjectParents")
            .getter(getter(BatchReadSuccessfulResponse::listObjectParents)).setter(setter(Builder::listObjectParents))
            .constructor(BatchListObjectParentsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListObjectParents").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_OBJECT_ATTRIBUTES_FIELD,
            LIST_OBJECT_CHILDREN_FIELD, GET_OBJECT_INFORMATION_FIELD, GET_OBJECT_ATTRIBUTES_FIELD, LIST_ATTACHED_INDICES_FIELD,
            LIST_OBJECT_PARENT_PATHS_FIELD, LIST_OBJECT_POLICIES_FIELD, LIST_POLICY_ATTACHMENTS_FIELD, LOOKUP_POLICY_FIELD,
            LIST_INDEX_FIELD, LIST_OUTGOING_TYPED_LINKS_FIELD, LIST_INCOMING_TYPED_LINKS_FIELD, GET_LINK_ATTRIBUTES_FIELD,
            LIST_OBJECT_PARENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchListObjectAttributesResponse listObjectAttributes;

    private final BatchListObjectChildrenResponse listObjectChildren;

    private final BatchGetObjectInformationResponse getObjectInformation;

    private final BatchGetObjectAttributesResponse getObjectAttributes;

    private final BatchListAttachedIndicesResponse listAttachedIndices;

    private final BatchListObjectParentPathsResponse listObjectParentPaths;

    private final BatchListObjectPoliciesResponse listObjectPolicies;

    private final BatchListPolicyAttachmentsResponse listPolicyAttachments;

    private final BatchLookupPolicyResponse lookupPolicy;

    private final BatchListIndexResponse listIndex;

    private final BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks;

    private final BatchListIncomingTypedLinksResponse listIncomingTypedLinks;

    private final BatchGetLinkAttributesResponse getLinkAttributes;

    private final BatchListObjectParentsResponse listObjectParents;

    private BatchReadSuccessfulResponse(BuilderImpl builder) {
        this.listObjectAttributes = builder.listObjectAttributes;
        this.listObjectChildren = builder.listObjectChildren;
        this.getObjectInformation = builder.getObjectInformation;
        this.getObjectAttributes = builder.getObjectAttributes;
        this.listAttachedIndices = builder.listAttachedIndices;
        this.listObjectParentPaths = builder.listObjectParentPaths;
        this.listObjectPolicies = builder.listObjectPolicies;
        this.listPolicyAttachments = builder.listPolicyAttachments;
        this.lookupPolicy = builder.lookupPolicy;
        this.listIndex = builder.listIndex;
        this.listOutgoingTypedLinks = builder.listOutgoingTypedLinks;
        this.listIncomingTypedLinks = builder.listIncomingTypedLinks;
        this.getLinkAttributes = builder.getLinkAttributes;
        this.listObjectParents = builder.listObjectParents;
    }

    /**
     * <p>
     * Lists all attributes that are associated with an object.
     * </p>
     * 
     * @return Lists all attributes that are associated with an object.
     */
    public final BatchListObjectAttributesResponse listObjectAttributes() {
        return listObjectAttributes;
    }

    /**
     * <p>
     * Returns a paginated list of child objects that are associated with a given object.
     * </p>
     * 
     * @return Returns a paginated list of child objects that are associated with a given object.
     */
    public final BatchListObjectChildrenResponse listObjectChildren() {
        return listObjectChildren;
    }

    /**
     * <p>
     * Retrieves metadata about an object.
     * </p>
     * 
     * @return Retrieves metadata about an object.
     */
    public final BatchGetObjectInformationResponse getObjectInformation() {
        return getObjectInformation;
    }

    /**
     * <p>
     * Retrieves attributes within a facet that are associated with an object.
     * </p>
     * 
     * @return Retrieves attributes within a facet that are associated with an object.
     */
    public final BatchGetObjectAttributesResponse getObjectAttributes() {
        return getObjectAttributes;
    }

    /**
     * <p>
     * Lists indices attached to an object.
     * </p>
     * 
     * @return Lists indices attached to an object.
     */
    public final BatchListAttachedIndicesResponse listAttachedIndices() {
        return listAttachedIndices;
    }

    /**
     * <p>
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
     * objects. For more information about objects, see <a
     * href="https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     * >Directory Structure</a>.
     * </p>
     * 
     * @return Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index
     *         node objects. For more information about objects, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
     *         >Directory Structure</a>.
     */
    public final BatchListObjectParentPathsResponse listObjectParentPaths() {
        return listObjectParentPaths;
    }

    /**
     * <p>
     * Returns policies attached to an object in pagination fashion.
     * </p>
     * 
     * @return Returns policies attached to an object in pagination fashion.
     */
    public final BatchListObjectPoliciesResponse listObjectPolicies() {
        return listObjectPolicies;
    }

    /**
     * <p>
     * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     * </p>
     * 
     * @return Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
     */
    public final BatchListPolicyAttachmentsResponse listPolicyAttachments() {
        return listPolicyAttachments;
    }

    /**
     * <p>
     * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
     * present, an empty list is returned. If policies are present, and if some objects don't have the policies
     * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
     * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to the
     * root from the target object are ignored. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     * >Policies</a>.
     * </p>
     * 
     * @return Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no
     *         policies present, an empty list is returned. If policies are present, and if some objects don't have the
     *         policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are
     *         present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>.
     *         Paths that don't lead to the root from the target object are ignored. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
     *         >Policies</a>.
     */
    public final BatchLookupPolicyResponse lookupPolicy() {
        return lookupPolicy;
    }

    /**
     * <p>
     * Lists objects attached to the specified index.
     * </p>
     * 
     * @return Lists objects attached to the specified index.
     */
    public final BatchListIndexResponse listIndex() {
        return listIndex;
    }

    /**
     * <p>
     * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
     *         supports filtering by typed link facet and identity attributes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks() {
        return listOutgoingTypedLinks;
    }

    /**
     * <p>
     * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     * supports filtering by typed link facet and identity attributes. For more information, see <a href=
     * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     * >Typed Links</a>.
     * </p>
     * 
     * @return Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
     *         supports filtering by typed link facet and identity attributes. For more information, see <a href=
     *         "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
     *         >Typed Links</a>.
     */
    public final BatchListIncomingTypedLinksResponse listIncomingTypedLinks() {
        return listIncomingTypedLinks;
    }

    /**
     * <p>
     * The list of attributes to retrieve from the typed link.
     * </p>
     * 
     * @return The list of attributes to retrieve from the typed link.
     */
    public final BatchGetLinkAttributesResponse getLinkAttributes() {
        return getLinkAttributes;
    }

    /**
     * <p>
     * The list of parent objects to retrieve.
     * </p>
     * 
     * @return The list of parent objects to retrieve.
     */
    public final BatchListObjectParentsResponse listObjectParents() {
        return listObjectParents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(listObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectChildren());
        hashCode = 31 * hashCode + Objects.hashCode(getObjectInformation());
        hashCode = 31 * hashCode + Objects.hashCode(getObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(listAttachedIndices());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectParentPaths());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(listPolicyAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(lookupPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(listIndex());
        hashCode = 31 * hashCode + Objects.hashCode(listOutgoingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(listIncomingTypedLinks());
        hashCode = 31 * hashCode + Objects.hashCode(getLinkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(listObjectParents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadSuccessfulResponse)) {
            return false;
        }
        BatchReadSuccessfulResponse other = (BatchReadSuccessfulResponse) obj;
        return Objects.equals(listObjectAttributes(), other.listObjectAttributes())
                && Objects.equals(listObjectChildren(), other.listObjectChildren())
                && Objects.equals(getObjectInformation(), other.getObjectInformation())
                && Objects.equals(getObjectAttributes(), other.getObjectAttributes())
                && Objects.equals(listAttachedIndices(), other.listAttachedIndices())
                && Objects.equals(listObjectParentPaths(), other.listObjectParentPaths())
                && Objects.equals(listObjectPolicies(), other.listObjectPolicies())
                && Objects.equals(listPolicyAttachments(), other.listPolicyAttachments())
                && Objects.equals(lookupPolicy(), other.lookupPolicy()) && Objects.equals(listIndex(), other.listIndex())
                && Objects.equals(listOutgoingTypedLinks(), other.listOutgoingTypedLinks())
                && Objects.equals(listIncomingTypedLinks(), other.listIncomingTypedLinks())
                && Objects.equals(getLinkAttributes(), other.getLinkAttributes())
                && Objects.equals(listObjectParents(), other.listObjectParents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchReadSuccessfulResponse").add("ListObjectAttributes", listObjectAttributes())
                .add("ListObjectChildren", listObjectChildren()).add("GetObjectInformation", getObjectInformation())
                .add("GetObjectAttributes", getObjectAttributes()).add("ListAttachedIndices", listAttachedIndices())
                .add("ListObjectParentPaths", listObjectParentPaths()).add("ListObjectPolicies", listObjectPolicies())
                .add("ListPolicyAttachments", listPolicyAttachments()).add("LookupPolicy", lookupPolicy())
                .add("ListIndex", listIndex()).add("ListOutgoingTypedLinks", listOutgoingTypedLinks())
                .add("ListIncomingTypedLinks", listIncomingTypedLinks()).add("GetLinkAttributes", getLinkAttributes())
                .add("ListObjectParents", listObjectParents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListObjectAttributes":
            return Optional.ofNullable(clazz.cast(listObjectAttributes()));
        case "ListObjectChildren":
            return Optional.ofNullable(clazz.cast(listObjectChildren()));
        case "GetObjectInformation":
            return Optional.ofNullable(clazz.cast(getObjectInformation()));
        case "GetObjectAttributes":
            return Optional.ofNullable(clazz.cast(getObjectAttributes()));
        case "ListAttachedIndices":
            return Optional.ofNullable(clazz.cast(listAttachedIndices()));
        case "ListObjectParentPaths":
            return Optional.ofNullable(clazz.cast(listObjectParentPaths()));
        case "ListObjectPolicies":
            return Optional.ofNullable(clazz.cast(listObjectPolicies()));
        case "ListPolicyAttachments":
            return Optional.ofNullable(clazz.cast(listPolicyAttachments()));
        case "LookupPolicy":
            return Optional.ofNullable(clazz.cast(lookupPolicy()));
        case "ListIndex":
            return Optional.ofNullable(clazz.cast(listIndex()));
        case "ListOutgoingTypedLinks":
            return Optional.ofNullable(clazz.cast(listOutgoingTypedLinks()));
        case "ListIncomingTypedLinks":
            return Optional.ofNullable(clazz.cast(listIncomingTypedLinks()));
        case "GetLinkAttributes":
            return Optional.ofNullable(clazz.cast(getLinkAttributes()));
        case "ListObjectParents":
            return Optional.ofNullable(clazz.cast(listObjectParents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchReadSuccessfulResponse, T> g) {
        return obj -> g.apply((BatchReadSuccessfulResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchReadSuccessfulResponse> {
        /**
         * <p>
         * Lists all attributes that are associated with an object.
         * </p>
         * 
         * @param listObjectAttributes
         *        Lists all attributes that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectAttributes(BatchListObjectAttributesResponse listObjectAttributes);

        /**
         * <p>
         * Lists all attributes that are associated with an object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchListObjectAttributesResponse.Builder} avoiding the need to create one manually via
         * {@link BatchListObjectAttributesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectAttributesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listObjectAttributes(BatchListObjectAttributesResponse)}.
         * 
         * @param listObjectAttributes
         *        a consumer that will call methods on {@link BatchListObjectAttributesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectAttributes(BatchListObjectAttributesResponse)
         */
        default Builder listObjectAttributes(Consumer<BatchListObjectAttributesResponse.Builder> listObjectAttributes) {
            return listObjectAttributes(BatchListObjectAttributesResponse.builder().applyMutation(listObjectAttributes).build());
        }

        /**
         * <p>
         * Returns a paginated list of child objects that are associated with a given object.
         * </p>
         * 
         * @param listObjectChildren
         *        Returns a paginated list of child objects that are associated with a given object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectChildren(BatchListObjectChildrenResponse listObjectChildren);

        /**
         * <p>
         * Returns a paginated list of child objects that are associated with a given object.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchListObjectChildrenResponse.Builder}
         * avoiding the need to create one manually via {@link BatchListObjectChildrenResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectChildrenResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listObjectChildren(BatchListObjectChildrenResponse)}.
         * 
         * @param listObjectChildren
         *        a consumer that will call methods on {@link BatchListObjectChildrenResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectChildren(BatchListObjectChildrenResponse)
         */
        default Builder listObjectChildren(Consumer<BatchListObjectChildrenResponse.Builder> listObjectChildren) {
            return listObjectChildren(BatchListObjectChildrenResponse.builder().applyMutation(listObjectChildren).build());
        }

        /**
         * <p>
         * Retrieves metadata about an object.
         * </p>
         * 
         * @param getObjectInformation
         *        Retrieves metadata about an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getObjectInformation(BatchGetObjectInformationResponse getObjectInformation);

        /**
         * <p>
         * Retrieves metadata about an object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchGetObjectInformationResponse.Builder} avoiding the need to create one manually via
         * {@link BatchGetObjectInformationResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetObjectInformationResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #getObjectInformation(BatchGetObjectInformationResponse)}.
         * 
         * @param getObjectInformation
         *        a consumer that will call methods on {@link BatchGetObjectInformationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getObjectInformation(BatchGetObjectInformationResponse)
         */
        default Builder getObjectInformation(Consumer<BatchGetObjectInformationResponse.Builder> getObjectInformation) {
            return getObjectInformation(BatchGetObjectInformationResponse.builder().applyMutation(getObjectInformation).build());
        }

        /**
         * <p>
         * Retrieves attributes within a facet that are associated with an object.
         * </p>
         * 
         * @param getObjectAttributes
         *        Retrieves attributes within a facet that are associated with an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getObjectAttributes(BatchGetObjectAttributesResponse getObjectAttributes);

        /**
         * <p>
         * Retrieves attributes within a facet that are associated with an object.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchGetObjectAttributesResponse.Builder}
         * avoiding the need to create one manually via {@link BatchGetObjectAttributesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetObjectAttributesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #getObjectAttributes(BatchGetObjectAttributesResponse)}.
         * 
         * @param getObjectAttributes
         *        a consumer that will call methods on {@link BatchGetObjectAttributesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getObjectAttributes(BatchGetObjectAttributesResponse)
         */
        default Builder getObjectAttributes(Consumer<BatchGetObjectAttributesResponse.Builder> getObjectAttributes) {
            return getObjectAttributes(BatchGetObjectAttributesResponse.builder().applyMutation(getObjectAttributes).build());
        }

        /**
         * <p>
         * Lists indices attached to an object.
         * </p>
         * 
         * @param listAttachedIndices
         *        Lists indices attached to an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listAttachedIndices(BatchListAttachedIndicesResponse listAttachedIndices);

        /**
         * <p>
         * Lists indices attached to an object.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchListAttachedIndicesResponse.Builder}
         * avoiding the need to create one manually via {@link BatchListAttachedIndicesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListAttachedIndicesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listAttachedIndices(BatchListAttachedIndicesResponse)}.
         * 
         * @param listAttachedIndices
         *        a consumer that will call methods on {@link BatchListAttachedIndicesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listAttachedIndices(BatchListAttachedIndicesResponse)
         */
        default Builder listAttachedIndices(Consumer<BatchListAttachedIndicesResponse.Builder> listAttachedIndices) {
            return listAttachedIndices(BatchListAttachedIndicesResponse.builder().applyMutation(listAttachedIndices).build());
        }

        /**
         * <p>
         * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
         * objects. For more information about objects, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         * >Directory Structure</a>.
         * </p>
         * 
         * @param listObjectParentPaths
         *        Retrieves all available parent paths for any object type such as node, leaf node, policy node, and
         *        index node objects. For more information about objects, see <a href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         *        >Directory Structure</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectParentPaths(BatchListObjectParentPathsResponse listObjectParentPaths);

        /**
         * <p>
         * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node
         * objects. For more information about objects, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html"
         * >Directory Structure</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchListObjectParentPathsResponse.Builder} avoiding the need to create one manually via
         * {@link BatchListObjectParentPathsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectParentPathsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listObjectParentPaths(BatchListObjectParentPathsResponse)}.
         * 
         * @param listObjectParentPaths
         *        a consumer that will call methods on {@link BatchListObjectParentPathsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectParentPaths(BatchListObjectParentPathsResponse)
         */
        default Builder listObjectParentPaths(Consumer<BatchListObjectParentPathsResponse.Builder> listObjectParentPaths) {
            return listObjectParentPaths(BatchListObjectParentPathsResponse.builder().applyMutation(listObjectParentPaths)
                    .build());
        }

        /**
         * <p>
         * Returns policies attached to an object in pagination fashion.
         * </p>
         * 
         * @param listObjectPolicies
         *        Returns policies attached to an object in pagination fashion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectPolicies(BatchListObjectPoliciesResponse listObjectPolicies);

        /**
         * <p>
         * Returns policies attached to an object in pagination fashion.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchListObjectPoliciesResponse.Builder}
         * avoiding the need to create one manually via {@link BatchListObjectPoliciesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectPoliciesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listObjectPolicies(BatchListObjectPoliciesResponse)}.
         * 
         * @param listObjectPolicies
         *        a consumer that will call methods on {@link BatchListObjectPoliciesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectPolicies(BatchListObjectPoliciesResponse)
         */
        default Builder listObjectPolicies(Consumer<BatchListObjectPoliciesResponse.Builder> listObjectPolicies) {
            return listObjectPolicies(BatchListObjectPoliciesResponse.builder().applyMutation(listObjectPolicies).build());
        }

        /**
         * <p>
         * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * </p>
         * 
         * @param listPolicyAttachments
         *        Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listPolicyAttachments(BatchListPolicyAttachmentsResponse listPolicyAttachments);

        /**
         * <p>
         * Returns all of the <code>ObjectIdentifiers</code> to which a given policy is attached.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchListPolicyAttachmentsResponse.Builder} avoiding the need to create one manually via
         * {@link BatchListPolicyAttachmentsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListPolicyAttachmentsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listPolicyAttachments(BatchListPolicyAttachmentsResponse)}.
         * 
         * @param listPolicyAttachments
         *        a consumer that will call methods on {@link BatchListPolicyAttachmentsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listPolicyAttachments(BatchListPolicyAttachmentsResponse)
         */
        default Builder listPolicyAttachments(Consumer<BatchListPolicyAttachmentsResponse.Builder> listPolicyAttachments) {
            return listPolicyAttachments(BatchListPolicyAttachmentsResponse.builder().applyMutation(listPolicyAttachments)
                    .build());
        }

        /**
         * <p>
         * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
         * present, an empty list is returned. If policies are present, and if some objects don't have the policies
         * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
         * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to
         * the root from the target object are ignored. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * 
         * @param lookupPolicy
         *        Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no
         *        policies present, an empty list is returned. If policies are present, and if some objects don't have
         *        the policies attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are
         *        present, it returns <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>.
         *        Paths that don't lead to the root from the target object are ignored. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         *        >Policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookupPolicy(BatchLookupPolicyResponse lookupPolicy);

        /**
         * <p>
         * Lists all policies from the root of the <a>Directory</a> to the object specified. If there are no policies
         * present, an empty list is returned. If policies are present, and if some objects don't have the policies
         * attached, it returns the <code>ObjectIdentifier</code> for such objects. If policies are present, it returns
         * <code>ObjectIdentifier</code>, <code>policyId</code>, and <code>policyType</code>. Paths that don't lead to
         * the root from the target object are ignored. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies"
         * >Policies</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchLookupPolicyResponse.Builder}
         * avoiding the need to create one manually via {@link BatchLookupPolicyResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchLookupPolicyResponse.Builder#build()} is called immediately
         * and its result is passed to {@link #lookupPolicy(BatchLookupPolicyResponse)}.
         * 
         * @param lookupPolicy
         *        a consumer that will call methods on {@link BatchLookupPolicyResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lookupPolicy(BatchLookupPolicyResponse)
         */
        default Builder lookupPolicy(Consumer<BatchLookupPolicyResponse.Builder> lookupPolicy) {
            return lookupPolicy(BatchLookupPolicyResponse.builder().applyMutation(lookupPolicy).build());
        }

        /**
         * <p>
         * Lists objects attached to the specified index.
         * </p>
         * 
         * @param listIndex
         *        Lists objects attached to the specified index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listIndex(BatchListIndexResponse listIndex);

        /**
         * <p>
         * Lists objects attached to the specified index.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchListIndexResponse.Builder} avoiding
         * the need to create one manually via {@link BatchListIndexResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListIndexResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #listIndex(BatchListIndexResponse)}.
         * 
         * @param listIndex
         *        a consumer that will call methods on {@link BatchListIndexResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listIndex(BatchListIndexResponse)
         */
        default Builder listIndex(Consumer<BatchListIndexResponse.Builder> listIndex) {
            return listIndex(BatchListIndexResponse.builder().applyMutation(listIndex).build());
        }

        /**
         * <p>
         * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param listOutgoingTypedLinks
         *        Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It
         *        also supports filtering by typed link facet and identity attributes. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks);

        /**
         * <p>
         * Returns a paginated list of all the outgoing <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchListOutgoingTypedLinksResponse.Builder} avoiding the need to create one manually via
         * {@link BatchListOutgoingTypedLinksResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListOutgoingTypedLinksResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse)}.
         * 
         * @param listOutgoingTypedLinks
         *        a consumer that will call methods on {@link BatchListOutgoingTypedLinksResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse)
         */
        default Builder listOutgoingTypedLinks(Consumer<BatchListOutgoingTypedLinksResponse.Builder> listOutgoingTypedLinks) {
            return listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse.builder().applyMutation(listOutgoingTypedLinks)
                    .build());
        }

        /**
         * <p>
         * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * 
         * @param listIncomingTypedLinks
         *        Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It
         *        also supports filtering by typed link facet and identity attributes. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         *        >Typed Links</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listIncomingTypedLinks(BatchListIncomingTypedLinksResponse listIncomingTypedLinks);

        /**
         * <p>
         * Returns a paginated list of all the incoming <a>TypedLinkSpecifier</a> information for an object. It also
         * supports filtering by typed link facet and identity attributes. For more information, see <a href=
         * "https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink"
         * >Typed Links</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BatchListIncomingTypedLinksResponse.Builder} avoiding the need to create one manually via
         * {@link BatchListIncomingTypedLinksResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListIncomingTypedLinksResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listIncomingTypedLinks(BatchListIncomingTypedLinksResponse)}.
         * 
         * @param listIncomingTypedLinks
         *        a consumer that will call methods on {@link BatchListIncomingTypedLinksResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listIncomingTypedLinks(BatchListIncomingTypedLinksResponse)
         */
        default Builder listIncomingTypedLinks(Consumer<BatchListIncomingTypedLinksResponse.Builder> listIncomingTypedLinks) {
            return listIncomingTypedLinks(BatchListIncomingTypedLinksResponse.builder().applyMutation(listIncomingTypedLinks)
                    .build());
        }

        /**
         * <p>
         * The list of attributes to retrieve from the typed link.
         * </p>
         * 
         * @param getLinkAttributes
         *        The list of attributes to retrieve from the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder getLinkAttributes(BatchGetLinkAttributesResponse getLinkAttributes);

        /**
         * <p>
         * The list of attributes to retrieve from the typed link.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchGetLinkAttributesResponse.Builder}
         * avoiding the need to create one manually via {@link BatchGetLinkAttributesResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchGetLinkAttributesResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #getLinkAttributes(BatchGetLinkAttributesResponse)}.
         * 
         * @param getLinkAttributes
         *        a consumer that will call methods on {@link BatchGetLinkAttributesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #getLinkAttributes(BatchGetLinkAttributesResponse)
         */
        default Builder getLinkAttributes(Consumer<BatchGetLinkAttributesResponse.Builder> getLinkAttributes) {
            return getLinkAttributes(BatchGetLinkAttributesResponse.builder().applyMutation(getLinkAttributes).build());
        }

        /**
         * <p>
         * The list of parent objects to retrieve.
         * </p>
         * 
         * @param listObjectParents
         *        The list of parent objects to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listObjectParents(BatchListObjectParentsResponse listObjectParents);

        /**
         * <p>
         * The list of parent objects to retrieve.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchListObjectParentsResponse.Builder}
         * avoiding the need to create one manually via {@link BatchListObjectParentsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchListObjectParentsResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #listObjectParents(BatchListObjectParentsResponse)}.
         * 
         * @param listObjectParents
         *        a consumer that will call methods on {@link BatchListObjectParentsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listObjectParents(BatchListObjectParentsResponse)
         */
        default Builder listObjectParents(Consumer<BatchListObjectParentsResponse.Builder> listObjectParents) {
            return listObjectParents(BatchListObjectParentsResponse.builder().applyMutation(listObjectParents).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchListObjectAttributesResponse listObjectAttributes;

        private BatchListObjectChildrenResponse listObjectChildren;

        private BatchGetObjectInformationResponse getObjectInformation;

        private BatchGetObjectAttributesResponse getObjectAttributes;

        private BatchListAttachedIndicesResponse listAttachedIndices;

        private BatchListObjectParentPathsResponse listObjectParentPaths;

        private BatchListObjectPoliciesResponse listObjectPolicies;

        private BatchListPolicyAttachmentsResponse listPolicyAttachments;

        private BatchLookupPolicyResponse lookupPolicy;

        private BatchListIndexResponse listIndex;

        private BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks;

        private BatchListIncomingTypedLinksResponse listIncomingTypedLinks;

        private BatchGetLinkAttributesResponse getLinkAttributes;

        private BatchListObjectParentsResponse listObjectParents;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReadSuccessfulResponse model) {
            listObjectAttributes(model.listObjectAttributes);
            listObjectChildren(model.listObjectChildren);
            getObjectInformation(model.getObjectInformation);
            getObjectAttributes(model.getObjectAttributes);
            listAttachedIndices(model.listAttachedIndices);
            listObjectParentPaths(model.listObjectParentPaths);
            listObjectPolicies(model.listObjectPolicies);
            listPolicyAttachments(model.listPolicyAttachments);
            lookupPolicy(model.lookupPolicy);
            listIndex(model.listIndex);
            listOutgoingTypedLinks(model.listOutgoingTypedLinks);
            listIncomingTypedLinks(model.listIncomingTypedLinks);
            getLinkAttributes(model.getLinkAttributes);
            listObjectParents(model.listObjectParents);
        }

        public final BatchListObjectAttributesResponse.Builder getListObjectAttributes() {
            return listObjectAttributes != null ? listObjectAttributes.toBuilder() : null;
        }

        public final void setListObjectAttributes(BatchListObjectAttributesResponse.BuilderImpl listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes != null ? listObjectAttributes.build() : null;
        }

        @Override
        public final Builder listObjectAttributes(BatchListObjectAttributesResponse listObjectAttributes) {
            this.listObjectAttributes = listObjectAttributes;
            return this;
        }

        public final BatchListObjectChildrenResponse.Builder getListObjectChildren() {
            return listObjectChildren != null ? listObjectChildren.toBuilder() : null;
        }

        public final void setListObjectChildren(BatchListObjectChildrenResponse.BuilderImpl listObjectChildren) {
            this.listObjectChildren = listObjectChildren != null ? listObjectChildren.build() : null;
        }

        @Override
        public final Builder listObjectChildren(BatchListObjectChildrenResponse listObjectChildren) {
            this.listObjectChildren = listObjectChildren;
            return this;
        }

        public final BatchGetObjectInformationResponse.Builder getGetObjectInformation() {
            return getObjectInformation != null ? getObjectInformation.toBuilder() : null;
        }

        public final void setGetObjectInformation(BatchGetObjectInformationResponse.BuilderImpl getObjectInformation) {
            this.getObjectInformation = getObjectInformation != null ? getObjectInformation.build() : null;
        }

        @Override
        public final Builder getObjectInformation(BatchGetObjectInformationResponse getObjectInformation) {
            this.getObjectInformation = getObjectInformation;
            return this;
        }

        public final BatchGetObjectAttributesResponse.Builder getGetObjectAttributes() {
            return getObjectAttributes != null ? getObjectAttributes.toBuilder() : null;
        }

        public final void setGetObjectAttributes(BatchGetObjectAttributesResponse.BuilderImpl getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes != null ? getObjectAttributes.build() : null;
        }

        @Override
        public final Builder getObjectAttributes(BatchGetObjectAttributesResponse getObjectAttributes) {
            this.getObjectAttributes = getObjectAttributes;
            return this;
        }

        public final BatchListAttachedIndicesResponse.Builder getListAttachedIndices() {
            return listAttachedIndices != null ? listAttachedIndices.toBuilder() : null;
        }

        public final void setListAttachedIndices(BatchListAttachedIndicesResponse.BuilderImpl listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices != null ? listAttachedIndices.build() : null;
        }

        @Override
        public final Builder listAttachedIndices(BatchListAttachedIndicesResponse listAttachedIndices) {
            this.listAttachedIndices = listAttachedIndices;
            return this;
        }

        public final BatchListObjectParentPathsResponse.Builder getListObjectParentPaths() {
            return listObjectParentPaths != null ? listObjectParentPaths.toBuilder() : null;
        }

        public final void setListObjectParentPaths(BatchListObjectParentPathsResponse.BuilderImpl listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths != null ? listObjectParentPaths.build() : null;
        }

        @Override
        public final Builder listObjectParentPaths(BatchListObjectParentPathsResponse listObjectParentPaths) {
            this.listObjectParentPaths = listObjectParentPaths;
            return this;
        }

        public final BatchListObjectPoliciesResponse.Builder getListObjectPolicies() {
            return listObjectPolicies != null ? listObjectPolicies.toBuilder() : null;
        }

        public final void setListObjectPolicies(BatchListObjectPoliciesResponse.BuilderImpl listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies != null ? listObjectPolicies.build() : null;
        }

        @Override
        public final Builder listObjectPolicies(BatchListObjectPoliciesResponse listObjectPolicies) {
            this.listObjectPolicies = listObjectPolicies;
            return this;
        }

        public final BatchListPolicyAttachmentsResponse.Builder getListPolicyAttachments() {
            return listPolicyAttachments != null ? listPolicyAttachments.toBuilder() : null;
        }

        public final void setListPolicyAttachments(BatchListPolicyAttachmentsResponse.BuilderImpl listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments != null ? listPolicyAttachments.build() : null;
        }

        @Override
        public final Builder listPolicyAttachments(BatchListPolicyAttachmentsResponse listPolicyAttachments) {
            this.listPolicyAttachments = listPolicyAttachments;
            return this;
        }

        public final BatchLookupPolicyResponse.Builder getLookupPolicy() {
            return lookupPolicy != null ? lookupPolicy.toBuilder() : null;
        }

        public final void setLookupPolicy(BatchLookupPolicyResponse.BuilderImpl lookupPolicy) {
            this.lookupPolicy = lookupPolicy != null ? lookupPolicy.build() : null;
        }

        @Override
        public final Builder lookupPolicy(BatchLookupPolicyResponse lookupPolicy) {
            this.lookupPolicy = lookupPolicy;
            return this;
        }

        public final BatchListIndexResponse.Builder getListIndex() {
            return listIndex != null ? listIndex.toBuilder() : null;
        }

        public final void setListIndex(BatchListIndexResponse.BuilderImpl listIndex) {
            this.listIndex = listIndex != null ? listIndex.build() : null;
        }

        @Override
        public final Builder listIndex(BatchListIndexResponse listIndex) {
            this.listIndex = listIndex;
            return this;
        }

        public final BatchListOutgoingTypedLinksResponse.Builder getListOutgoingTypedLinks() {
            return listOutgoingTypedLinks != null ? listOutgoingTypedLinks.toBuilder() : null;
        }

        public final void setListOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse.BuilderImpl listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks != null ? listOutgoingTypedLinks.build() : null;
        }

        @Override
        public final Builder listOutgoingTypedLinks(BatchListOutgoingTypedLinksResponse listOutgoingTypedLinks) {
            this.listOutgoingTypedLinks = listOutgoingTypedLinks;
            return this;
        }

        public final BatchListIncomingTypedLinksResponse.Builder getListIncomingTypedLinks() {
            return listIncomingTypedLinks != null ? listIncomingTypedLinks.toBuilder() : null;
        }

        public final void setListIncomingTypedLinks(BatchListIncomingTypedLinksResponse.BuilderImpl listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks != null ? listIncomingTypedLinks.build() : null;
        }

        @Override
        public final Builder listIncomingTypedLinks(BatchListIncomingTypedLinksResponse listIncomingTypedLinks) {
            this.listIncomingTypedLinks = listIncomingTypedLinks;
            return this;
        }

        public final BatchGetLinkAttributesResponse.Builder getGetLinkAttributes() {
            return getLinkAttributes != null ? getLinkAttributes.toBuilder() : null;
        }

        public final void setGetLinkAttributes(BatchGetLinkAttributesResponse.BuilderImpl getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes != null ? getLinkAttributes.build() : null;
        }

        @Override
        public final Builder getLinkAttributes(BatchGetLinkAttributesResponse getLinkAttributes) {
            this.getLinkAttributes = getLinkAttributes;
            return this;
        }

        public final BatchListObjectParentsResponse.Builder getListObjectParents() {
            return listObjectParents != null ? listObjectParents.toBuilder() : null;
        }

        public final void setListObjectParents(BatchListObjectParentsResponse.BuilderImpl listObjectParents) {
            this.listObjectParents = listObjectParents != null ? listObjectParents.build() : null;
        }

        @Override
        public final Builder listObjectParents(BatchListObjectParentsResponse listObjectParents) {
            this.listObjectParents = listObjectParents;
            return this;
        }

        @Override
        public BatchReadSuccessfulResponse build() {
            return new BatchReadSuccessfulResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
